/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.arrays;

import org.openstreetmap.atlas.utilities.arrays.LargeArray;
import org.openstreetmap.atlas.utilities.arrays.PrimitiveArray;

public class ShortArray
extends LargeArray<Short> {
    private static final long serialVersionUID = 6867216948199207925L;

    public ShortArray(long maximumSize) {
        super(maximumSize);
    }

    public ShortArray(long maximumSize, int memoryBlockSize, int subArraySize) {
        super(maximumSize, memoryBlockSize, subArraySize);
    }

    @Override
    protected PrimitiveArray<Short> getNewArray(int size) {
        return new ShortPrimitiveArray(size);
    }

    public static class ShortPrimitiveArray
    extends PrimitiveArray<Short> {
        private static final long serialVersionUID = 3177690048477030833L;
        private final short[] array = new short[this.size()];

        public ShortPrimitiveArray(int size) {
            super(size);
        }

        @Override
        public Short get(int index) {
            return this.array[index];
        }

        @Override
        public PrimitiveArray<Short> getNewArray(int size) {
            return new ShortPrimitiveArray(size);
        }

        @Override
        public void set(int index, Short item) {
            this.array[index] = item;
        }
    }
}

