/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.arrays;

import java.util.Objects;
import org.openstreetmap.atlas.proto.ProtoSerializable;
import org.openstreetmap.atlas.proto.adapters.ProtoAdapter;
import org.openstreetmap.atlas.proto.adapters.ProtoLongArrayOfArraysAdapter;
import org.openstreetmap.atlas.utilities.arrays.LargeArray;
import org.openstreetmap.atlas.utilities.arrays.PrimitiveArray;

public class LongArrayOfArrays
extends LargeArray<long[]>
implements ProtoSerializable {
    private static final long serialVersionUID = -1847060797258075365L;

    public LongArrayOfArrays(long maximumSize) {
        super(maximumSize);
    }

    public LongArrayOfArrays(long maximumSize, int memoryBlockSize, int subArraySize) {
        super(maximumSize, memoryBlockSize, subArraySize);
    }

    private LongArrayOfArrays() {
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof LongArrayOfArrays) {
            if (this == other) {
                return true;
            }
            LongArrayOfArrays that = (LongArrayOfArrays)other;
            if (!Objects.equals(this.getName(), that.getName())) {
                return false;
            }
            if (this.size() != that.size()) {
                return false;
            }
            for (long index = 0L; index < this.size(); ++index) {
                long[] thatSubArray;
                long[] thisSubArray = (long[])this.get(index);
                if (thisSubArray.length != (thatSubArray = (long[])that.get(index)).length) {
                    return false;
                }
                for (int subIndex = 0; subIndex < thisSubArray.length; ++subIndex) {
                    if (thisSubArray[subIndex] == thatSubArray[subIndex]) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public ProtoAdapter getProtoAdapter() {
        return new ProtoLongArrayOfArraysAdapter();
    }

    @Override
    public int hashCode() {
        int initialPrime = 31;
        int hashSeed = 37;
        int nameHash = this.getName() == null ? 0 : this.getName().hashCode();
        int hash = 1147 + nameHash;
        hash = 37 * hash + Long.valueOf(this.size()).hashCode();
        for (long index = 0L; index < this.size(); ++index) {
            hash = 37 * hash + ((long[])this.get(index)).hashCode();
        }
        return hash;
    }

    @Override
    protected PrimitiveArray<long[]> getNewArray(int size) {
        return new PrimitiveLongArrayArray(size);
    }

    public static class PrimitiveLongArrayArray
    extends PrimitiveArray<long[]> {
        private static final long serialVersionUID = 8377199081867533638L;
        private final long[][] array = new long[this.size()][];

        public PrimitiveLongArrayArray(int size) {
            super(size);
        }

        @Override
        public long[] get(int index) {
            return this.array[index];
        }

        @Override
        public PrimitiveArray<long[]> getNewArray(int size) {
            return new PrimitiveLongArrayArray(size);
        }

        @Override
        public void set(int index, long[] item) {
            this.array[index] = item;
        }
    }
}

