/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.arrays;

import org.openstreetmap.atlas.proto.ProtoSerializable;
import org.openstreetmap.atlas.proto.adapters.ProtoAdapter;
import org.openstreetmap.atlas.proto.adapters.ProtoLongArrayAdapter;
import org.openstreetmap.atlas.utilities.arrays.LargeArray;
import org.openstreetmap.atlas.utilities.arrays.PrimitiveArray;

public class LongArray
extends LargeArray<Long>
implements ProtoSerializable {
    private static final long serialVersionUID = -6368556371326217582L;

    public LongArray(long maximumSize) {
        super(maximumSize);
    }

    public LongArray(long maximumSize, int memoryBlockSize, int subArraySize) {
        super(maximumSize, memoryBlockSize, subArraySize);
    }

    private LongArray() {
    }

    @Override
    public ProtoAdapter getProtoAdapter() {
        return new ProtoLongArrayAdapter();
    }

    @Override
    protected PrimitiveArray<Long> getNewArray(int size) {
        return new PrimitiveLongArray(size);
    }

    public static class PrimitiveLongArray
    extends PrimitiveArray<Long> {
        private static final long serialVersionUID = 8325024756132919495L;
        private final long[] array = new long[this.size()];

        public PrimitiveLongArray(int size) {
            super(size);
        }

        @Override
        public Long get(int index) {
            return this.array[index];
        }

        @Override
        public PrimitiveArray<Long> getNewArray(int size) {
            return new PrimitiveLongArray(size);
        }

        @Override
        public void set(int index, Long item) {
            this.array[index] = item;
        }
    }
}

