/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.arrays;

import java.util.Objects;
import org.openstreetmap.atlas.proto.ProtoSerializable;
import org.openstreetmap.atlas.proto.adapters.ProtoAdapter;
import org.openstreetmap.atlas.proto.adapters.ProtoByteArrayOfArraysAdapter;
import org.openstreetmap.atlas.utilities.arrays.LargeArray;
import org.openstreetmap.atlas.utilities.arrays.PrimitiveArray;

public class ByteArrayOfArrays
extends LargeArray<byte[]>
implements ProtoSerializable {
    private static final long serialVersionUID = 9114627155973700091L;

    public ByteArrayOfArrays(long maximumSize) {
        super(maximumSize);
    }

    public ByteArrayOfArrays(long maximumSize, int memoryBlockSize, int subArraySize) {
        super(maximumSize, memoryBlockSize, subArraySize);
    }

    private ByteArrayOfArrays() {
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ByteArrayOfArrays) {
            if (this == other) {
                return true;
            }
            ByteArrayOfArrays that = (ByteArrayOfArrays)other;
            if (!Objects.equals(this.getName(), that.getName())) {
                return false;
            }
            if (this.size() != that.size()) {
                return false;
            }
            for (long index = 0L; index < this.size(); ++index) {
                byte[] thatSubArray;
                byte[] thisSubArray = (byte[])this.get(index);
                if (thisSubArray.length != (thatSubArray = (byte[])that.get(index)).length) {
                    return false;
                }
                for (int subIndex = 0; subIndex < thisSubArray.length; ++subIndex) {
                    if (thisSubArray[subIndex] == thatSubArray[subIndex]) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public ProtoAdapter getProtoAdapter() {
        return new ProtoByteArrayOfArraysAdapter();
    }

    @Override
    public int hashCode() {
        int initialPrime = 31;
        int hashSeed = 37;
        int hash = 31;
        int index = 0;
        while ((long)index < this.size()) {
            hash = 37 * hash + ((byte[])this.get(index)).hashCode();
            ++index;
        }
        return hash;
    }

    @Override
    protected PrimitiveArray<byte[]> getNewArray(int size) {
        return new PrimitiveByteArrayArray(size);
    }

    public static class PrimitiveByteArrayArray
    extends PrimitiveArray<byte[]> {
        private static final long serialVersionUID = -89500356133572470L;
        private final byte[][] array = new byte[this.size()][];

        public PrimitiveByteArrayArray(int size) {
            super(size);
        }

        @Override
        public byte[] get(int index) {
            return this.array[index];
        }

        @Override
        public PrimitiveArray<byte[]> getNewArray(int size) {
            return new PrimitiveByteArrayArray(size);
        }

        @Override
        public void set(int index, byte[] item) {
            this.array[index] = item;
        }
    }
}

