/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.arrays;

import org.openstreetmap.atlas.utilities.arrays.LargeArray;
import org.openstreetmap.atlas.utilities.arrays.PrimitiveArray;

public class ByteArray
extends LargeArray<Byte> {
    private static final long serialVersionUID = 6401198662134364211L;

    public ByteArray(long maximumSize) {
        super(maximumSize);
    }

    public ByteArray(long maximumSize, int memoryBlockSize, int subArraySize) {
        super(maximumSize, memoryBlockSize, subArraySize);
    }

    @Override
    protected PrimitiveArray<Byte> getNewArray(int size) {
        return new BytePrimitiveArray(size);
    }

    public static class BytePrimitiveArray
    extends PrimitiveArray<Byte> {
        private static final long serialVersionUID = 6928093441524751750L;
        private final byte[] array = new byte[this.size()];

        public BytePrimitiveArray(int size) {
            super(size);
        }

        @Override
        public Byte get(int index) {
            return this.array[index];
        }

        @Override
        public PrimitiveArray<Byte> getNewArray(int size) {
            return new BytePrimitiveArray(size);
        }

        @Override
        public void set(int index, Byte item) {
            this.array[index] = item;
        }
    }
}

