/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.arrays;

import org.openstreetmap.atlas.utilities.arrays.LargeArray;
import org.openstreetmap.atlas.utilities.arrays.PrimitiveArray;

public class BitArray
extends LargeArray<Boolean> {
    private static final long serialVersionUID = -342493023854989301L;

    public BitArray(long maximumSize) {
        super(maximumSize);
    }

    public BitArray(long maximumSize, int memoryBlockSize, int subArraySize) {
        super(maximumSize, memoryBlockSize, subArraySize);
    }

    @Override
    protected PrimitiveArray<Boolean> getNewArray(int size) {
        return new BitPrimitiveArray(size);
    }

    public static class BitPrimitiveArray
    extends PrimitiveArray<Boolean> {
        private static final long serialVersionUID = 5686729947785133814L;
        private final boolean[] array = new boolean[this.size()];

        public BitPrimitiveArray(int size) {
            super(size);
        }

        @Override
        public Boolean get(int index) {
            return this.array[index];
        }

        @Override
        public PrimitiveArray<Boolean> getNewArray(int size) {
            return new BitPrimitiveArray(size);
        }

        @Override
        public void set(int index, Boolean item) {
            this.array[index] = item;
        }
    }
}

