/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.archive;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collections;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.openstreetmap.atlas.streaming.NotifyingIOUtils;
import org.openstreetmap.atlas.utilities.archive.AbstractArchiverOrExtractor;
import org.openstreetmap.atlas.utilities.archive.ArchiveVetoDelegate;
import org.openstreetmap.atlas.utilities.archive.ArchiverEventListener;
import org.openstreetmap.atlas.utilities.archive.DefaultZipVetoDelegate;

public final class Extractor
extends AbstractArchiverOrExtractor<Extractor> {
    private final File outputDirectory;
    private int errorCount;
    private boolean skipExisting;

    public static Extractor extractZipArchive(File outputDirectory) throws ArchiveException, IOException {
        if (outputDirectory == null) {
            throw new IllegalArgumentException("outputDirectory is null");
        }
        return new Extractor(outputDirectory);
    }

    public static Extractor extractZipArchive(Path outputDirectory) throws ArchiveException, IOException {
        if (outputDirectory == null) {
            throw new IllegalArgumentException("outputDirectory is null");
        }
        return new Extractor(outputDirectory.toFile());
    }

    private Extractor(File output) {
        super(Extractor.class);
        this.outputDirectory = output;
        this.setVetoDelegate((ArchiveVetoDelegate)new DefaultZipVetoDelegate());
    }

    public Extractor addArchiverEventListener(ArchiverEventListener<Extractor> listener) {
        super.addArchiverEventListener(listener);
        return this;
    }

    public Extractor extract(File inputFile) throws ArchiveException, IOException {
        if (inputFile == null) {
            throw new IllegalArgumentException("inputFile can't be null");
        }
        if (this.outputDirectory == null) {
            throw new IllegalStateException("outputDirectory can't be null");
        }
        if (this.outputDirectory.exists()) {
            FileUtils.deleteQuietly(this.outputDirectory);
        }
        if (!this.outputDirectory.mkdirs()) {
            throw new IOException(String.format("%s can't be created", this.outputDirectory.getAbsolutePath()));
        }
        this.fireArchiveStarted();
        try (ZipFile file = new ZipFile(inputFile);){
            for (ZipArchiveEntry current : Collections.list(file.getEntries())) {
                File outputFile = new File(this.outputDirectory, current.getName());
                if (this.shouldSkip(outputFile)) {
                    this.fireItemSkipped(outputFile);
                    continue;
                }
                if (outputFile.exists() && this.skipExisting) {
                    this.fireItemSkipped(outputFile);
                    continue;
                }
                if (current.isDirectory()) continue;
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(outputFile));
                Throwable throwable = null;
                try {
                    InputStream inputStream = file.getInputStream(current);
                    Throwable throwable2 = null;
                    try {
                        outputFile.getParentFile().mkdirs();
                        NotifyingIOUtils.copy(inputStream, bos, new Progress(outputFile, current.getSize()));
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable2 != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (bos == null) continue;
                    if (throwable != null) {
                        try {
                            bos.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    bos.close();
                }
            }
            if (this.errorCount > 0) {
                this.fireArchiveFailed();
            } else {
                this.fireArchiveCompleted();
            }
        }
        return this;
    }

    public Extractor extract(Path inputPath) throws ArchiveException, IOException {
        if (inputPath == null) {
            throw new IllegalArgumentException("inputFile can't be null");
        }
        return this.extract(inputPath.toFile());
    }

    public Extractor overwriteExisting() {
        this.skipExisting = false;
        return this;
    }

    public Extractor removeArchiverEventListener(ArchiverEventListener<Extractor> listener) {
        super.removeArchiverEventListener(listener);
        return this;
    }

    public Extractor setVetoDelegate(ArchiveVetoDelegate<Extractor> delegate) {
        super.setVetoDelegate(delegate);
        return this;
    }

    public Extractor skipExisting() {
        this.skipExisting = true;
        return this;
    }

    class Progress
    implements NotifyingIOUtils.IOProgressListener {
        private final File file;
        private final long length;

        Progress(File file, long length) {
            this.file = file;
            this.length = length;
        }

        @Override
        public void completed() {
            Extractor.this.fireItemCompleted(this.file);
        }

        @Override
        public void failed(IOException oops) {
            Extractor.this.errorCount++;
            Extractor.this.fireItemFailed(this.file, oops);
        }

        @Override
        public void started() {
            Extractor.this.fireItemStarted(this.file);
        }

        @Override
        public void statusUpdate(long count) {
            Extractor.this.fireItemInProgress(this.file, count, this.length);
        }
    }
}

