/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags.filters;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.filters.LineFilterConverter;

public class TaggableFilter
implements Predicate<Taggable>,
Serializable {
    private static final long serialVersionUID = 5697377487014951158L;
    private static final String ERROR_MESSAGE = "Unknown TreeBoolean {}";
    private final List<TaggableFilter> children;
    private final TreeBoolean treeBoolean;
    private final Predicate<Taggable> simple;
    private final String definition;

    public static TaggableFilter forDefinition(String definition) {
        return new LineFilterConverter().convert(definition);
    }

    @Deprecated
    public TaggableFilter(String definition) {
        this(TaggableFilter.forDefinition(definition));
    }

    protected TaggableFilter(List<TaggableFilter> children, TreeBoolean treeBoolean) {
        this.children = children;
        this.treeBoolean = treeBoolean;
        this.simple = null;
        this.definition = null;
    }

    protected TaggableFilter(Predicate<Taggable> simple, String definition) {
        this.children = new ArrayList<TaggableFilter>();
        this.treeBoolean = TreeBoolean.OR;
        this.simple = simple;
        this.definition = definition;
    }

    private TaggableFilter(TaggableFilter other) {
        this.children = other.children;
        this.treeBoolean = other.treeBoolean;
        this.simple = other.simple;
        this.definition = other.definition;
    }

    @Override
    public boolean test(Taggable taggable) {
        if (this.simple != null) {
            return this.simple.test(taggable);
        }
        if (this.children.isEmpty()) {
            throw new CoreException("Malformed predicate {}", this);
        }
        switch (this.treeBoolean) {
            case AND: {
                return this.children.stream().allMatch(tree -> tree.test(taggable));
            }
            case OR: {
                return this.children.stream().anyMatch(tree -> tree.test(taggable));
            }
        }
        throw new CoreException(ERROR_MESSAGE, this);
    }

    public String toString() {
        return new LineFilterConverter().backwardConvert(this);
    }

    protected List<TaggableFilter> getChildren() {
        return this.children;
    }

    protected Optional<String> getDefinition() {
        return Optional.ofNullable(this.definition);
    }

    protected TreeBoolean getTreeBoolean() {
        return this.treeBoolean;
    }

    protected static enum TreeBoolean {
        AND,
        OR;


        public TreeBoolean other() {
            switch (this) {
                case AND: {
                    return OR;
                }
                case OR: {
                    return AND;
                }
            }
            throw new CoreException(TaggableFilter.ERROR_MESSAGE, new Object[]{this});
        }

        public String separator() {
            switch (this) {
                case AND: {
                    return "&";
                }
                case OR: {
                    return "|";
                }
            }
            throw new CoreException(TaggableFilter.ERROR_MESSAGE, new Object[]{this});
        }
    }
}

