/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags.annotations.validation;

import java.util.Arrays;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.tags.annotations.validation.TagValidator;

public class ISO3CountryValidator
implements TagValidator {
    private static Set<String> validISOCountries = Arrays.asList(Locale.getAvailableLocales()).stream().filter(ISO3CountryValidator::hasISO3Country).map(Locale::getISO3Country).collect(Collectors.toSet());

    private static boolean hasISO3Country(Locale locale) {
        try {
            locale.getISO3Country();
            return true;
        }
        catch (MissingResourceException oops) {
            return false;
        }
    }

    @Override
    public boolean isValid(String value) {
        return validISOCountries.contains(value);
    }
}

