/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags.annotations.extraction;

import java.util.Optional;
import org.openstreetmap.atlas.tags.annotations.validation.SpeedValidator;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.scalars.Speed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SpeedExtractor {
    private static final SpeedValidator VALIDATOR = new SpeedValidator();
    private static final String SINGLE_SPACE = " ";
    private static final Logger logger = LoggerFactory.getLogger(SpeedExtractor.class);

    public static Optional<Speed> validateAndExtract(String value) {
        if (VALIDATOR.isValid(value)) {
            try {
                if (value.endsWith("mph")) {
                    return Optional.of(Speed.milesPerHour(Double.valueOf(StringList.split(value, SINGLE_SPACE).iterator().next())));
                }
                if (value.endsWith("knots")) {
                    return Optional.of(Speed.knots(Double.valueOf(StringList.split(value, SINGLE_SPACE).iterator().next())));
                }
                if (value.endsWith("kph")) {
                    return Optional.of(Speed.kilometersPerHour(Double.valueOf(StringList.split(value, SINGLE_SPACE).iterator().next())));
                }
                if ("none".equals(value)) {
                    return Optional.empty();
                }
                return Optional.of(Speed.kilometersPerHour(Double.valueOf(value)));
            }
            catch (NumberFormatException e) {
                logger.warn("Unable to read speed from {}", (Object)value);
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private SpeedExtractor() {
    }
}

