/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags.annotations.extraction;

import java.util.Optional;
import org.openstreetmap.atlas.tags.annotations.Tag;
import org.openstreetmap.atlas.tags.annotations.extraction.TagExtractor;
import org.openstreetmap.atlas.tags.annotations.validation.OrdinalValidator;

public final class OrdinalExtractor
implements TagExtractor<Integer> {
    @Override
    public Optional<Integer> validateAndExtract(String value, Tag tag) {
        OrdinalValidator validator = new OrdinalValidator();
        Tag.Range range = tag.range();
        if (range != null) {
            validator.setRange(range.min(), range.max());
            for (long exclusion : range.exclude()) {
                validator.excludeValue(exclusion);
            }
        }
        if (validator.isValid(value)) {
            return Optional.of(Integer.parseInt(value));
        }
        return Optional.empty();
    }
}

