/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags;

import java.util.EnumSet;
import java.util.Optional;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.Tag;
import org.openstreetmap.atlas.tags.annotations.TagKey;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;

@Tag(synthetic=true)
public enum SyntheticBoundaryNodeTag {
    YES,
    EXISTING;

    @TagKey
    public static final String KEY = "synthetic_boundary_node";
    private static EnumSet<SyntheticBoundaryNodeTag> ALL_BOUNDARY_NODES;
    private static EnumSet<SyntheticBoundaryNodeTag> SYNTHETIC_BOUNDARY_NODES;
    private static EnumSet<SyntheticBoundaryNodeTag> EXISTING_BOUNDARY_NODES;

    public static boolean isBoundaryNode(Taggable taggable) {
        Optional<SyntheticBoundaryNodeTag> boundary = Validators.from(SyntheticBoundaryNodeTag.class, taggable);
        return boundary.isPresent() && ALL_BOUNDARY_NODES.contains((Object)boundary.get());
    }

    public static boolean isExistingBoundaryNode(Taggable taggable) {
        Optional<SyntheticBoundaryNodeTag> boundary = Validators.from(SyntheticBoundaryNodeTag.class, taggable);
        return boundary.isPresent() && EXISTING_BOUNDARY_NODES.contains((Object)boundary.get());
    }

    public static boolean isSyntheticBoundaryNode(Taggable taggable) {
        Optional<SyntheticBoundaryNodeTag> boundary = Validators.from(SyntheticBoundaryNodeTag.class, taggable);
        return boundary.isPresent() && SYNTHETIC_BOUNDARY_NODES.contains((Object)boundary.get());
    }

    static {
        ALL_BOUNDARY_NODES = EnumSet.of(YES, EXISTING);
        SYNTHETIC_BOUNDARY_NODES = EnumSet.of(YES);
        EXISTING_BOUNDARY_NODES = EnumSet.of(EXISTING);
    }
}

