/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.locale.IsoCountry;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.Tag;
import org.openstreetmap.atlas.tags.annotations.TagKey;
import org.openstreetmap.atlas.utilities.collections.Iterables;

@Tag(value=Tag.Validation.ISO3_COUNTRY)
public interface ISOCountryTag {
    @TagKey
    public static final String KEY = "iso_country_code";
    public static final String COUNTRY_MISSING = "N/A";
    public static final String COUNTRY_DELIMITER = ",";

    public static Iterable<IsoCountry> all(Taggable taggable) {
        Optional<String> countryCode = taggable.getTag(ISOCountryTag.class, Optional.empty(), new Taggable.TagSearchOption[0]);
        if (countryCode.isPresent()) {
            List<String> allIsoCodes = Arrays.asList(countryCode.get().split(COUNTRY_DELIMITER));
            return allIsoCodes.stream().map(isoCode -> IsoCountry.forCountryCode(isoCode)).filter(isoCountry -> isoCountry.isPresent()).map(isoCountry -> (IsoCountry)isoCountry.get()).collect(Collectors.toList());
        }
        return ImmutableList.of();
    }

    public static Predicate<Taggable> allIn(IsoCountry ... countries) {
        if (countries.length == 0) {
            return taggable -> false;
        }
        return taggable -> {
            List<IsoCountry> checkCountries = Arrays.asList(countries);
            for (IsoCountry isoCountry : ISOCountryTag.all(taggable)) {
                if (checkCountries.contains(isoCountry)) continue;
                return false;
            }
            return true;
        };
    }

    public static Optional<IsoCountry> first(Taggable taggable) {
        return Iterables.first(ISOCountryTag.all(taggable));
    }

    public static Predicate<Taggable> isIn(IsoCountry ... countries) {
        if (countries.length == 0) {
            return taggable -> false;
        }
        return taggable -> {
            List<IsoCountry> checkCountries = Arrays.asList(countries);
            for (IsoCountry isoCountry : ISOCountryTag.all(taggable)) {
                if (!checkCountries.contains(isoCountry)) continue;
                return true;
            }
            return false;
        };
    }
}

