/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags;

import java.util.EnumSet;
import java.util.Optional;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.Tag;
import org.openstreetmap.atlas.tags.annotations.TagKey;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;

@Tag(taginfo="http://taginfo.openstreetmap.org/keys/access#values", osm="http://wiki.openstreetmap.org/wiki/Key:access")
public enum AccessTag {
    YES,
    PRIVATE,
    NO,
    PERMISSIVE,
    AGRICULTURAL,
    USE_SIDEPATH,
    DELIVERY,
    DESIGNATED,
    DISMOUNT,
    DISCOURAGED,
    FORESTRY,
    DESTINATION,
    CUSTOMERS,
    PROHIBITED,
    PUBLIC,
    RESTRICTED,
    UNKNOWN;

    private static final EnumSet<AccessTag> PRIVATE_ACCESS;
    @TagKey
    public static final String KEY = "access";

    public static boolean isNo(Taggable taggable) {
        return Validators.isOfType((Taggable)taggable, AccessTag.class, (Enum[])new AccessTag[]{NO});
    }

    public static boolean isPrivate(Taggable taggable) {
        Optional<AccessTag> access = Validators.from(AccessTag.class, taggable);
        return access.isPresent() && PRIVATE_ACCESS.contains((Object)access.get());
    }

    static {
        PRIVATE_ACCESS = EnumSet.of(CUSTOMERS, NO, PRIVATE, RESTRICTED, PROHIBITED);
    }
}

