/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.streaming.resource;

import java.io.InputStream;
import java.io.OutputStream;
import org.openstreetmap.atlas.streaming.StringInputStream;
import org.openstreetmap.atlas.streaming.StringOutputStream;
import org.openstreetmap.atlas.streaming.resource.AbstractResource;
import org.openstreetmap.atlas.streaming.resource.AbstractWritableResource;
import org.openstreetmap.atlas.streaming.resource.InputStreamResource;

public class StringResource
extends AbstractWritableResource {
    private String source;
    private StringOutputStream out;

    public StringResource() {
        this.out = new StringOutputStream();
    }

    public StringResource(AbstractResource source) {
        StringBuilder builder = new StringBuilder();
        source.lines().forEach(line -> {
            builder.append((String)line);
            builder.append("\n");
        });
        this.source = builder.toString();
    }

    public StringResource(InputStream source) {
        this(new InputStreamResource(source));
    }

    public StringResource(String source) {
        this.source = source;
    }

    @Override
    public long length() {
        if (this.source != null) {
            return this.source.length();
        }
        return super.length();
    }

    public StringResource withName(String name) {
        this.setName(name);
        return this;
    }

    public String writtenString() {
        return this.out.toString();
    }

    @Override
    protected InputStream onRead() {
        return new StringInputStream(this.source != null ? this.source : this.writtenString());
    }

    @Override
    protected OutputStream onWrite() {
        if (this.out == null) {
            this.out = new StringOutputStream();
        }
        return this.out;
    }
}

