/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.streaming.readers.json.deserializers;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Located;
import org.openstreetmap.atlas.geography.geojson.GeoJsonBuilder;
import org.openstreetmap.atlas.streaming.readers.json.deserializers.LocationDeserializer;
import org.openstreetmap.atlas.streaming.readers.json.deserializers.MultiPolygonDeserializer;
import org.openstreetmap.atlas.streaming.readers.json.deserializers.PolyLineDeserializer;
import org.openstreetmap.atlas.streaming.readers.json.deserializers.PolygonDeserializer;

public class LocatedDeserializer
implements JsonDeserializer<Located> {
    @Override
    public Located deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        GeoJsonBuilder.GeoJsonType type = GeoJsonBuilder.GeoJsonType.forType(((JsonObject)json).get("type").getAsString());
        if (GeoJsonBuilder.GeoJsonType.POINT == type) {
            return new LocationDeserializer().deserialize(json, typeOfT, context);
        }
        if (GeoJsonBuilder.GeoJsonType.LINESTRING == type) {
            return new PolyLineDeserializer().deserialize(json, typeOfT, context);
        }
        if (GeoJsonBuilder.GeoJsonType.POLYGON == type) {
            return new PolygonDeserializer().deserialize(json, typeOfT, context);
        }
        if (GeoJsonBuilder.GeoJsonType.MULTI_POLYGON == type) {
            return new MultiPolygonDeserializer().deserialize(json, typeOfT, context);
        }
        throw new CoreException("Unknown/unsupported geometry type: " + (Object)((Object)type));
    }
}

