/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.streaming.readers;

import au.com.bytecode.opencsv.CSVParser;
import java.io.IOException;
import java.util.Iterator;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.streaming.readers.CsvSchema;
import org.openstreetmap.atlas.utilities.collections.StringList;

public final class CsvLine
implements Iterable<Object> {
    private final CsvSchema schema;
    private final String[] items;

    public static CsvLine build(CsvSchema schema, String line) {
        String[] items;
        try {
            items = new CSVParser().parseLine(line);
        }
        catch (IOException e) {
            throw new CoreException("Could not parse line " + line, e);
        }
        if (items != null && schema != null) {
            if (items.length == schema.size()) {
                return new CsvLine(schema, items);
            }
            throw new CoreException("Line -- " + line + " -- has " + items.length + " arguments instead of " + schema.size() + " expected in the schema.");
        }
        throw new CoreException("line or schema was null.");
    }

    private CsvLine(CsvSchema schema, String[] line) {
        this.schema = schema;
        this.items = line;
    }

    public Object get(int index) {
        this.verifyIndex(index);
        return this.schema.get(this, index);
    }

    @Override
    public Iterator<Object> iterator() {
        return new Iterator<Object>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < CsvLine.this.items.length;
            }

            @Override
            public Object next() {
                if (this.index >= CsvLine.this.items.length) {
                    return null;
                }
                return CsvLine.this.get(this.index++);
            }
        };
    }

    public String toString() {
        StringList list = new StringList(() -> new Iterator<String>(){
            private final Iterator objects;
            {
                this.objects = CsvLine.this.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.objects.hasNext();
            }

            @Override
            public String next() {
                Object next = this.objects.next();
                return "\"" + next.toString() + "\"";
            }
        });
        return list.join(",");
    }

    protected String getValue(int index) {
        this.verifyIndex(index);
        return this.items[index];
    }

    private void verifyIndex(int index) {
        if (index < 0 || index >= this.items.length) {
            throw new CoreException("Item index " + index + " is out of range: 0 -> " + this.items.length);
        }
    }
}

