/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.streaming;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EventListener;
import java.util.Optional;
import org.openstreetmap.atlas.exception.CoreException;

public class NotifyingIOUtils {
    private static final int EOF = -1;
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private Optional<IOProgressListener> progessListener = Optional.empty();
    private int bufferSize = 4096;

    public static long copy(InputStream input, OutputStream output, int bufferSize, IOProgressListener listener) throws IOException {
        return new NotifyingIOUtils().withListener(listener).withBufferSize(bufferSize).copy(input, output);
    }

    public static long copy(InputStream input, OutputStream output, IOProgressListener listener) throws IOException {
        return new NotifyingIOUtils().withListener(listener).copy(input, output);
    }

    public long copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[this.bufferSize];
        long count = 0L;
        int bufferReadCount = 0;
        try {
            this.progessListener.ifPresent(IOProgressListener::started);
            while (-1 != (bufferReadCount = input.read(buffer))) {
                output.write(buffer, 0, bufferReadCount);
                long temporaryCount = count += (long)bufferReadCount;
                this.progessListener.ifPresent(listener -> listener.statusUpdate(temporaryCount));
            }
            this.progessListener.ifPresent(IOProgressListener::completed);
        }
        catch (IOException oops) {
            this.progessListener.ifPresent(listener -> listener.failed(oops));
        }
        return count;
    }

    public NotifyingIOUtils withBufferSize(int bufferSize) {
        if (bufferSize <= 0) {
            throw new CoreException("Buffer size must be larger than zero: {}", bufferSize);
        }
        this.bufferSize = bufferSize;
        return this;
    }

    public NotifyingIOUtils withListener(IOProgressListener listener) {
        this.progessListener = Optional.ofNullable(listener);
        return this;
    }

    public static interface IOProgressListener
    extends EventListener {
        public void completed();

        public void failed(IOException var1);

        public void started();

        public void statusUpdate(long var1);
    }
}

