/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.proto.command;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlas;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.openstreetmap.atlas.utilities.runtime.FlexibleSubCommand;

public class PackedToProtoAtlasSubCommand
implements FlexibleSubCommand {
    private static final String NAME = "packed-to-proto";
    private static final String DESCRIPTION = "converts a packed atlas to a naive proto-based atlas";
    private static final String PACKED_SWITCH_TEXT = "packed-atlas";
    private static final String PROTO_SWITCH_TEXT = "proto-atlas";
    private static final Command.Switch<Path> INPUT_PARAMETER = new Command.Switch("packed-atlas", "Input atlas data in text atlas format", x$0 -> Paths.get(x$0, new String[0]), Command.Optionality.REQUIRED);
    private static final Command.Switch<Path> OUTPUT_PARAMETER = new Command.Switch("proto-atlas", "Output atlas data path", x$0 -> Paths.get(x$0, new String[0]), Command.Optionality.REQUIRED);
    private Path inputPath;
    private Path outputPath;

    @Override
    public int execute(CommandMap map) {
        this.inputPath = (Path)map.get(INPUT_PARAMETER);
        this.outputPath = (Path)map.get(OUTPUT_PARAMETER);
        this.verifyArguments();
        PackedAtlas.load(new File(this.inputPath.toFile())).saveAsProto(new File(this.outputPath.toFile()));
        return 0;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Command.SwitchList switches() {
        return new Command.SwitchList().with(INPUT_PARAMETER, OUTPUT_PARAMETER);
    }

    @Override
    public void usage(PrintStream writer) {
        writer.println("-packed-atlas=/input/path/to/packed/atlas");
        writer.println("-proto-atlas=/output/path/to/proto/atlas");
    }

    private void verifyArguments() {
        if (!Files.isRegularFile(this.inputPath, new LinkOption[0])) {
            throw new CoreException("{} is not a readable file", this.inputPath);
        }
        try {
            if (Files.isDirectory(this.outputPath, new LinkOption[0])) {
                throw new CoreException("{} is a directory.  Aborting", this.outputPath);
            }
            Files.createDirectories(this.outputPath.getParent(), new FileAttribute[0]);
        }
        catch (IOException exception) {
            throw new CoreException("Error when creating directories {}", this.outputPath.getParent(), exception);
        }
    }
}

