/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.locale;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.openstreetmap.atlas.utilities.collections.EnhancedCollectors;

public final class IsoLanguage
implements Comparable<IsoLanguage> {
    private static final Locale LANGUAGE_LOCALE = Locale.US;
    private static Set<String> ALL_LANGUAGE_CODES;
    private static Set<String> DISPLAY_LANGUAGES_SET;
    private static Map<String, IsoLanguage> ISO_LANGUAGES;
    private final String languageCode;
    private final String displayLanguage;

    public static Stream<IsoLanguage> all() {
        return ISO_LANGUAGES.values().stream();
    }

    public static Set<String> allLanguageCodes() {
        return ALL_LANGUAGE_CODES;
    }

    public static Optional<String> displayLanguageForLanguageCode(String languageCode) {
        IsoLanguage isoLanguage;
        String displayLanguage = null;
        if (languageCode != null && (isoLanguage = ISO_LANGUAGES.get(languageCode)) != null) {
            displayLanguage = isoLanguage.getDisplayLanguage();
        }
        return Optional.ofNullable(displayLanguage);
    }

    public static Optional<IsoLanguage> forLanguageCode(String languageCode) {
        return Optional.ofNullable(ISO_LANGUAGES.get(languageCode));
    }

    public static boolean isValidDisplayLanguage(String displayLanguage) {
        return displayLanguage != null && DISPLAY_LANGUAGES_SET.contains(displayLanguage);
    }

    public static boolean isValidLanguageCode(String languageCode) {
        return languageCode != null && ISO_LANGUAGES.containsKey(languageCode);
    }

    private IsoLanguage(String languageCode) {
        this.languageCode = languageCode;
        this.displayLanguage = new Locale(languageCode).getDisplayLanguage(LANGUAGE_LOCALE);
    }

    @Override
    public int compareTo(IsoLanguage other) {
        if (this == other) {
            return 0;
        }
        return this.languageCode.compareTo(other.getLanguageCode());
    }

    public String getDisplayLanguage() {
        return this.displayLanguage;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    static {
        String[] languages = Locale.getISOLanguages();
        ALL_LANGUAGE_CODES = Arrays.stream(languages).collect(EnhancedCollectors.toUnmodifiableSortedSet());
        DISPLAY_LANGUAGES_SET = Arrays.stream(languages).map(language -> new Locale((String)language).getDisplayLanguage(LANGUAGE_LOCALE)).collect(EnhancedCollectors.toUnmodifiableSortedSet());
        ISO_LANGUAGES = Arrays.stream(languages).collect(EnhancedCollectors.toUnmodifiableSortedMap(languageCode -> languageCode, languageCode -> new IsoLanguage((String)languageCode)));
    }
}

