/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.geojson;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Located;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.geojson.GeoJsonObject;
import org.openstreetmap.atlas.streaming.readers.json.serializers.PropertiesLocated;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoJsonBuilder {
    public static final String COORDINATES = "coordinates";
    public static final String FEATURE = "Feature";
    public static final String FEATURES = "features";
    public static final String FEATURE_COLLECTION = "FeatureCollection";
    public static final String GEOMETRIES = "geometries";
    public static final String GEOMETRY = "geometry";
    public static final String GEOMETRY_COLLECTION = "GeometryCollection";
    public static final String PROPERTIES = "properties";
    public static final String TYPE = "type";
    private static final Logger logger = LoggerFactory.getLogger(GeoJsonBuilder.class);
    private final int logFrequency;

    protected static final Iterable<GeometryWithProperties> toGeometriesWithProperties(Iterable<LocationIterableProperties> objects) {
        Iterable<GeometryWithProperties> geometriesWithProperties = Iterables.translate(objects, locationIterableProperties -> GeoJsonBuilder.toGeometryWithProperties(locationIterableProperties));
        return geometriesWithProperties;
    }

    protected static final GeometryWithProperties toGeometryWithProperties(LocationIterableProperties locationIterableProperties) {
        HashMap<String, Object> propertiesObjects = new HashMap<String, Object>();
        propertiesObjects.putAll(locationIterableProperties.getProperties());
        return new GeometryWithProperties(locationIterableProperties.getLocations(), propertiesObjects);
    }

    public GeoJsonBuilder() {
        this.logFrequency = -1;
    }

    public GeoJsonBuilder(int logFrequency) {
        this.logFrequency = logFrequency;
    }

    public GeoJsonObject create(GeoJsonType type, Location ... locations) {
        return this.create(Iterables.iterable(locations), type);
    }

    public JsonObject create(GeometryWithProperties geometryWithProperties) {
        Iterable<Location> geometry = geometryWithProperties.getGeometry();
        Map<String, Object> properties = geometryWithProperties.getProperties();
        if (geometry instanceof Location) {
            return this.create((Location)geometry).withNewProperties(properties).jsonObject();
        }
        if (geometry instanceof Polygon) {
            return this.create((Polygon)geometry).withNewProperties(properties).jsonObject();
        }
        if (geometry instanceof PolyLine) {
            return this.create((PolyLine)geometry).withNewProperties(properties).jsonObject();
        }
        throw new CoreException("Unrecognized object type {}", geometry.getClass().getSimpleName());
    }

    public GeoJsonObject create(Iterable<Location> locations, GeoJsonType type) {
        JsonObject result = new JsonObject();
        result.addProperty(TYPE, FEATURE);
        JsonArray coordinates = new JsonArray();
        switch (type) {
            case POINT: {
                Location location = locations.iterator().next();
                coordinates.add(new JsonPrimitive(location.getLongitude().asDegrees()));
                coordinates.add(new JsonPrimitive(location.getLatitude().asDegrees()));
                break;
            }
            case LINESTRING: 
            case MULTI_POINT: 
            case MULTI_LINESTRING: 
            case MULTI_POLYGON: {
                for (Location location : locations) {
                    JsonArray locationArray = new JsonArray();
                    locationArray.add(new JsonPrimitive(location.getLongitude().asDegrees()));
                    locationArray.add(new JsonPrimitive(location.getLatitude().asDegrees()));
                    coordinates.add(locationArray);
                }
                break;
            }
            case POLYGON: {
                JsonArray locationArray = new JsonArray();
                for (Location location : locations) {
                    JsonArray locationArray2 = new JsonArray();
                    locationArray2.add(new JsonPrimitive(location.getLongitude().asDegrees()));
                    locationArray2.add(new JsonPrimitive(location.getLatitude().asDegrees()));
                    locationArray.add(locationArray2);
                }
                coordinates.add(locationArray);
                break;
            }
            default: {
                throw new CoreException("Unrecognized object type {}", new Object[]{type});
            }
        }
        JsonObject geometry = new JsonObject();
        geometry.addProperty(TYPE, type.getType());
        geometry.add(COORDINATES, coordinates);
        result.add(GEOMETRY, geometry);
        return new GeoJsonObject(result);
    }

    @Deprecated
    public GeoJsonObject create(Iterable<LocationIterableProperties> objects) {
        return this.createFromGeometriesWithProperties(GeoJsonBuilder.toGeometriesWithProperties(objects));
    }

    public GeoJsonObject create(Location location) {
        return this.create(location, GeoJsonType.POINT);
    }

    @Deprecated
    public JsonObject create(LocationIterableProperties object) {
        GeometryWithProperties geometryWithProperties = GeoJsonBuilder.toGeometryWithProperties(object);
        return this.create(geometryWithProperties);
    }

    public GeoJsonObject create(Polygon polygon) {
        return this.create(polygon.closedLoop(), GeoJsonType.POLYGON);
    }

    public GeoJsonObject create(PolyLine polyLine) {
        return this.create(polyLine, GeoJsonType.LINESTRING);
    }

    public GeoJsonObject createFeatureCollection(Iterable<GeoJsonObject> objects) {
        JsonObject result = new JsonObject();
        result.addProperty(TYPE, FEATURE_COLLECTION);
        JsonArray features = new JsonArray();
        int counter = 0;
        for (GeoJsonObject object : objects) {
            if (this.logFrequency > 0 && ++counter % this.logFrequency == 0) {
                logger.info("Processed {} features.", (Object)counter);
            }
            if (!Optional.ofNullable(object.jsonObject().get(TYPE)).filter(jsonObject -> jsonObject.getAsString().equals(FEATURE)).isPresent()) {
                throw new CoreException("Illegal GeoJson Type for Feature collection");
            }
            features.add(object.jsonObject());
        }
        result.add(FEATURES, features);
        return new GeoJsonObject(result);
    }

    public GeoJsonObject createFeatureCollectionFromPropertiesLocated(Iterable<PropertiesLocated> iterableOfPropertiesLocated) {
        JsonObject result = new JsonObject();
        result.addProperty(TYPE, FEATURE_COLLECTION);
        JsonArray features = new JsonArray();
        int counter = 0;
        for (PropertiesLocated propertiesLocated : iterableOfPropertiesLocated) {
            GeoJsonObject feature;
            Located located;
            if (this.logFrequency > 0 && ++counter % this.logFrequency == 0) {
                logger.info("Processed {} features.", (Object)counter);
            }
            if ((located = propertiesLocated.getItem()) instanceof Location) {
                feature = this.create((Location)located);
            } else if (located instanceof PolyLine) {
                feature = this.create((PolyLine)located);
            } else if (located instanceof Polygon) {
                feature = this.create((Polygon)located);
            } else {
                throw new CoreException("Unrecognized object type {}", located.getClass().getName());
            }
            JsonObject featureJsonObj = feature.jsonObject();
            featureJsonObj.add(PROPERTIES, propertiesLocated.getProperties());
            features.add(feature.jsonObject());
        }
        result.add(FEATURES, features);
        return new GeoJsonObject(result);
    }

    public GeoJsonObject createFromGeoJson(Iterable<GeoJsonObject> geoJsonObjects) {
        JsonObject result = new JsonObject();
        result.addProperty(TYPE, FEATURE_COLLECTION);
        JsonArray features = new JsonArray();
        int counter = 0;
        for (GeoJsonObject object : geoJsonObjects) {
            if (this.logFrequency > 0 && ++counter % this.logFrequency == 0) {
                logger.info("Processed {} features.", (Object)counter);
            }
            features.add(object.jsonObject());
        }
        result.add(FEATURES, features);
        return new GeoJsonObject(result);
    }

    public GeoJsonObject createFromGeometriesWithProperties(Iterable<GeometryWithProperties> geometriesWithProperties) {
        JsonObject result = new JsonObject();
        result.addProperty(TYPE, FEATURE_COLLECTION);
        JsonArray features = new JsonArray();
        int counter = 0;
        for (GeometryWithProperties geometryWithProperties : geometriesWithProperties) {
            if (this.logFrequency > 0 && ++counter % this.logFrequency == 0) {
                logger.info("Processed {} features.", (Object)counter);
            }
            features.add(this.create(geometryWithProperties));
        }
        result.add(FEATURES, features);
        return new GeoJsonObject(result);
    }

    @Deprecated
    public GeoJsonObject createGeometryCollection(Iterable<LocationIterableProperties> objects) {
        return this.createGeometryCollectionFeature(GeoJsonBuilder.toGeometriesWithProperties(objects));
    }

    public GeoJsonObject createGeometryCollectionFeature(Iterable<GeometryWithProperties> geometriesWithProperties) {
        JsonObject geometryCollection = new JsonObject();
        geometryCollection.addProperty(TYPE, GEOMETRY_COLLECTION);
        HashMap<GeoJsonType, List> geometryMap = new HashMap<GeoJsonType, List>();
        int counter = 0;
        for (GeometryWithProperties geometryWithProperties : geometriesWithProperties) {
            GeoJsonType geoJsonType;
            Iterable<Location> geometry;
            if (this.logFrequency > 0 && ++counter % this.logFrequency == 0) {
                logger.info("Processed {} geometries.", (Object)counter);
            }
            if ((geometry = geometryWithProperties.getGeometry()) instanceof Location) {
                geoJsonType = GeoJsonType.POINT;
            } else if (geometry instanceof Polygon) {
                geoJsonType = GeoJsonType.POLYGON;
            } else if (geometry instanceof PolyLine) {
                geoJsonType = GeoJsonType.LINESTRING;
            } else {
                throw new CoreException("Unrecognized object type {}", geometry.getClass().getSimpleName());
            }
            geometryMap.computeIfAbsent(geoJsonType, key -> new ArrayList()).add(geometry);
        }
        JsonArray geometries = new JsonArray();
        if (geometryMap.containsKey((Object)GeoJsonType.POINT)) {
            List points = (List)geometryMap.get((Object)GeoJsonType.POINT);
            if (points.size() > 1) {
                geometries.add(this.create(Iterables.translate(points, Iterables::head), GeoJsonType.MULTI_POINT).jsonObject().getAsJsonObject(GEOMETRY));
            } else if (points.size() == 1) {
                geometries.add(this.create((Iterable)Iterables.head(points), GeoJsonType.POINT).jsonObject().getAsJsonObject(GEOMETRY));
            }
        }
        if (geometryMap.containsKey((Object)GeoJsonType.POLYGON)) {
            List polygons = (List)geometryMap.get((Object)GeoJsonType.POLYGON);
            if (polygons.size() > 1) {
                geometries.add(this.createMultiPolygons(Iterables.stream(polygons).map(Polygon::new)).jsonObject().getAsJsonObject(GEOMETRY));
            } else if (polygons.size() == 1) {
                geometries.add(this.create((Iterable)Iterables.head(polygons), GeoJsonType.POLYGON).jsonObject().getAsJsonObject(GEOMETRY));
            }
        }
        if (geometryMap.containsKey((Object)GeoJsonType.LINESTRING)) {
            List multiPolylines = (List)geometryMap.get((Object)GeoJsonType.LINESTRING);
            if (multiPolylines.size() > 1) {
                geometries.add(this.createMultiLineStrings(Iterables.stream(multiPolylines).map(PolyLine::new)).jsonObject().getAsJsonObject(GEOMETRY));
            } else if (multiPolylines.size() == 1) {
                geometries.add(this.create((Iterable)Iterables.head(multiPolylines), GeoJsonType.LINESTRING).jsonObject().getAsJsonObject(GEOMETRY));
            }
        }
        geometryCollection.add(GEOMETRIES, geometries);
        JsonObject result = new JsonObject();
        result.addProperty(TYPE, FEATURE);
        result.add(GEOMETRY, geometryCollection);
        return new GeoJsonObject(result);
    }

    public GeoJsonObject createMultiLineStrings(Iterable<PolyLine> polyLines) {
        ArrayList<GeoJsonObject> objects = new ArrayList<GeoJsonObject>();
        for (PolyLine polygon : polyLines) {
            objects.add(this.create(polygon, GeoJsonType.MULTI_LINESTRING));
        }
        JsonObject result = new JsonObject();
        result.addProperty(TYPE, FEATURE);
        JsonArray coordinates = new JsonArray();
        for (GeoJsonObject object : objects) {
            coordinates.add(object.jsonObject().getAsJsonObject(GEOMETRY).getAsJsonArray(COORDINATES));
        }
        JsonObject geometry = new JsonObject();
        geometry.addProperty(TYPE, GeoJsonType.MULTI_LINESTRING.getType());
        geometry.add(COORDINATES, coordinates);
        result.add(GEOMETRY, geometry);
        return new GeoJsonObject(result);
    }

    public GeoJsonObject createMultiPolygons(Iterable<Polygon> polygons) {
        ArrayList<GeoJsonObject> objects = new ArrayList<GeoJsonObject>();
        for (Polygon polygon : polygons) {
            objects.add(this.create(polygon.closedLoop(), GeoJsonType.MULTI_POLYGON));
        }
        JsonObject result = new JsonObject();
        result.addProperty(TYPE, FEATURE);
        JsonArray coordinates = new JsonArray();
        for (GeoJsonObject object : objects) {
            JsonArray subCoordinates = new JsonArray();
            subCoordinates.add(object.jsonObject().getAsJsonObject(GEOMETRY).getAsJsonArray(COORDINATES));
            coordinates.add(subCoordinates);
        }
        JsonObject geometry = new JsonObject();
        geometry.addProperty(TYPE, GeoJsonType.MULTI_POLYGON.getType());
        geometry.add(COORDINATES, coordinates);
        result.add(GEOMETRY, geometry);
        return new GeoJsonObject(result);
    }

    public GeoJsonObject createOneOuterMultiPolygon(Iterable<Polygon> polygons) {
        ArrayList<GeoJsonObject> objects = new ArrayList<GeoJsonObject>();
        for (Polygon polygon : polygons) {
            objects.add(this.create(polygon.closedLoop(), GeoJsonType.MULTI_POLYGON));
        }
        JsonObject result = new JsonObject();
        result.addProperty(TYPE, FEATURE);
        JsonArray coordinates = new JsonArray();
        for (GeoJsonObject object : objects) {
            coordinates.add(object.jsonObject().getAsJsonObject(GEOMETRY).getAsJsonArray(COORDINATES));
        }
        JsonArray newCoordinates = new JsonArray();
        newCoordinates.add(coordinates);
        JsonObject geometry = new JsonObject();
        geometry.addProperty(TYPE, GeoJsonType.MULTI_POLYGON.getType());
        geometry.add(COORDINATES, newCoordinates);
        result.add(GEOMETRY, geometry);
        result.add(PROPERTIES, new JsonObject());
        return new GeoJsonObject(result);
    }

    @Deprecated
    public static class LocationIterableProperties {
        private final Iterable<Location> locations;
        private final Map<String, String> properties;

        public LocationIterableProperties(Iterable<Location> locations, Map<String, String> properties) {
            this.locations = locations;
            this.properties = properties;
        }

        public Iterable<Location> getLocations() {
            return this.locations;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }
    }

    public static class GeometryWithProperties {
        private final Iterable<Location> geometry;
        private final Map<String, Object> properties;

        public GeometryWithProperties(Iterable<Location> geometry, Map<String, Object> properties) {
            this.geometry = geometry;
            this.properties = properties;
        }

        public Iterable<Location> getGeometry() {
            return this.geometry;
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }
    }

    public static enum GeoJsonType {
        POINT("Point"),
        LINESTRING("LineString"),
        POLYGON("Polygon"),
        MULTI_POINT("MultiPoint"),
        MULTI_LINESTRING("MultiLineString"),
        MULTI_POLYGON("MultiPolygon");

        private final String type;

        public static GeoJsonType forType(String type) {
            for (GeoJsonType value : GeoJsonType.values()) {
                if (!value.getType().equals(type)) continue;
                return value;
            }
            throw new CoreException("Invalid geoJson type: {}", type);
        }

        private GeoJsonType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

