/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.converters.jts;

import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import java.util.HashSet;
import java.util.Set;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.converters.jts.JtsMultiPolygonConverter;
import org.openstreetmap.atlas.geography.converters.jts.JtsPrecisionManager;
import org.openstreetmap.atlas.utilities.conversion.TwoWayConverter;

public class JtsMultiPolygonToMultiPolygonConverter
implements TwoWayConverter<com.vividsolutions.jts.geom.MultiPolygon, MultiPolygon> {
    private static final JtsMultiPolygonConverter JTS_MULTI_POLYGON_CONVERTER = new JtsMultiPolygonConverter();
    private static final GeometryFactory FACTORY = JtsPrecisionManager.getGeometryFactory();

    @Override
    public com.vividsolutions.jts.geom.MultiPolygon backwardConvert(MultiPolygon object) {
        Polygon[] polygons = JTS_MULTI_POLYGON_CONVERTER.convert(object).toArray(new Polygon[0]);
        return new com.vividsolutions.jts.geom.MultiPolygon(polygons, FACTORY);
    }

    @Override
    public MultiPolygon convert(com.vividsolutions.jts.geom.MultiPolygon object) {
        int numberGeometries = object.getNumGeometries();
        HashSet<Polygon> polygons = new HashSet<Polygon>();
        for (int index = 0; index < numberGeometries; ++index) {
            Polygon polygon = (Polygon)object.getGeometryN(index);
            polygons.add(polygon);
        }
        return JTS_MULTI_POLYGON_CONVERTER.backwardConvert((Set<Polygon>)polygons);
    }
}

