/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.converters;

import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.converters.jts.JtsPolygonConverter;
import org.openstreetmap.atlas.utilities.conversion.TwoWayConverter;

public class WktPolygonConverter
implements TwoWayConverter<Polygon, String> {
    @Override
    public Polygon backwardConvert(String wkt) {
        com.vividsolutions.jts.geom.Polygon geometry = null;
        WKTReader myReader = new WKTReader();
        try {
            geometry = (com.vividsolutions.jts.geom.Polygon)myReader.read(wkt);
        }
        catch (ParseException | ClassCastException e) {
            throw new CoreException("Cannot parse wkt : {}", wkt);
        }
        return new JtsPolygonConverter().backwardConvert(geometry);
    }

    @Override
    public String convert(Polygon polygon) {
        com.vividsolutions.jts.geom.Polygon geometry = new JtsPolygonConverter().convert(polygon);
        return new WKTWriter().write(geometry);
    }
}

