/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.converters;

import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.converters.jts.JtsPolyLineConverter;
import org.openstreetmap.atlas.utilities.conversion.TwoWayConverter;

public class WktPolyLineConverter
implements TwoWayConverter<PolyLine, String> {
    @Override
    public PolyLine backwardConvert(String wkt) {
        LineString geometry = null;
        WKTReader myReader = new WKTReader();
        try {
            geometry = (LineString)myReader.read(wkt);
        }
        catch (ParseException | ClassCastException e) {
            throw new CoreException("Cannot parse wkt : {}", wkt);
        }
        return new JtsPolyLineConverter().backwardConvert(geometry);
    }

    @Override
    public String convert(PolyLine polyLine) {
        LineString geometry = new JtsPolyLineConverter().convert(polyLine);
        return new WKTWriter().write(geometry);
    }
}

