/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.converters;

import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKBWriter;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.converters.jts.JtsPolygonConverter;
import org.openstreetmap.atlas.utilities.conversion.TwoWayConverter;

public class WkbPolygonConverter
implements TwoWayConverter<Polygon, byte[]> {
    @Override
    public Polygon backwardConvert(byte[] wkb) {
        com.vividsolutions.jts.geom.Polygon geometry = null;
        WKBReader myReader = new WKBReader();
        try {
            geometry = (com.vividsolutions.jts.geom.Polygon)myReader.read(wkb);
        }
        catch (ParseException | ClassCastException e) {
            throw new CoreException("Cannot parse wkb : {}", WKBWriter.toHex(wkb));
        }
        return new JtsPolygonConverter().backwardConvert(geometry);
    }

    @Override
    public byte[] convert(Polygon polygon) {
        com.vividsolutions.jts.geom.Polygon geometry = new JtsPolygonConverter().convert(polygon);
        byte[] wkb = new WKBWriter().write(geometry);
        return wkb;
    }
}

