/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.boundary;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.index.strtree.STRtree;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.openstreetmap.atlas.geography.boundary.CountryBoundary;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.utilities.maps.MultiMap;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountryBoundaryMapCompareCommand
extends Command {
    private static final Logger logger = LoggerFactory.getLogger(CountryBoundaryMapCompareCommand.class);
    private static final Command.Switch<CountryBoundaryMap> BASELINE_MAP = new Command.Switch("baseline", "Path to file generated by CountryBoundaryMap to use as a baseline", path -> CountryBoundaryMap.fromPlainText(new File((String)path)), Command.Optionality.REQUIRED);
    private static final Command.Switch<CountryBoundaryMap> OTHER_MAP = new Command.Switch("new", "Path to file generated by CountryBoundaryMap to compare against baseline", path -> CountryBoundaryMap.fromPlainText(new File((String)path)), Command.Optionality.REQUIRED);

    static boolean areSTRtreesEqual(STRtree baselineTree, STRtree newTree) {
        MultiMap<Geometry, Envelope> baselineCells = new MultiMap<Geometry, Envelope>();
        CountryBoundaryMap.collectCells(baselineTree.getRoot(), baselineCells);
        MultiMap<Geometry, Envelope> newCells = new MultiMap<Geometry, Envelope>();
        CountryBoundaryMap.collectCells(newTree.getRoot(), newCells);
        if (baselineCells.size() != newCells.size()) {
            logger.error("Given trees has different number of cells. Baseline {} vs new {}.", (Object)baselineCells.size(), (Object)newCells.size());
            return false;
        }
        for (Geometry geometry : baselineCells.keySet()) {
            Object baselineEnvelopes = baselineCells.get(geometry);
            Object newEnvelopes = newCells.get(geometry);
            if (baselineEnvelopes == null || newEnvelopes == null) {
                logger.error("One of the tree is null for geometry {}. Baseline {} vs new {}.", new Object[]{geometry, baselineEnvelopes == null, newEnvelopes == null});
                return false;
            }
            if (baselineEnvelopes.size() != newEnvelopes.size()) {
                logger.error("Trees have different number of envelopes for geometry {}. Baseline {} vs new {}.", new Object[]{geometry, baselineEnvelopes.size(), newEnvelopes.size()});
                return false;
            }
            logger.debug("Comparing {} envelopes.", (Object)baselineEnvelopes.size());
            boolean foundEqual = ((Stream)baselineEnvelopes.stream().parallel()).allMatch(arg_0 -> CountryBoundaryMapCompareCommand.lambda$areSTRtreesEqual$3((List)newEnvelopes, arg_0));
            if (!foundEqual) {
                logger.error("At least one envelope couldn't be found in the new tree for geometry {}.", (Object)geometry);
                return false;
            }
            foundEqual = ((Stream)newEnvelopes.stream().parallel()).allMatch(arg_0 -> CountryBoundaryMapCompareCommand.lambda$areSTRtreesEqual$5((List)baselineEnvelopes, arg_0));
            if (foundEqual) continue;
            logger.error("New tree has at least one additional envelope for geometry {}.", (Object)geometry);
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        new CountryBoundaryMapCompareCommand().run(args);
    }

    @Override
    protected int onRun(CommandMap command) {
        CountryBoundaryMap baselineMap = (CountryBoundaryMap)command.get(BASELINE_MAP);
        CountryBoundaryMap newMap = (CountryBoundaryMap)command.get(OTHER_MAP);
        Set<String> baselineCountries = baselineMap.getLoadedCountries();
        Set<String> newCountries = newMap.getLoadedCountries();
        baselineCountries.forEach(country -> Assert.assertTrue(String.format("New map is missing country %s.", country), newCountries.contains(country)));
        newCountries.forEach(country -> Assert.assertTrue(String.format("New map has additional country %s.", country), baselineCountries.contains(country)));
        Assert.assertEquals("Map sizes are not equal.", baselineMap.size(), newMap.size());
        baselineMap.getLoadedCountries().forEach(country -> baselineMap.countryBoundary((String)country).forEach(countryBoundary -> {
            List newBoundaries = newMap.countryBoundary((String)country).stream().map(CountryBoundary::getBoundary).collect(Collectors.toList());
            Assert.assertTrue(String.format("New map is missing a boundary for %s.", country), newBoundaries.contains(countryBoundary.getBoundary()));
        }));
        newMap.getLoadedCountries().forEach(country -> newMap.countryBoundary((String)country).forEach(countryBoundary -> {
            List baselineBoundaries = baselineMap.countryBoundary((String)country).stream().map(CountryBoundary::getBoundary).collect(Collectors.toList());
            Assert.assertTrue(String.format("New map has additional boundary for %s.", country), baselineBoundaries.contains(countryBoundary.getBoundary()));
        }));
        Assert.assertFalse("One of the maps is missing raw index.", baselineMap.getRawIndex() == null ^ newMap.getRawIndex() == null);
        Assert.assertEquals("Node capacity of raw indeces are not equal.", baselineMap.getRawIndex().getNodeCapacity(), newMap.getRawIndex().getNodeCapacity());
        Assert.assertEquals("Depth of raw indeces are not equal.", baselineMap.getRawIndex().depth(), newMap.getRawIndex().depth());
        Assert.assertEquals("Size of raw indeces are not equal.", baselineMap.getRawIndex().size(), newMap.getRawIndex().size());
        Assert.assertTrue("Raw indeces are not equal.", CountryBoundaryMapCompareCommand.areSTRtreesEqual(baselineMap.getRawIndex(), newMap.getRawIndex()));
        Assert.assertFalse("One of the maps is missing grid index.", baselineMap.getGridIndex() == null ^ newMap.getGridIndex() == null);
        Assert.assertEquals("Node capacity of grid indeces are not equal.", baselineMap.getGridIndex().getNodeCapacity(), newMap.getGridIndex().getNodeCapacity());
        Assert.assertEquals("Depth of grid indeces are not equal.", baselineMap.getGridIndex().depth(), newMap.getGridIndex().depth());
        Assert.assertEquals("Size of grid indeces are not equal.", baselineMap.getGridIndex().size(), newMap.getGridIndex().size());
        Assert.assertTrue("Grid indeces are not equal.", CountryBoundaryMapCompareCommand.areSTRtreesEqual(baselineMap.getGridIndex(), newMap.getGridIndex()));
        logger.info("Compared given maps and found no difference.");
        return 0;
    }

    @Override
    protected Command.SwitchList switches() {
        return new Command.SwitchList().with(BASELINE_MAP, OTHER_MAP);
    }

    private static /* synthetic */ boolean lambda$areSTRtreesEqual$5(List baselineEnvelopes, Envelope newEnvelope) {
        return baselineEnvelopes.stream().anyMatch(envelope -> envelope.equals(newEnvelope));
    }

    private static /* synthetic */ boolean lambda$areSTRtreesEqual$3(List newEnvelopes, Envelope baselineEnvelope) {
        return newEnvelopes.stream().anyMatch(envelope -> envelope.equals(baselineEnvelope));
    }
}

