/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.boundary;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.geography.Located;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.sharding.SlippyTile;
import org.openstreetmap.atlas.utilities.collections.Iterables;

public class CountryBoundary
implements Located,
Serializable {
    private static final long serialVersionUID = 4728303272397434187L;
    private final String countryName;
    private final MultiPolygon boundary;

    public CountryBoundary(String name, MultiPolygon boundary) {
        this.countryName = name;
        this.boundary = boundary;
    }

    @Override
    public Rectangle bounds() {
        return this.boundary.bounds();
    }

    public boolean covers(Rectangle bound) {
        boolean covers = false;
        for (Polygon outer : this.boundary.outers()) {
            if (outer.fullyGeometricallyEncloses(bound)) {
                covers = true;
                break;
            }
            if (!outer.overlaps(bound)) continue;
            covers = true;
            break;
        }
        return covers;
    }

    public MultiPolygon getBoundary() {
        return this.boundary;
    }

    public String getCountryName() {
        return this.countryName;
    }

    public Set<SlippyTile> tiles(int zoom) {
        HashSet<SlippyTile> validTiles = new HashSet<SlippyTile>();
        for (Polygon subBoundary : this.boundary.outers()) {
            List<SlippyTile> tiles = Iterables.asList(SlippyTile.allTiles(zoom, subBoundary.bounds()));
            validTiles.addAll(tiles.stream().filter(tile -> subBoundary.overlaps(tile.bounds())).collect(Collectors.toList()));
        }
        return validTiles;
    }
}

