/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.walker;

import java.util.AbstractSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.utilities.collections.Iterables;

public abstract class EdgeWalker {
    public static final Comparator<Edge> DEFAULT_TRAVERSAL_ORDER = null;
    public static final Predicate<Edge> DEFAULT_CANDIDATE_FILTER = edge -> true;
    public static final EdgeHandler DEFAULT_EDGE_HANDLER = new EdgeHandler(){};
    private final Edge startingEdge;
    private final Comparator<Edge> edgeOrder;
    private final Predicate<Edge> candidateFilter;
    private final Function<Edge, Stream<Edge>> nextCandidates;
    private final EdgeHandler edgeHandler;

    protected EdgeWalker(Edge startingEdge, Comparator<Edge> edgeOrder, Predicate<Edge> candidateFilter, Function<Edge, Stream<Edge>> nextCandidates) {
        this(startingEdge, edgeOrder, candidateFilter, nextCandidates, DEFAULT_EDGE_HANDLER);
    }

    protected EdgeWalker(Edge startingEdge, Comparator<Edge> edgeOrder, Predicate<Edge> candidateFilter, Function<Edge, Stream<Edge>> nextCandidates, EdgeHandler edgeHandler) {
        this.startingEdge = startingEdge;
        this.edgeOrder = edgeOrder;
        this.candidateFilter = candidateFilter;
        this.nextCandidates = nextCandidates;
        this.edgeHandler = edgeHandler;
    }

    protected EdgeWalker(Edge startingEdge, Function<Edge, Stream<Edge>> nextCandidates) {
        this(startingEdge, DEFAULT_TRAVERSAL_ORDER, DEFAULT_CANDIDATE_FILTER, nextCandidates, DEFAULT_EDGE_HANDLER);
    }

    protected EdgeWalker(Edge startingEdge, Function<Edge, Stream<Edge>> nextCandidates, EdgeHandler edgeHandler) {
        this(startingEdge, DEFAULT_TRAVERSAL_ORDER, DEFAULT_CANDIDATE_FILTER, nextCandidates, edgeHandler);
    }

    protected EdgeWalker(Edge startingEdge, Predicate<Edge> candidateFilter, Function<Edge, Stream<Edge>> nextCandidates) {
        this(startingEdge, DEFAULT_TRAVERSAL_ORDER, candidateFilter, nextCandidates, DEFAULT_EDGE_HANDLER);
    }

    protected EdgeWalker(Edge startingEdge, Predicate<Edge> candidateFilter, Function<Edge, Stream<Edge>> nextCandidates, EdgeHandler edgeHandler) {
        this(startingEdge, DEFAULT_TRAVERSAL_ORDER, candidateFilter, nextCandidates, edgeHandler);
    }

    public Set<Edge> collectEdges() {
        AbstractSet edges = this.edgeOrder == null ? new LinkedHashSet() : new TreeSet<Edge>(this.edgeOrder);
        Predicate<Edge> unvisited = edge -> !edges.contains(edge);
        Set nextBoundaryEdges = Collections.singleton(this.startingEdge);
        do {
            edges.addAll(nextBoundaryEdges);
        } while ((nextBoundaryEdges = (Set)nextBoundaryEdges.stream().flatMap(edge -> {
            Set candidates = this.nextCandidates.apply((Edge)edge).filter(unvisited.and(this.candidateFilter)).collect(Collectors.toCollection(LinkedHashSet::new));
            if (candidates.isEmpty()) {
                this.edgeHandler.handleBoundaryEdge((Edge)edge);
            }
            if (!(!edge.equals(this.startingEdge) || edge.isConnectedAtStartTo(Iterables.asSet(candidates)) && edge.isConnectedAtEndTo(Iterables.asSet(candidates)))) {
                this.edgeHandler.handleBoundaryEdge((Edge)edge);
            }
            this.edgeHandler.handleEdge((Edge)edge);
            return candidates.stream();
        }).collect(Collectors.toCollection(LinkedHashSet::new))).size() > 0);
        return edges;
    }

    public static interface EdgeHandler {
        default public void handleBoundaryEdge(Edge edge) {
        }

        default public void handleEdge(Edge edge) {
        }
    }
}

