/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.statistics.coverage.poi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.LineItem;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.geography.atlas.items.complex.RelationOrAreaToMultiPolygonConverter;
import org.openstreetmap.atlas.geography.atlas.statistics.coverage.Coverage;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.filters.TaggableFilter;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.MultiIterable;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.scalars.Distance;
import org.openstreetmap.atlas.utilities.scalars.Surface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SimpleCoverage<T extends AtlasEntity>
extends Coverage<T> {
    private static final Logger logger = LoggerFactory.getLogger(SimpleCoverage.class);
    private static final String TYPE_SEPARATOR = ";";
    private static final String VALUES_SEPARATOR = ",";
    private static final String COMMENTED_LINE = "#";
    private static final int COVERAGE_TYPE_INDEX = 3;
    private static final String NODES = "nodes";
    private static final String EDGES = "edges";
    private static final String LINES = "lines";
    private static final String AREAS = "areas";
    private static final String POINTS = "points";
    private static final String RELATIONS = "relations";
    private final Predicate<Taggable> filter;
    private final Coverage.CoverageType coverageType;

    public static Iterable<SimpleCoverage<AtlasEntity>> parseSimpleCoverages(Atlas atlas, Iterable<String> coverages) {
        ArrayList<SimpleCoverage<AtlasEntity>> result = new ArrayList<SimpleCoverage<AtlasEntity>>();
        Iterable<String> filteredCoverages = Iterables.filter(coverages, line -> !line.startsWith(COMMENTED_LINE) && !"".equals(line));
        filteredCoverages.forEach(definition -> {
            try {
                StringList split = StringList.split(definition, TYPE_SEPARATOR);
                final StringList sources = StringList.split(split.get(1), VALUES_SEPARATOR);
                String type = split.get(0);
                String coverageTypes = split.size() > 3 ? split.get(3) : Coverage.CoverageType.COUNT.name();
                Set<Coverage.CoverageType> coverageTypeSet = StringList.split(coverageTypes, VALUES_SEPARATOR).stream().map(Coverage.CoverageType::forName).collect(Collectors.toSet());
                final TaggableFilter allowedTags = TaggableFilter.forDefinition(split.get(2));
                BiFunction<String, Coverage.CoverageType, SimpleCoverage> simpleCoverageFunction = (metricName, sampleCoverageType) -> new SimpleCoverage<AtlasEntity>(LoggerFactory.getLogger((String)metricName), atlas, sampleCoverageType){

                    @Override
                    protected Iterable<AtlasEntity> getEntities() {
                        if (sources.contains("all")) {
                            return this.getAtlas();
                        }
                        ArrayList<Iterable<AtlasEntity>> result = new ArrayList<Iterable<AtlasEntity>>();
                        if (sources.contains(SimpleCoverage.NODES)) {
                            result.add(this.getAtlas().nodes());
                        }
                        if (sources.contains(SimpleCoverage.EDGES)) {
                            result.add(this.getAtlas().edges());
                        }
                        if (sources.contains(SimpleCoverage.AREAS)) {
                            result.add(this.getAtlas().areas());
                        }
                        if (sources.contains(SimpleCoverage.LINES)) {
                            result.add(this.getAtlas().lines());
                        }
                        if (sources.contains(SimpleCoverage.POINTS)) {
                            result.add(this.getAtlas().points());
                        }
                        if (sources.contains(SimpleCoverage.RELATIONS)) {
                            result.add(this.getAtlas().relations());
                        }
                        return new MultiIterable<AtlasEntity>((Iterable<Iterable<AtlasEntity>>)result);
                    }

                    @Override
                    protected String type() {
                        return metricName;
                    }

                    @Override
                    protected Predicate<Taggable> validKeyValuePairs() {
                        return allowedTags;
                    }
                };
                coverageTypeSet.forEach(localCoverageType -> {
                    String appendix = Coverage.CoverageType.COUNT.equals(localCoverageType) ? "" : "_" + localCoverageType.name().toLowerCase();
                    String metricName = type + appendix;
                    result.add((SimpleCoverage<AtlasEntity>)simpleCoverageFunction.apply(metricName, (Coverage.CoverageType)((Object)((Object)localCoverageType))));
                });
            }
            catch (Exception e) {
                throw new CoreException("Error parsing {}", definition, e);
            }
        });
        return result;
    }

    public SimpleCoverage(Logger logger, Atlas atlas, Coverage.CoverageType coverageType) {
        super(logger, atlas);
        this.coverageType = coverageType;
        this.filter = this.validKeyValuePairs();
    }

    public SimpleCoverage(Logger logger, Atlas atlas, Predicate<T> filter, Coverage.CoverageType coverageType) {
        super(logger, atlas, filter);
        this.coverageType = coverageType;
        this.filter = this.validKeyValuePairs();
    }

    @Override
    protected Coverage.CoverageType coverageType() {
        return this.coverageType;
    }

    @Override
    protected Set<String> getKeys(AtlasEntity item) {
        return new HashSet<String>();
    }

    @Override
    protected String getUnit() {
        switch (this.coverageType()) {
            case COUNT: {
                return "count unit";
            }
            case DISTANCE: {
                return "kilometers";
            }
            case SURFACE: {
                return "square kilometers";
            }
        }
        throw new CoreException("Unknown coverage type: {}", this.coverageType.name());
    }

    @Override
    protected double getValue(T item) {
        switch (this.coverageType()) {
            case COUNT: {
                return 1.0;
            }
            case DISTANCE: {
                return this.getDistance((AtlasEntity)item).asKilometers();
            }
            case SURFACE: {
                return this.getSurface((AtlasEntity)item).asKilometerSquared();
            }
        }
        throw new CoreException("Unknown coverage type: {}", this.coverageType.name());
    }

    @Override
    protected boolean isCounted(T item) {
        return this.filter.test((Taggable)item);
    }

    @Override
    protected String subType() {
        return "true";
    }

    protected abstract Predicate<Taggable> validKeyValuePairs();

    private Distance getDistance(AtlasEntity item) {
        Distance result = Distance.ZERO;
        if (item instanceof LineItem) {
            return ((LineItem)item).asPolyLine().length();
        }
        if (item instanceof Relation) {
            for (RelationMember member : ((Relation)item).members()) {
                result = result.add(this.getDistance(member.getEntity()));
            }
        }
        return result;
    }

    private Surface getSurface(AtlasEntity item) {
        Surface result = Surface.MINIMUM;
        if (item instanceof Relation && ((Relation)item).isMultiPolygon() || item instanceof Area) {
            try {
                RelationOrAreaToMultiPolygonConverter converter = new RelationOrAreaToMultiPolygonConverter();
                result = result.add(((MultiPolygon)converter.apply(item)).surface());
                return result;
            }
            catch (CoreException converter) {
            }
            catch (IllegalArgumentException e) {
                logger.error("AtlasStatistics cannot compute surface of {}", (Object)item, (Object)e);
            }
            return result;
        }
        if (item instanceof Relation) {
            for (RelationMember member : ((Relation)item).members()) {
                result = result.add(this.getSurface(member.getEntity()));
            }
        }
        return result;
    }
}

