/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.statistics.coverage.linear;

import java.util.function.Predicate;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.LineItem;
import org.openstreetmap.atlas.geography.atlas.statistics.coverage.Coverage;
import org.slf4j.Logger;

public abstract class LinearCoverage<T extends LineItem>
extends Coverage<T> {
    public LinearCoverage(Logger logger, Atlas atlas) {
        super(logger, atlas);
    }

    public LinearCoverage(Logger logger, Atlas atlas, Predicate<T> filter) {
        super(logger, atlas, filter);
    }

    @Override
    protected Coverage.CoverageType coverageType() {
        return Coverage.CoverageType.DISTANCE;
    }

    @Override
    protected String getUnit() {
        return "kilometers";
    }

    @Override
    protected double getValue(T item) {
        return ((LineItem)item).asPolyLine().length().asKilometers();
    }
}

