/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.statistics.coverage;

import java.util.AbstractSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.statistics.AtlasStatistics;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.scalars.Ratio;
import org.openstreetmap.atlas.utilities.statistic.storeless.CounterWithStatistic;
import org.slf4j.Logger;

public abstract class Coverage<T extends AtlasEntity> {
    private static final int REPORT_FREQUENCY = 100000;
    public static final String AGGREGATE_KEY = "all";
    public static final String NULL_KEY = "";
    private final Logger logger;
    private final Atlas atlas;
    private final Predicate<T> filter;
    private Map<String, Double> counted;
    private Map<String, Double> total;
    private Map<String, Long> validCount;
    private Map<String, Long> totalCount;
    private CounterWithStatistic statistic;
    private Function<T, Integer> shardDivisor = null;
    private Comparator<String> keyComparator;

    public Coverage(Logger logger, Atlas atlas) {
        this(logger, atlas, item -> true);
    }

    public Coverage(Logger logger, Atlas atlas, Predicate<T> filter) {
        this.logger = logger;
        this.atlas = atlas;
        this.filter = filter;
        this.counted = new HashMap<String, Double>();
        this.total = new HashMap<String, Double>();
        this.validCount = new HashMap<String, Long>();
        this.totalCount = new HashMap<String, Long>();
        this.statistic = null;
        this.keyComparator = null;
    }

    public Ratio getCountCoverage(String key) {
        if (!this.counted.containsKey(key)) {
            throw new CoreException("Key {} is not valid.");
        }
        if (this.validCount.get(key) > this.totalCount.get(key)) {
            throw new CoreException("Invalid Ratio: {} / {}", this.validCount.get(key), this.totalCount.get(key));
        }
        if (this.totalCount.get(key) <= 0L) {
            return Ratio.percentage(0.0);
        }
        return Ratio.ratio((double)this.validCount.get(key).longValue() / (double)this.totalCount.get(key).longValue());
    }

    public Ratio getCoverage(String key) {
        if (!this.counted.containsKey(key)) {
            throw new CoreException("Key {} is not valid.");
        }
        if (this.counted.get(key) > this.total.get(key)) {
            throw new CoreException("Invalid Ratio: {} / {}", this.counted.get(key), this.total.get(key));
        }
        if (this.total.get(key) <= 0.0) {
            throw new CoreException("Invalid Total: {}", this.total.get(key));
        }
        return Ratio.ratio(this.counted.get(key) / this.total.get(key));
    }

    public Map<AtlasStatistics.StatisticKey, AtlasStatistics.StatisticValue> getStatistic() {
        HashMap<AtlasStatistics.StatisticKey, AtlasStatistics.StatisticValue> result = new HashMap<AtlasStatistics.StatisticKey, AtlasStatistics.StatisticValue>();
        for (String key : this.getKeys()) {
            double totalCount;
            double count;
            AtlasStatistics.StatisticKey statisticKey = new AtlasStatistics.StatisticKey(key, this.type(), this.subType());
            switch (this.coverageType()) {
                case DISTANCE: 
                case SURFACE: {
                    count = this.counted.get(key);
                    totalCount = this.total.get(key);
                    break;
                }
                case COUNT: {
                    count = this.validCount.get(key).longValue();
                    totalCount = this.totalCount.get(key).longValue();
                    break;
                }
                default: {
                    throw new CoreException("Unknown coverage type {}", new Object[]{this.coverageType()});
                }
            }
            AtlasStatistics.StatisticValue statisticValue = new AtlasStatistics.StatisticValue(count, totalCount);
            result.put(statisticKey, statisticValue);
        }
        return result;
    }

    public boolean hasKey(String key) {
        return this.counted.containsKey(key);
    }

    public void run() {
        this.statistic = new CounterWithStatistic(this.logger, 100000L, this.getClass().getSimpleName());
        this.items().forEach(item -> {
            this.statistic.increment();
            this.keys(item).forEach(key -> {
                double value = this.getValue(item);
                double adjustedValue = this.shardDivisor == null ? value : value / (double)this.shardDivisor.apply((AtlasEntity)item).intValue();
                this.increment((String)key, adjustedValue, this.isCounted(item));
            });
        });
    }

    public void setShardDivisor(Function<T, Integer> shardDivisor) {
        this.shardDivisor = shardDivisor;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(this.getClass().getSimpleName());
        builder.append(":\n");
        for (String key : this.getKeys()) {
            builder.append("\t");
            builder.append(key);
            builder.append(" = \n\t{\n\t\t");
            builder.append(this.getCoverage(key));
            builder.append(" of ");
            builder.append(String.format("%,.2f", this.total.get(key)));
            builder.append(" ");
            builder.append(this.getUnit());
            builder.append(",\n\t\t");
            builder.append(this.getCountCoverage(key));
            builder.append(" of ");
            builder.append(String.format("%,d", this.totalCount.get(key)));
            builder.append(" features\n\t},\n");
        }
        builder.append("]");
        return builder.toString();
    }

    protected abstract CoverageType coverageType();

    protected Atlas getAtlas() {
        return this.atlas;
    }

    protected abstract Iterable<T> getEntities();

    protected Set<String> getKeys() {
        AbstractSet keySet = this.keyComparator != null ? new TreeSet<String>(this.keyComparator) : new HashSet<String>();
        keySet.addAll(this.total.keySet());
        return keySet;
    }

    protected abstract Set<String> getKeys(T var1);

    protected abstract String getUnit();

    protected abstract double getValue(T var1);

    protected void increment(String key, double value, boolean valid) {
        if (value < 0.0) {
            throw new CoreException("Invalid value {}", value);
        }
        if (!this.total.containsKey(key)) {
            this.total.put(key, 0.0);
            this.totalCount.put(key, 0L);
            this.counted.put(key, 0.0);
            this.validCount.put(key, 0L);
        }
        this.total.put(key, this.total.get(key) + value);
        this.totalCount.put(key, this.totalCount.get(key) + 1L);
        if (valid) {
            this.counted.put(key, this.counted.get(key) + value);
            this.validCount.put(key, this.validCount.get(key) + 1L);
        }
    }

    protected abstract boolean isCounted(T var1);

    protected void setKeyComparator(Comparator<String> keyComparator) {
        this.keyComparator = keyComparator;
    }

    protected abstract String subType();

    protected abstract String type();

    private Iterable<T> items() {
        return Iterables.filter(this.getEntities(), this.filter);
    }

    private Set<String> keys(T item) {
        Set<String> result = this.getKeys(item);
        if (result.isEmpty()) {
            result.add(NULL_KEY);
        } else {
            result.add(AGGREGATE_KEY);
        }
        return result;
    }

    public static enum CoverageType {
        DISTANCE,
        SURFACE,
        COUNT;


        public static CoverageType forName(String name) {
            if (DISTANCE.name().equalsIgnoreCase(name)) {
                return DISTANCE;
            }
            if (SURFACE.name().equalsIgnoreCase(name)) {
                return SURFACE;
            }
            if (COUNT.name().equalsIgnoreCase(name)) {
                return COUNT;
            }
            throw new CoreException("Unknown coverage type {}", name);
        }
    }
}

