/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.statistics;

import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.streaming.Streams;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.StringList;

public class AtlasStatistics
implements Iterable<StatisticKey>,
Serializable {
    private static final long serialVersionUID = 1564587872667339612L;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final int TAG = 0;
    private static final int TYPE = 1;
    private static final int SUB_TYPE = 2;
    private static final int COUNT = 3;
    private static final int TOTAL = 4;
    private final Map<StatisticKey, StatisticValue> data;

    public static String csvHeader() {
        StringList header = new StringList();
        header.add("# tag");
        header.add("type");
        header.add("sub_type");
        header.add("count");
        header.add("total_count");
        return header.join(",");
    }

    public static AtlasStatistics fromResource(Resource resource) {
        AtlasStatistics result = new AtlasStatistics();
        resource.lines().forEach(line -> {
            if (line.startsWith("#")) {
                return;
            }
            StringList split = StringList.split(line, ",");
            StatisticKey key = new StatisticKey(split.get(0), split.get(1), split.get(2));
            StatisticValue value = new StatisticValue(Double.valueOf(split.get(3)), Double.valueOf(split.get(4)));
            result.add(key, value);
        });
        return result;
    }

    public static AtlasStatistics merge(AtlasStatistics ... statistics) {
        return AtlasStatistics.merge(Iterables.asList(statistics));
    }

    public static AtlasStatistics merge(Iterable<AtlasStatistics> statistics) {
        HashMap<StatisticKey, StatisticValue> mergedData = new HashMap<StatisticKey, StatisticValue>();
        for (AtlasStatistics source : statistics) {
            for (StatisticKey key : source) {
                StatisticValue value = source.get(key);
                if (mergedData.containsKey(key)) {
                    value = value.merge((StatisticValue)mergedData.get(key));
                    mergedData.remove(key);
                }
                mergedData.put(key, value);
            }
        }
        return new AtlasStatistics(mergedData);
    }

    public AtlasStatistics() {
        this.data = new HashMap<StatisticKey, StatisticValue>();
    }

    private AtlasStatistics(Map<StatisticKey, StatisticValue> data) {
        this.data = data;
    }

    public boolean equals(Object other) {
        return other instanceof AtlasStatistics ? ((AtlasStatistics)other).getData().equals(this.getData()) : false;
    }

    public StatisticValue get(StatisticKey key) {
        return this.data.get(key);
    }

    public StatisticValue get(String tag, String type, String subType) {
        return this.data.get(new StatisticKey(tag, type, subType));
    }

    public Map<StatisticKey, StatisticValue> getData() {
        return this.data;
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    @Override
    public Iterator<StatisticKey> iterator() {
        return this.data.keySet().iterator();
    }

    public void save(WritableResource writableResource) {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter(writableResource.write(), StandardCharsets.UTF_8));
            out.write(this.toString());
            Streams.close(out);
        }
        catch (Exception e) {
            Streams.close(out);
            throw new CoreException("Could not save AtlasStatistics to {}", (Throwable)e, writableResource);
        }
    }

    public String toString() {
        StringList result = new StringList();
        result.add(AtlasStatistics.csvHeader());
        this.data.forEach((? super K key, ? super V value) -> result.add(key + "," + value));
        return result.join(LINE_SEPARATOR);
    }

    protected void add(StatisticKey key, StatisticValue value) {
        this.data.put(key, value);
    }

    protected void append(Map<StatisticKey, StatisticValue> statistics) {
        this.data.putAll(statistics);
    }

    public static class StatisticValue
    implements Serializable {
        private static final long serialVersionUID = 1693304125915623196L;
        private final double count;
        private final double totalCount;

        public StatisticValue(double count, double totalCount) {
            this.count = count;
            this.totalCount = totalCount;
        }

        public boolean equals(Object other) {
            if (other instanceof StatisticValue) {
                StatisticValue that = (StatisticValue)other;
                return this.getCount() == that.getCount() && this.getTotalCount() == that.getTotalCount();
            }
            return false;
        }

        public double getCount() {
            return this.count;
        }

        public double getTotalCount() {
            return this.totalCount;
        }

        public int hashCode() {
            return Double.hashCode(this.count) + Double.hashCode(this.totalCount);
        }

        public StatisticValue merge(StatisticValue other) {
            return new StatisticValue(this.getCount() + other.getCount(), this.getTotalCount() + other.getTotalCount());
        }

        public String toString() {
            return String.format("%.2f", this.count) + "," + String.format("%.2f", this.totalCount);
        }
    }

    public static class StatisticKey
    implements Serializable {
        private static final long serialVersionUID = -4581103889690712256L;
        private final String tag;
        private final String type;
        private final String subType;

        public StatisticKey(String tag, String type, String subType) {
            this.tag = tag;
            this.type = type;
            this.subType = subType;
        }

        public boolean equals(Object other) {
            if (other instanceof StatisticKey) {
                StatisticKey that = (StatisticKey)other;
                return this.getTag().equalsIgnoreCase(that.getTag()) && this.getType().equals(that.getType()) && this.getSubType().equals(that.getSubType());
            }
            return false;
        }

        public String getSubType() {
            return this.subType;
        }

        public String getTag() {
            return this.tag;
        }

        public String getType() {
            return this.type;
        }

        public int hashCode() {
            return this.tag.toLowerCase().hashCode() + this.type.hashCode() + this.subType.hashCode();
        }

        public String toString() {
            return this.tag + "," + this.type + "," + StringEscapeUtils.escapeCsv(this.subType);
        }
    }
}

