/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.raw.slicing.changeset;

import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.builder.RelationBean;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.geography.atlas.pbf.slicing.identifier.ReverseIdentifierFactory;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.changeset.ChangeSetHandler;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.changeset.RelationChangeSet;
import org.openstreetmap.atlas.geography.atlas.raw.temporary.TemporaryLine;
import org.openstreetmap.atlas.geography.atlas.raw.temporary.TemporaryRelation;
import org.openstreetmap.atlas.geography.atlas.raw.temporary.TemporaryRelationMember;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationChangeSetHandler
extends ChangeSetHandler {
    private static final Logger logger = LoggerFactory.getLogger(RelationChangeSetHandler.class);
    private final RelationChangeSet changeSet;

    public RelationChangeSetHandler(Atlas atlas, RelationChangeSet changeSet) {
        super(atlas);
        this.changeSet = changeSet;
    }

    @Override
    public Atlas applyChanges() {
        Time time = Time.now();
        logger.info("Started Applying Relation Changes for {}", (Object)this.getShardOrAtlasName());
        if (logger.isInfoEnabled()) {
            logger.info("Before Slicing Relations: " + this.atlasStatistics(super.getAtlas()));
        }
        this.setAtlasSizeEstimateAndMetadata();
        this.addNewPoints();
        this.addExistingPointsAndLines();
        this.addNewLines();
        this.addUpdatedRelations();
        Atlas atlasWithUpdates = this.getBuilder().get();
        if (logger.isInfoEnabled()) {
            logger.info("After Slicing Relations: " + this.atlasStatistics(atlasWithUpdates));
        }
        logger.info("Finished Applying Relation Changes for {} in {}", (Object)this.getShardOrAtlasName(), (Object)time.elapsedSince());
        return atlasWithUpdates;
    }

    private void addExistingPointsAndLines() {
        this.getAtlas().points().forEach(point -> {
            if (!this.changeSet.getDeletedPoints().contains(point.getIdentifier())) {
                this.getBuilder().addPoint(point.getIdentifier(), point.getLocation(), point.getTags());
            }
        });
        this.getAtlas().lines().forEach(line -> {
            if (!this.changeSet.getDeletedLines().contains(line.getIdentifier())) {
                this.getBuilder().addLine(line.getIdentifier(), line.asPolyLine(), line.getTags());
            }
        });
    }

    private void addNewLines() {
        this.changeSet.getCreatedLines().values().forEach(line -> this.getBuilder().addLine(line.getIdentifier(), this.reconstructGeometryForLine((TemporaryLine)line), line.getTags()));
    }

    private void addNewPoints() {
        this.changeSet.getCreatedPoints().values().forEach(point -> this.getBuilder().addPoint(point.getIdentifier(), point.getLocation(), point.getTags()));
    }

    private void addRelation(Relation relation, Map<String, String> tags) {
        long identifier = relation.getIdentifier();
        RelationBean bean = this.constructRelationBean(relation);
        if (!bean.isEmpty()) {
            this.getBuilder().addRelation(identifier, this.getOsmIdentifier(identifier), bean, tags);
        } else {
            logger.error("Could not add Relation {} to atlas - it contains an empty Relation bean", (Object)identifier);
        }
    }

    private void addUpdatedRelations() {
        this.getAtlas().relationsLowerOrderFirst().forEach(relation -> {
            long identifier = relation.getIdentifier();
            if (this.changeSet.getDeletedToCreatedRelationMapping().containsKey(identifier)) {
                Object replacedIdentifiers = this.changeSet.getDeletedToCreatedRelationMapping().get(identifier);
                replacedIdentifiers.forEach(replacedIdentifier -> {
                    TemporaryRelation replacement = this.changeSet.getCreatedRelations().get(replacedIdentifier);
                    this.getBuilder().addRelation(replacement.getIdentifier(), this.getOsmIdentifier(replacement.getIdentifier()), replacement.getRelationBean(), replacement.getTags());
                });
            } else if (this.changeSet.getUpdatedRelationTags().containsKey(identifier)) {
                Relation originalRelation = this.getAtlas().relation(identifier);
                Map<String, String> updatedTags = originalRelation.getTags();
                updatedTags.putAll(this.changeSet.getUpdatedRelationTags().get(identifier));
                this.addRelation((Relation)relation, updatedTags);
            } else {
                logger.error("Adding Relation {} with missing country code to maintain Atlas integrity.", (Object)identifier);
                Map<String, String> updatedTags = relation.getTags();
                updatedTags.put("iso_country_code", "N/A");
                this.addRelation((Relation)relation, updatedTags);
            }
        });
    }

    private RelationBean constructRelationBean(Relation relation) {
        RelationBean bean = new RelationBean();
        if (!relation.members().isEmpty()) {
            Set membersToRemove = Optional.ofNullable(this.changeSet.getDeletedRelationMembers().get(relation.getIdentifier())).orElse(new HashSet());
            relation.members().forEach(member -> {
                if (this.shouldAddRelationMember(membersToRemove, (RelationMember)member)) {
                    bean.addItem(member.getEntity().getIdentifier(), member.getRole(), ItemType.forEntity(member.getEntity()));
                }
            });
        }
        Set membersToAdd = Optional.ofNullable(this.changeSet.getAddedRelationMembers().get(relation.getIdentifier())).orElse(new HashSet());
        for (TemporaryRelationMember memberToAdd : membersToAdd) {
            bean.addItem(memberToAdd.getIdentifier(), memberToAdd.getRole(), memberToAdd.getType());
        }
        if (bean.isEmpty()) {
            logger.error("Constructed an empty bean for relation {}", (Object)relation.getIdentifier());
        }
        return bean;
    }

    private long getOsmIdentifier(long identifier) {
        return new ReverseIdentifierFactory().getOsmIdentifier(identifier);
    }

    private boolean shouldAddRelationMember(Set<TemporaryRelationMember> membersToRemove, RelationMember member) {
        TemporaryRelationMember temporary = new TemporaryRelationMember(member.getEntity().getIdentifier(), member.getRole(), member.getEntity().getType());
        if (membersToRemove.contains(temporary)) {
            membersToRemove.remove(temporary);
            return false;
        }
        return true;
    }
}

