/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.pbf.store;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Latitude;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Longitude;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.atlas.pbf.AtlasLoadingOption;
import org.openstreetmap.atlas.geography.atlas.pbf.converters.TagMapToTagCollectionConverter;
import org.openstreetmap.atlas.geography.atlas.pbf.slicing.ChangeSet;
import org.openstreetmap.atlas.geography.atlas.pbf.store.PbfOneWay;
import org.openstreetmap.atlas.geography.atlas.pbf.store.TagMap;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.CountryCodeProperties;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.geography.boundary.converters.CountryListTwoWayStringConverter;
import org.openstreetmap.atlas.geography.converters.jts.JtsPointConverter;
import org.openstreetmap.atlas.tags.AtlasTag;
import org.openstreetmap.atlas.tags.SyntheticNearestNeighborCountryCodeTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.utilities.collections.Maps;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.scalars.Counter;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.container.v0_6.NodeContainer;
import org.openstreetmap.osmosis.core.container.v0_6.RelationContainer;
import org.openstreetmap.osmosis.core.container.v0_6.WayContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.CommonEntityData;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.EntityType;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;
import org.openstreetmap.osmosis.core.domain.v0_6.OsmUser;
import org.openstreetmap.osmosis.core.domain.v0_6.Relation;
import org.openstreetmap.osmosis.core.domain.v0_6.RelationMember;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;
import org.openstreetmap.osmosis.core.domain.v0_6.Way;
import org.openstreetmap.osmosis.core.domain.v0_6.WayNode;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.core.task.v0_6.SinkRunnableSource;
import org.openstreetmap.osmosis.xml.common.CompressionMethod;
import org.openstreetmap.osmosis.xml.v0_6.XmlWriter;

public class PbfMemoryStore
implements SinkRunnableSource {
    private static final JtsPointConverter JTS_POINT_CONVERTER = new JtsPointConverter();
    private static final TagMapToTagCollectionConverter TAG_MAP_TO_TAG_COLLECTION_CONVERTER = new TagMapToTagCollectionConverter();
    private static final CountryListTwoWayStringConverter COUNTRY_LIST_CONVERTER = new CountryListTwoWayStringConverter();
    private final Map<Long, Node> nodes = new HashMap<Long, Node>();
    private final Map<Long, Way> ways = new HashMap<Long, Way>();
    private final Map<Long, Relation> relations = new HashMap<Long, Relation>();
    private final Set<Long> nodesAtEndOfEdges = new HashSet<Long>();
    private final Set<Long> nodesInEdges = new HashSet<Long>();
    private final Set<Long> nodesInRelations = new HashSet<Long>();
    private final CountryBoundaryMap countryBoundaryMap;
    private final Set<String> defaultCountries;
    private final AtlasLoadingOption atlasLoadingOption;
    private Sink sink;

    public PbfMemoryStore(AtlasLoadingOption atlasLoadingOption) {
        this.countryBoundaryMap = atlasLoadingOption.getCountryBoundaryMap();
        this.defaultCountries = atlasLoadingOption.getCountryCodes();
        this.atlasLoadingOption = atlasLoadingOption;
    }

    public void addNode(Node node) {
        this.nodes.put(node.getId(), node);
    }

    public void addNodeAtEndOfEdge(long identifier) {
        this.nodesAtEndOfEdges.add(identifier);
    }

    public void addNodeInEdge(long identifier) {
        this.nodesInEdges.add(identifier);
    }

    public void addNodeInRelations(long identifier) {
        this.nodesInRelations.add(identifier);
    }

    public void addRelation(Relation relation) {
        this.relations.put(relation.getId(), relation);
    }

    public void addWay(Way way) {
        if (this.isAtlasEdge(way)) {
            List<WayNode> wayNodes = way.getWayNodes();
            this.nodesAtEndOfEdges.add(wayNodes.get(0).getNodeId());
            this.nodesAtEndOfEdges.add(wayNodes.get(wayNodes.size() - 1).getNodeId());
        }
        this.ways.put(way.getId(), way);
    }

    public void apply(ChangeSet changeSet) {
        this.apply(changeSet, true);
    }

    public void apply(ChangeSet changeSet, boolean delete) {
        changeSet.getCreatedNodes().forEach(this::addNode);
        changeSet.getCreatedWays().forEach(this::addWay);
        changeSet.getCreatedRelations().forEach(this::addRelation);
        if (delete) {
            changeSet.getDeletedWays().forEach(way -> this.removeWay(way.getId()));
            changeSet.getDeletedRelations().forEach(relation -> this.removeRelation(relation.getId()));
        }
    }

    public long atlasAreaCount() {
        return this.atlasAreas().count();
    }

    public Stream<Way> atlasAreas() {
        return this.ways.values().stream().filter(this::isAtlasArea);
    }

    public long atlasEdgeCount() {
        Counter counter = new Counter();
        this.atlasEdges().forEach(way -> {
            if (PbfOneWay.NO == new TagMap(way.getTags()).getOneWay()) {
                counter.add(2L);
            } else {
                counter.increment();
            }
        });
        return counter.getValue();
    }

    public Stream<Way> atlasEdges() {
        return this.ways.values().stream().filter(this::isAtlasEdge);
    }

    public long atlasLineCount() {
        return this.atlasLines().count();
    }

    public Stream<Way> atlasLines() {
        return this.ways.values().stream().filter(this::isAtlasLine);
    }

    public Set<Way> atlasLinesAndAreas() {
        return this.ways.values().stream().filter(way -> !this.isAtlasEdge((Way)way)).collect(Collectors.toSet());
    }

    public long atlasNodeCount() {
        return this.nodesAtEndOfEdges.size();
    }

    public Stream<Node> atlasNodes() {
        return this.nodesAtEndOfEdges.stream().map(this::getNode);
    }

    public long atlasPointCount() {
        return this.atlasPoints().count();
    }

    public Stream<Node> atlasPoints() {
        return this.nodes.values().stream().filter(this::isAtlasPoint);
    }

    public void clear() {
        this.clearNodes();
        this.clearWays();
        this.relations.clear();
        this.nodesAtEndOfEdges.clear();
        this.nodesInRelations.clear();
    }

    public void clearNodes() {
        this.nodes.clear();
    }

    public void clearWays() {
        this.ways.clear();
    }

    @Override
    public void complete() {
    }

    public boolean containsNode(long identifier) {
        return this.nodes.containsKey(identifier);
    }

    public boolean containsNodeAtEndOfEdges(long identifier) {
        return this.nodesAtEndOfEdges.contains(identifier);
    }

    public boolean containsNodeInEdges(long identifier) {
        return this.nodesInEdges.contains(identifier);
    }

    public boolean containsNodeInRelations(long identifier) {
        return this.nodesInRelations.contains(identifier);
    }

    public boolean containsRelation(long identifier) {
        return this.relations.containsKey(identifier);
    }

    public boolean containsWay(long identifier) {
        return this.ways.containsKey(identifier);
    }

    public Node createNode(long identifier, double latitude, double longitude) {
        return new Node(this.createNewEntityData(identifier, Maps.hashMap(new String[0])), latitude, longitude);
    }

    public Node createNode(long identifier, double latitude, double longitude, Map<String, String> tags) {
        return new Node(this.createNewEntityData(identifier, tags), latitude, longitude);
    }

    public Polygon createPolygon(Way way) {
        List<WayNode> wayNodes = way.getWayNodes();
        ArrayList<Location> locations = new ArrayList<Location>();
        for (int i = 0; i < wayNodes.size() - 1; ++i) {
            locations.add(this.getNodeLocation(wayNodes.get(i).getNodeId()));
        }
        return new Polygon((List<Location>)locations);
    }

    public PolyLine createPolyline(Way way) {
        List<WayNode> wayNodes = way.getWayNodes();
        ArrayList locations = new ArrayList();
        wayNodes.forEach(node -> locations.add(this.getNodeLocation(node.getNodeId())));
        return new PolyLine(locations);
    }

    public Relation createRelation(Relation reference, long identifier, List<RelationMember> members) {
        return new Relation(this.createCommonEntityData(reference, identifier), members);
    }

    public RelationMember createRelationMember(RelationMember reference, long identifier) {
        return new RelationMember(identifier, reference.getMemberType(), reference.getMemberRole());
    }

    public Way createWay(Way reference, long identifier, List<WayNode> wayNodes) {
        return new Way(this.createCommonEntityData(reference, identifier), wayNodes);
    }

    public void forEachAtlasEdge(Consumer<Way> action) {
        this.ways.values().stream().filter(this::isAtlasEdge).forEach(action);
    }

    public void forEachNode(BiConsumer<Long, Node> action) {
        this.nodes.forEach(action);
    }

    public void forEachRelation(BiConsumer<Long, Relation> action) {
        this.relations.forEach(action);
    }

    public void forEachWay(BiConsumer<Long, Way> action) {
        this.ways.forEach(action);
    }

    public AtlasLoadingOption getAtlasLoadingOption() {
        return this.atlasLoadingOption;
    }

    public Entity getEntity(RelationMember relationMember) {
        switch (relationMember.getMemberType()) {
            case Node: {
                return this.getNode(relationMember.getMemberId());
            }
            case Way: {
                return this.getWay(relationMember.getMemberId());
            }
            case Relation: {
                return this.getRelation(relationMember.getMemberId());
            }
        }
        throw new CoreException("Unsupported relation member type, {}", relationMember.getMemberType().toString());
    }

    public Node getNode(long identifier) {
        return this.nodes.get(identifier);
    }

    public Location getNodeLocation(long identifier) {
        return this.getNodeLocation(this.getNode(identifier));
    }

    public Location getNodeLocation(Node node) {
        return new Location(Latitude.degrees(node.getLatitude()), Longitude.degrees(node.getLongitude()));
    }

    public Map<Long, Node> getNodes() {
        return this.nodes;
    }

    public Set<Long> getNodesAtEndOfEdges() {
        return this.nodesAtEndOfEdges;
    }

    public Set<Long> getNodesInRelations() {
        return this.nodesInRelations;
    }

    public Relation getRelation(long identifier) {
        return this.relations.get(identifier);
    }

    public Map<Long, Relation> getRelations() {
        return this.relations;
    }

    public Map<String, String> getTagMap(Entity entity) {
        return new TagMap(entity.getTags()).getTags();
    }

    public Way getWay(long identifier) {
        return this.ways.get(identifier);
    }

    public Map<Long, Way> getWays() {
        return this.ways;
    }

    public boolean hasSameCountryCode(Node node) {
        String countries = this.tagsWithCountryCode(node).get("iso_country_code");
        if ("N/A".equals(countries)) {
            return true;
        }
        return this.hasSameCountryCode(countries);
    }

    public boolean hasSameCountryCode(String countries) {
        StringList countryList = COUNTRY_LIST_CONVERTER.convert(countries);
        if (this.defaultCountries.size() == 0) {
            return true;
        }
        for (String country : countryList) {
            if (!this.defaultCountries.contains(country)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void initialize(Map<String, Object> metaData) {
    }

    public boolean isAtlasArea(long identifier) {
        Way way = this.getWay(identifier);
        if (way != null) {
            return this.isAtlasArea(way);
        }
        return false;
    }

    public boolean isAtlasArea(Way way) {
        TagMap tags = new TagMap(way.getTags());
        return this.isRing(way) && this.moreThanThreeNodes(way) && !tags.hasHighwayTag() && !tags.matchFerry() && !tags.matchPier() && !tags.matchRailway();
    }

    public boolean isAtlasEdge(long identifier) {
        Way way = this.getWay(identifier);
        if (way != null) {
            return this.isAtlasEdge(way);
        }
        return false;
    }

    public boolean isAtlasEdge(Way way) {
        return this.atlasLoadingOption.getEdgeFilter().test(Taggable.with(way.getTags()));
    }

    public boolean isAtlasLine(long identifier) {
        Way way = this.getWay(identifier);
        if (way != null) {
            return this.isAtlasLine(way);
        }
        return false;
    }

    public boolean isAtlasLine(Way way) {
        return !this.isAtlasEdge(way) && (!this.isRing(way) || this.isOneNodeWay(way));
    }

    public boolean isAtlasNode(long identifier) {
        return this.nodesAtEndOfEdges.contains(identifier);
    }

    public boolean isAtlasPoint(long identifier) {
        Node node = this.getNode(identifier);
        if (node != null) {
            return this.isAtlasPoint(node);
        }
        return false;
    }

    public boolean isAtlasPoint(Node node) {
        boolean hasExplicitOsmTags = this.nodeHasExplicitOsmTags(node);
        long nodeIdentifier = node.getId();
        if (this.containsNodeInRelations(nodeIdentifier) && !hasExplicitOsmTags && !this.isAtlasNode(nodeIdentifier)) {
            return true;
        }
        return hasExplicitOsmTags;
    }

    public boolean isOneNodeWay(Way way) {
        return way.getWayNodes().size() == 1;
    }

    public boolean isRing(Way way) {
        List<WayNode> wayNodes = way.getWayNodes();
        return wayNodes.get(0).getNodeId() == wayNodes.get(wayNodes.size() - 1).getNodeId() && wayNodes.size() > 2;
    }

    public boolean moreThanThreeNodes(Way way) {
        int three = 3;
        return way.getWayNodes().size() > 3;
    }

    public int nodeCount() {
        return this.nodes.size();
    }

    @Override
    public void process(EntityContainer entityContainer) {
        Entity entity = entityContainer.getEntity();
        switch (entity.getType()) {
            case Node: {
                this.nodes.put(entity.getId(), (Node)entity);
                break;
            }
            case Way: {
                this.ways.put(entity.getId(), (Way)entity);
                break;
            }
            case Relation: {
                this.relations.put(entity.getId(), (Relation)entity);
                break;
            }
        }
    }

    public void rebuildNodesAtEndOfEdges() {
        this.nodesAtEndOfEdges.clear();
        this.atlasEdges().forEach(edge -> {
            List<WayNode> wayNodes = edge.getWayNodes();
            this.nodesAtEndOfEdges.add(wayNodes.get(0).getNodeId());
            this.nodesAtEndOfEdges.add(wayNodes.get(wayNodes.size() - 1).getNodeId());
        });
    }

    public void rebuildNodesInRelations() {
        this.nodesInRelations.clear();
        for (Relation relation : this.relations.values()) {
            for (RelationMember member : relation.getMembers()) {
                Long identifier;
                Node node;
                if (member.getMemberType() != EntityType.Node || (node = this.getNode(identifier = Long.valueOf(member.getMemberId()))) == null || !this.hasSameCountryCode(node)) continue;
                this.nodesInRelations.add(identifier);
            }
        }
    }

    public int relationCount() {
        return this.relations.size();
    }

    @Override
    public void release() {
    }

    public Node removeNode(long identifier) {
        if (this.nodesAtEndOfEdges.contains(identifier)) {
            this.nodesAtEndOfEdges.remove(identifier);
        }
        return this.nodes.remove(identifier);
    }

    public void removeOutsideWays() {
        HashSet waysToRemove = new HashSet();
        this.getWays().values().forEach(way -> {
            String countries = this.getTagMap((Entity)way).get("iso_country_code");
            if (countries != null && !this.hasSameCountryCode(countries)) {
                waysToRemove.add(way.getId());
            }
        });
        waysToRemove.forEach(this::removeWay);
    }

    public Relation removeRelation(long identifier) {
        return this.relations.remove(identifier);
    }

    public Way removeWay(long identifier) {
        return this.ways.remove(identifier);
    }

    public List<WayNode> reverse(List<WayNode> wayNodes) {
        ArrayList<WayNode> copy = new ArrayList<WayNode>(wayNodes);
        Collections.reverse(copy);
        return copy;
    }

    public Way reverse(Way reference) {
        return this.createWay(reference, reference.getId(), this.reverse(reference.getWayNodes()));
    }

    @Override
    public void run() {
        this.forEachNode((nodeIdentifier, node) -> this.sink.process(new NodeContainer((Node)node)));
        this.forEachWay((wayIdentifier, way) -> this.sink.process(new WayContainer((Way)way)));
        this.forEachRelation((relationIdentifier, relation) -> this.sink.process(new RelationContainer((Relation)relation)));
        this.sink.complete();
        this.sink.release();
    }

    @Override
    public void setSink(Sink sink) {
        this.sink = sink;
    }

    public Map<String, String> tagsWithCountryCode(Node node) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.putAll(this.getTagMap(node));
        if (tags.get("iso_country_code") == null) {
            if (this.countryBoundaryMap != null) {
                CountryCodeProperties countryProperties = this.countryBoundaryMap.getCountryCodeISO3(JTS_POINT_CONVERTER.convert(new Location(Latitude.degrees(node.getLatitude()), Longitude.degrees(node.getLongitude()))), true);
                tags.put("iso_country_code", countryProperties.getIso3CountryCode());
                if (countryProperties.usingNearestNeighbor()) {
                    tags.put("nearest_neighbor_country_code", SyntheticNearestNeighborCountryCodeTag.YES.toString());
                }
            } else {
                tags.put("iso_country_code", "N/A");
            }
        }
        return tags;
    }

    public int wayCount() {
        return this.ways.size();
    }

    public void writeXml(File file) throws IOException {
        XmlWriter writer = new XmlWriter(file, CompressionMethod.None);
        this.setSink(writer);
        this.run();
    }

    private CommonEntityData createCommonEntityData(Entity entity, long identifier) {
        return new CommonEntityData(identifier, entity.getVersion(), entity.getTimestampContainer(), entity.getUser(), entity.getChangesetId(), entity.getTags());
    }

    private CommonEntityData createNewEntityData(long identifier, Map<String, String> tags) {
        int fakeIdentifier = 195873;
        String fakeUser = "country_slicer";
        CommonEntityData data = new CommonEntityData(identifier, 1, new Date(), new OsmUser(195873, "country_slicer"), 1L, TAG_MAP_TO_TAG_COLLECTION_CONVERTER.convert(tags));
        return data;
    }

    private boolean nodeHasExplicitOsmTags(Node node) {
        int osmAndAtlasTagCount;
        int nodeTagSize = node.getTags().size();
        if (nodeTagSize > AtlasTag.TAGS_FROM_OSM.size()) {
            int counter = 0;
            for (Tag tag : node.getTags()) {
                if (!AtlasTag.TAGS_FROM_ATLAS.contains(tag.getKey())) continue;
                ++counter;
            }
            osmAndAtlasTagCount = AtlasTag.TAGS_FROM_OSM.size() + counter;
        } else {
            osmAndAtlasTagCount = nodeTagSize < AtlasTag.TAGS_FROM_OSM.size() ? nodeTagSize : AtlasTag.TAGS_FROM_OSM.size();
        }
        return nodeTagSize > osmAndAtlasTagCount;
    }
}

