/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.pbf.slicing.identifier;

import org.openstreetmap.atlas.exception.CoreException;

public abstract class AbstractIdentifierFactory {
    public static final long IDENTIFIER_SCALE = 1000L;
    private final long[] referenceIdentifiers;
    private int index;
    private long delta;

    public AbstractIdentifierFactory(long referenceIdentifier) {
        this(new long[]{referenceIdentifier});
    }

    public AbstractIdentifierFactory(long[] referenceIdentifierArray) {
        this.referenceIdentifiers = referenceIdentifierArray;
        this.delta = 0L;
        this.index = 0;
    }

    public long getDelta() {
        return this.delta;
    }

    public long getReferenceIdentifier() {
        return this.referenceIdentifiers[this.index];
    }

    public boolean hasMore() {
        return this.delta < 999L || this.index < this.referenceIdentifiers.length - 1;
    }

    public abstract long nextIdentifier();

    protected void incrementDelta() {
        ++this.delta;
        if (this.delta >= 1000L) {
            if (this.index < this.referenceIdentifiers.length - 1) {
                ++this.index;
                this.delta = 1L;
            } else {
                throw new CoreException("Entity {} has been split into more than 999 pieces", new Object[]{this.referenceIdentifiers});
            }
        }
    }
}

