/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.pbf.slicing;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum RelationType {
    MULTIPOLYGON,
    RESTRICTION,
    ROUTE,
    BOUNDARY,
    OTHER;

    private static final Map<String, RelationType> relationType;

    public static RelationType forValue(String value) {
        RelationType type = relationType.get(value);
        return type == null ? OTHER : type;
    }

    public String asTagValue() {
        return this.name().toLowerCase().intern();
    }

    static {
        HashMap<String, RelationType> map = new HashMap<String, RelationType>();
        for (RelationType type : RelationType.values()) {
            if (type == OTHER) continue;
            map.put(type.asTagValue(), type);
        }
        relationType = Collections.unmodifiableMap(map);
    }
}

