/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.pbf;

import com.vividsolutions.jts.geom.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.openstreetmap.atlas.geography.Latitude;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Longitude;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.atlas.builder.AtlasSize;
import org.openstreetmap.atlas.geography.atlas.builder.RelationBean;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlasBuilder;
import org.openstreetmap.atlas.geography.atlas.pbf.AtlasLoadingOption;
import org.openstreetmap.atlas.geography.atlas.pbf.OsmPbfStatistic;
import org.openstreetmap.atlas.geography.atlas.pbf.converters.TagMapToTagCollectionConverter;
import org.openstreetmap.atlas.geography.atlas.pbf.slicing.CountrySlicingProcessor;
import org.openstreetmap.atlas.geography.atlas.pbf.slicing.WaySectionProcessor;
import org.openstreetmap.atlas.geography.atlas.pbf.slicing.identifier.PaddingIdentifierFactory;
import org.openstreetmap.atlas.geography.atlas.pbf.store.PbfMemoryStore;
import org.openstreetmap.atlas.geography.atlas.pbf.store.PbfOneWay;
import org.openstreetmap.atlas.geography.atlas.pbf.store.TagMap;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.CountryCodeProperties;
import org.openstreetmap.atlas.geography.converters.jts.JtsPointConverter;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.RouteTag;
import org.openstreetmap.atlas.tags.SyntheticBoundaryNodeTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.utilities.collections.Maps;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.Bound;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.EntityType;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;
import org.openstreetmap.osmosis.core.domain.v0_6.Relation;
import org.openstreetmap.osmosis.core.domain.v0_6.RelationMember;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;
import org.openstreetmap.osmosis.core.domain.v0_6.Way;
import org.openstreetmap.osmosis.core.domain.v0_6.WayNode;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsmPbfProcessor
implements Sink {
    private static final Logger logger = LoggerFactory.getLogger(OsmPbfProcessor.class);
    private static final JtsPointConverter JTS_POINT_CONVERTER = new JtsPointConverter();
    private static final int MAXIMUM_NETWORK_EXTENSION = 100;
    private static final TagMapToTagCollectionConverter TAG_MAP_TO_TAG_COLLECTION_CONVERTER = new TagMapToTagCollectionConverter();
    private final PackedAtlasBuilder builder;
    private final AtlasLoadingOption loadingOption;
    private final MultiPolygon multiPolygon;
    private final PbfMemoryStore store;
    private final OsmPbfStatistic statistic = new OsmPbfStatistic(logger);
    private Set<Long> nodesOutsideOfPolygon = new HashSet<Long>();
    private Map<Long, Way> allWays = new HashMap<Long, Way>();
    private Map<Long, Relation> allRelations = new HashMap<Long, Relation>();
    private boolean firstPass;
    private boolean secondPass;
    private final Set<Long> nodesOutsideOfCountry = new HashSet<Long>();
    private final Set<Long> nodeIdentifiersAtNetworkBoundary = new HashSet<Long>();

    public OsmPbfProcessor(PackedAtlasBuilder builder, AtlasLoadingOption loadingOption, MultiPolygon multiPolygon) {
        this.builder = builder;
        this.loadingOption = loadingOption;
        this.multiPolygon = multiPolygon;
        this.firstPass = true;
        this.secondPass = false;
        this.store = new PbfMemoryStore(this.loadingOption);
    }

    @Override
    public void complete() {
    }

    @Override
    public void initialize(Map<String, Object> metaData) {
        if (this.firstPass) {
            logger.trace("Start loading atlas with polygon or bound {}", (Object)this.multiPolygon);
            logger.trace("With country code {}", (Object)String.join((CharSequence)",", this.loadingOption.getCountryCodes()));
        }
    }

    @Override
    public void process(EntityContainer entityContainer) {
        Entity rawEntity = entityContainer.getEntity();
        if (this.shouldProcessEntity(rawEntity)) {
            this.statistic.incrementOsmEntity();
            Entity entity = this.preProcess(rawEntity);
            if (this.loadingOption.isLoadOsmNode() && entity instanceof Node) {
                this.processNode(entity);
            } else if (this.loadingOption.isLoadOsmWay() && entity instanceof Way) {
                this.processWay(entity);
            } else if (this.loadingOption.isLoadOsmRelation() && entity instanceof Relation) {
                this.processRelation(entity);
            } else if (this.loadingOption.isLoadOsmBound() && entity instanceof Bound) {
                this.statistic.pauseOsmRelationCounter();
            }
        }
    }

    @Override
    public void release() {
        if (this.firstPass) {
            this.calculateRelationsInsideTargetPolygon();
            this.calculateWaysAndNodes();
            this.keepOutsideWaysThatAreConnected();
            this.allWays = null;
            this.allRelations = null;
        } else if (this.secondPass) {
            if (this.loadingOption.isCountrySlicing()) {
                logger.info("Running country slicing");
                new CountrySlicingProcessor(this.store, this.loadingOption.getCountryBoundaryMap(), this.loadingOption.getCountryCodes()).run();
                this.store.removeOutsideWays();
                this.store.rebuildNodesAtEndOfEdges();
                this.store.rebuildNodesInRelations();
            }
            if (this.loadingOption.isWaySectioning()) {
                logger.info("Running way sectioning");
                new WaySectionProcessor(this.store).run();
            }
            long atlasNodeNumber = this.store.atlasNodeCount();
            long atlasPointNumber = this.store.atlasPointCount();
            long atlasEdgeNumber = this.store.atlasEdgeCount();
            long atlasLineNumber = this.store.atlasLineCount();
            long atlasAreaNumber = this.store.atlasAreaCount();
            long atlasRelationNumber = this.store.relationCount();
            this.builder.setSizeEstimates(new AtlasSize(atlasEdgeNumber, atlasNodeNumber, atlasAreaNumber, atlasLineNumber, atlasPointNumber, atlasRelationNumber));
            logger.info("Initialize Atlas builder with {} nodes, {} points, {} edges, {} lines, {} areas and {} relations", new Object[]{atlasNodeNumber, atlasPointNumber, atlasEdgeNumber, atlasLineNumber, atlasAreaNumber, atlasRelationNumber});
            this.buildNodes();
            this.buildWays();
            this.buildRelations();
            this.nodesOutsideOfPolygon = null;
            this.store.clear();
        }
        this.statistic.summary();
        this.statistic.clear();
        logger.info("{} pass loading done", (Object)(this.firstPass ? "First" : "Second"));
        if (this.firstPass) {
            this.firstPass = false;
            this.secondPass = true;
        }
    }

    private void addWayNodes(Set<Long> set, Way way) {
        way.getWayNodes().forEach(wayNode -> set.add(wayNode.getNodeId()));
    }

    private void buildNodes() {
        logger.trace("Precheck all OSM ways and relations");
        HashSet<Long> nodesNeedBuild = new HashSet<Long>();
        this.store.atlasEdges().forEach(edge -> this.addWayNodes((Set<Long>)nodesNeedBuild, (Way)edge));
        this.store.atlasLines().forEach(line -> this.addWayNodes((Set<Long>)nodesNeedBuild, (Way)line));
        this.store.atlasAreas().forEach(area -> this.addWayNodes((Set<Long>)nodesNeedBuild, (Way)area));
        nodesNeedBuild.addAll(this.store.getNodesInRelations());
        logger.trace("Building Atlas for nodes");
        this.store.atlasNodes().forEach(node -> {
            long identifier = node.getId();
            if (nodesNeedBuild.contains(identifier) || this.store.hasSameCountryCode((Node)node)) {
                this.builder.addNode(identifier, this.store.getNodeLocation((Node)node), this.store.tagsWithCountryCode((Node)node));
                this.statistic.incrementAtlasNode();
            } else {
                this.nodesOutsideOfCountry.add(node.getId());
            }
        });
        this.store.atlasPoints().forEach(point -> {
            long identifier = point.getId();
            if (nodesNeedBuild.contains(identifier) || this.store.hasSameCountryCode((Node)point)) {
                this.builder.addPoint(identifier, this.store.getNodeLocation((Node)point), this.store.tagsWithCountryCode((Node)point));
                this.statistic.incrementAtlasPoint();
            } else {
                this.nodesOutsideOfCountry.add(point.getId());
            }
        });
    }

    private boolean buildRelation(long identifier, Set<Long> visited, List<Long> parentTree) {
        if (!visited.contains(identifier)) {
            visited.add(identifier);
            parentTree.add(identifier);
            Relation relation = this.store.getRelation(identifier);
            if (relation == null) {
                return false;
            }
            TagMap tags = new TagMap(relation.getTags());
            RelationBean bean = new RelationBean();
            for (RelationMember member : relation.getMembers()) {
                long memberIdentifier = member.getMemberId();
                EntityType memberType = member.getMemberType();
                String role = member.getMemberRole();
                if (memberType == EntityType.Node && this.store.containsNode(memberIdentifier) && !this.nodesOutsideOfCountry.contains(memberIdentifier)) {
                    if (this.store.isAtlasNode(memberIdentifier)) {
                        bean.addItem(memberIdentifier, role, ItemType.NODE);
                        continue;
                    }
                    if (this.store.isAtlasPoint(memberIdentifier)) {
                        bean.addItem(memberIdentifier, role, ItemType.POINT);
                        continue;
                    }
                    logger.warn("Ignoring node {} for relation {} since it was not defined by Atlas node/point", (Object)memberIdentifier, (Object)identifier);
                    continue;
                }
                if (memberType == EntityType.Way && this.store.containsWay(memberIdentifier)) {
                    if (this.store.isAtlasEdge(memberIdentifier)) {
                        bean.addItem(memberIdentifier, role, ItemType.EDGE);
                        if (this.builder.peek().edge(-memberIdentifier) == null) continue;
                        bean.addItem(-memberIdentifier, role, ItemType.EDGE);
                        continue;
                    }
                    if (this.store.isAtlasLine(memberIdentifier)) {
                        bean.addItem(memberIdentifier, role, ItemType.LINE);
                        continue;
                    }
                    if (this.store.isAtlasArea(memberIdentifier)) {
                        bean.addItem(memberIdentifier, role, ItemType.AREA);
                        continue;
                    }
                    logger.warn("Ignoring way {} for relation {} since it was not defined by Atlas edge/line/area", (Object)memberIdentifier, (Object)identifier);
                    continue;
                }
                if (memberType != EntityType.Relation) continue;
                if (!parentTree.contains(memberIdentifier)) {
                    if (!this.buildRelation(memberIdentifier, visited, parentTree)) {
                        logger.warn("Ignoring member relation {} with role {} within relation {} since it was not defined by Atlas relation", new Object[]{memberIdentifier, role, identifier});
                    }
                    if (this.builder.peek().relation(memberIdentifier) == null) continue;
                    bean.addItem(memberIdentifier, role, ItemType.RELATION);
                    continue;
                }
                logger.error("Ignoring member relation {} within parent relation {} since there is a loop! Parent Tree: {}", new Object[]{memberIdentifier, identifier, parentTree});
            }
            if (!bean.isEmpty()) {
                this.builder.addRelation(identifier, identifier, bean, tags.getTags());
                this.statistic.incrementAtlasRelation();
            } else {
                logger.warn("Dropping relation {} because no members were found.", (Object)identifier);
            }
        }
        return true;
    }

    private void buildRelations() {
        logger.trace("Building Atlas for relations");
        HashSet visited = new HashSet();
        this.store.forEachRelation((identifier, relation) -> this.buildRelation((long)identifier, visited, (List<Long>)new ArrayList<Long>()));
    }

    private void buildWays() {
        logger.trace("Building Atlas for ways");
        this.store.atlasEdges().forEach(edge -> {
            long identifier = edge.getId();
            PolyLine polyline = this.store.createPolyline((Way)edge);
            TagMap tags = new TagMap(edge.getTags());
            PbfOneWay oneWay = tags.getOneWay();
            switch (oneWay) {
                case NO: {
                    this.builder.addEdge(identifier, polyline, tags.getTags());
                    this.builder.addEdge(-identifier, polyline.reversed(), tags.getTags());
                    this.statistic.incrementAtlasEdge(2);
                    break;
                }
                case YES: {
                    this.builder.addEdge(identifier, polyline, tags.getTags());
                    this.statistic.incrementAtlasEdge();
                    break;
                }
                case REVERSED: {
                    this.builder.addEdge(identifier, polyline.reversed(), tags.getTags());
                    this.statistic.incrementAtlasEdge();
                    break;
                }
            }
        });
        this.store.atlasLines().forEach(line -> {
            long identifier = line.getId();
            this.builder.addLine(identifier, this.store.createPolyline((Way)line), this.store.getTagMap((Entity)line));
            this.statistic.incrementAtlasLine();
        });
        this.store.atlasAreas().forEach(area -> {
            long identifier = area.getId();
            this.builder.addArea(identifier, this.store.createPolygon((Way)area), this.store.getTagMap((Entity)area));
            this.statistic.incrementAtlasArea();
        });
    }

    private void calculateRelationsInsideTargetPolygon() {
        HashSet waysToBeAdded = new HashSet();
        HashSet relationsToBeAdded = new HashSet();
        for (Relation parent : this.allRelations.values()) {
            long parentIdentifier = parent.getId();
            boolean isShallow = this.isShallow(parent);
            if (this.store.containsRelation(parentIdentifier)) continue;
            LinkedList<Long> nested = new LinkedList<Long>();
            HashSet<Long> visited = new HashSet<Long>();
            boolean inside = false;
            nested.offer(parentIdentifier);
            while (!nested.isEmpty()) {
                long childIdentifier = (Long)nested.poll();
                Relation child = this.allRelations.get(childIdentifier);
                if (child == null) {
                    logger.warn("Missing Data in PBF: Parent relation {} references child relation {} which is not present.", (Object)parentIdentifier, (Object)childIdentifier);
                    if (!isShallow) break;
                    inside = false;
                    break;
                }
                if (this.store.containsRelation(childIdentifier)) {
                    inside = true;
                    continue;
                }
                if (visited.contains(child.getId())) {
                    logger.warn("Corrupted data, found loop relations: parent {}, child {}", (Object)parent, (Object)child);
                    inside = false;
                    break;
                }
                for (RelationMember member : child.getMembers()) {
                    long memberIdentifier = member.getMemberId();
                    EntityType memberType = member.getMemberType();
                    if (memberType == EntityType.Node && this.store.containsNode(memberIdentifier) || memberType == EntityType.Way && this.store.containsWay(memberIdentifier)) {
                        inside = true;
                        continue;
                    }
                    if (memberType != EntityType.Relation) continue;
                    nested.offer(memberIdentifier);
                }
                visited.add(child.getId());
            }
            if (!inside) continue;
            visited.forEach(relationIdentifier -> {
                Relation relation = this.allRelations.get(relationIdentifier);
                for (RelationMember member : relation.getMembers()) {
                    long memberIdentifier = member.getMemberId();
                    EntityType memberType = member.getMemberType();
                    if (memberType == EntityType.Node) {
                        if (!this.store.containsNode(memberIdentifier)) {
                            this.nodesOutsideOfPolygon.add(memberIdentifier);
                        }
                        this.store.addNodeInRelations(memberIdentifier);
                    }
                    if (memberType != EntityType.Way || this.store.containsWay(memberIdentifier) || !this.allWays.containsKey(memberIdentifier)) continue;
                    waysToBeAdded.add(this.allWays.get(memberIdentifier));
                }
                relationsToBeAdded.add(relation);
                this.statistic.incrementAtlasRelation();
            });
        }
        waysToBeAdded.forEach(this.store::addWay);
        relationsToBeAdded.forEach(this.store::addRelation);
    }

    private void calculateWaysAndNodes() {
        this.store.forEachWay((wayIdentifier, way) -> {
            List<WayNode> wayNodes = way.getWayNodes();
            TagMap tags = new TagMap(way.getTags());
            for (WayNode node : wayNodes) {
                long nodeIdentifier = node.getNodeId();
                if (this.store.containsNode(nodeIdentifier)) continue;
                this.nodesOutsideOfPolygon.add(nodeIdentifier);
            }
            if (this.store.isAtlasEdge((long)wayIdentifier)) {
                wayNodes.stream().map(WayNode::getNodeId).forEach(this.store::addNodeInEdge);
                this.store.addNodeAtEndOfEdge(wayNodes.get(0).getNodeId());
                this.store.addNodeAtEndOfEdge(wayNodes.get(wayNodes.size() - 1).getNodeId());
                PbfOneWay oneWay = tags.getOneWay();
                if (oneWay == PbfOneWay.NO) {
                    this.statistic.incrementAtlasEdge(2);
                } else {
                    this.statistic.incrementAtlasEdge();
                }
            } else if (this.store.isAtlasLine((long)wayIdentifier)) {
                this.statistic.incrementAtlasLine();
            } else if (this.store.isAtlasArea((long)wayIdentifier)) {
                this.statistic.incrementAtlasArea();
            }
        });
    }

    private boolean isHighwayOrFerry(final Way way) {
        Taggable taggableWay = new Taggable(){
            private Map<String, String> tags = null;

            @Override
            public Optional<String> getTag(String key) {
                if (this.tags == null) {
                    this.tags = new HashMap<String, String>();
                    for (Tag tag : way.getTags()) {
                        this.tags.put(tag.getKey(), tag.getValue());
                    }
                }
                return Optional.ofNullable(this.tags.get(key));
            }
        };
        return HighwayTag.isCoreWay(taggableWay) || RouteTag.isFerry(taggableWay);
    }

    private boolean isOutsideBoundary(Node node) {
        Point nodeLocation = JTS_POINT_CONVERTER.convert(new Location(Latitude.degrees(node.getLatitude()), Longitude.degrees(node.getLongitude())));
        CountryCodeProperties countryCodeProperties = this.loadingOption.getCountryBoundaryMap().getCountryCodeISO3(nodeLocation, false);
        return "N/A".equals(countryCodeProperties.getIso3CountryCode()) || countryCodeProperties.usingNearestNeighbor();
    }

    private boolean isShallow(Relation relation) {
        LinkedList<Long> nested = new LinkedList<Long>();
        HashSet<Long> visited = new HashSet<Long>();
        nested.offer(relation.getId());
        while (!nested.isEmpty()) {
            Relation candidate = this.allRelations.get(nested.poll());
            if (candidate == null) continue;
            visited.add(candidate.getId());
            for (RelationMember member : candidate.getMembers()) {
                long memberIdentifier = member.getMemberId();
                EntityType memberType = member.getMemberType();
                if (memberType == EntityType.Node && this.store.containsNode(memberIdentifier) || memberType == EntityType.Way && this.store.containsWay(memberIdentifier)) {
                    return false;
                }
                if (!visited.contains(memberIdentifier)) {
                    nested.offer(memberIdentifier);
                    continue;
                }
                logger.warn("Loop in the tree of relation {}. Offending member: {}", (Object)relation.getId(), (Object)memberIdentifier);
            }
        }
        return true;
    }

    private void keepOutsideWaysThatAreConnected() {
        if (this.loadingOption.isLoadWaysSpanningCountryBoundaries()) {
            int counter = 0;
            ArrayList<Boolean> lastAddedRoads = new ArrayList<Boolean>();
            HashSet alreadyAddedWays = new HashSet();
            lastAddedRoads.add(true);
            while (counter++ < 100 && ((Boolean)lastAddedRoads.get(0)).booleanValue()) {
                logger.trace("keepOutsideWaysThatAreConnected while loop iteration {}", (Object)counter);
                lastAddedRoads.set(0, false);
                this.allWays.values().stream().filter(this::isHighwayOrFerry).forEach(way -> {
                    if (!this.store.containsWay(way.getId()) || !this.partialInside((Way)way) && !alreadyAddedWays.contains(way.getId())) {
                        List<WayNode> wayNodes = way.getWayNodes();
                        for (WayNode wayNode : wayNodes) {
                            long identifier = wayNode.getNodeId();
                            if (!this.store.containsNodeInEdges(identifier)) continue;
                            this.store.addWay((Way)way);
                            logger.info("Adding outside way {} connected at node {}", (Object)way.getId(), (Object)identifier);
                            lastAddedRoads.set(0, true);
                            alreadyAddedWays.add(way.getId());
                            this.nodeIdentifiersAtNetworkBoundary.remove(new Long(identifier));
                            for (WayNode subWayNode : wayNodes) {
                                long subWayNodeIdentifier = subWayNode.getNodeId();
                                this.store.addNodeInEdge(subWayNodeIdentifier);
                                if (this.store.containsNode(subWayNodeIdentifier)) continue;
                                if (subWayNodeIdentifier != identifier) {
                                    this.nodeIdentifiersAtNetworkBoundary.add(subWayNodeIdentifier);
                                }
                                this.nodesOutsideOfPolygon.add(subWayNodeIdentifier);
                            }
                        }
                    }
                });
            }
        }
    }

    private boolean needPadding() {
        return this.loadingOption.isCountrySlicing() || this.loadingOption.isWaySectioning();
    }

    private boolean partialInside(Way way) {
        for (WayNode node : way.getWayNodes()) {
            if (!this.store.containsNode(node.getNodeId())) continue;
            return true;
        }
        return false;
    }

    private Entity preProcess(Entity entity) {
        Collection<Tag> tags = entity.getTags();
        tags.add(new Tag("last_edit_time", String.valueOf(entity.getTimestamp().getTime())));
        tags.add(new Tag("last_edit_user_id", String.valueOf(entity.getUser().getId())));
        tags.add(new Tag("last_edit_user_name", entity.getUser().getName()));
        tags.add(new Tag("last_edit_version", String.valueOf(entity.getVersion())));
        tags.add(new Tag("last_edit_changeset", String.valueOf(entity.getChangesetId())));
        return entity;
    }

    private void processNode(Entity entity) {
        Node node = (Node)entity;
        if (this.needPadding()) {
            node.setId(PaddingIdentifierFactory.pad(node.getId()));
        }
        Location location = new Location(Latitude.degrees(node.getLatitude()), Longitude.degrees(node.getLongitude()));
        if (this.firstPass && this.multiPolygon.fullyGeometricallyEncloses(location)) {
            this.store.addNode(node);
        } else if (this.secondPass && this.nodesOutsideOfPolygon.contains(node.getId())) {
            this.tagOutsideBoundaryNodes(node);
            this.store.addNode(node);
        }
        this.statistic.incrementOsmNode();
    }

    private void processRelation(Entity entity) {
        Relation relation;
        this.statistic.pauseOsmWayCounter();
        Relation reference = (Relation)entity;
        if (this.needPadding()) {
            ArrayList<RelationMember> list = new ArrayList<RelationMember>();
            for (RelationMember member : reference.getMembers()) {
                list.add(new RelationMember(PaddingIdentifierFactory.pad(member.getMemberId()), member.getMemberType(), member.getMemberRole()));
            }
            relation = this.store.createRelation(reference, PaddingIdentifierFactory.pad(reference.getId()), list);
        } else {
            relation = reference;
        }
        if (this.firstPass) {
            this.allRelations.put(relation.getId(), relation);
        }
        this.statistic.incrementOsmRelation();
    }

    private void processWay(Entity entity) {
        Way way;
        this.statistic.pauseOsmNodeCounter();
        Way reference = (Way)entity;
        if (this.needPadding()) {
            ArrayList<WayNode> list = new ArrayList<WayNode>();
            for (WayNode wayNode : reference.getWayNodes()) {
                list.add(new WayNode(PaddingIdentifierFactory.pad(wayNode.getNodeId())));
            }
            way = this.store.createWay(reference, PaddingIdentifierFactory.pad(reference.getId()), list);
        } else {
            way = reference;
        }
        if (this.firstPass) {
            this.allWays.put(way.getId(), way);
            if (this.partialInside(way)) {
                this.store.addWay(way);
            }
        }
        this.statistic.incrementOsmWay();
    }

    private boolean shouldProcessEntity(Entity entity) {
        if (entity instanceof Node) {
            return this.loadingOption.getOsmPbfNodeFilter().test(Taggable.with(entity.getTags()));
        }
        if (entity instanceof Way) {
            return this.loadingOption.getOsmPbfWayFilter().test(Taggable.with(entity.getTags()));
        }
        if (entity instanceof Relation) {
            return this.loadingOption.getOsmPbfRelationFilter().test(Taggable.with(entity.getTags()));
        }
        return true;
    }

    private void tagOutsideBoundaryNodes(Node node) {
        if (this.nodeIdentifiersAtNetworkBoundary.contains(node.getId()) && this.isOutsideBoundary(node)) {
            Map<String, String> boundaryNodeTags = Maps.hashMap("synthetic_boundary_node", SyntheticBoundaryNodeTag.EXISTING.name().toLowerCase());
            ArrayList<Tag> tags = new ArrayList<Tag>();
            tags.addAll(node.getTags());
            tags.addAll(TAG_MAP_TO_TAG_COLLECTION_CONVERTER.convert(boundaryNodeTags));
            node.getTags().clear();
            node.getTags().addAll(tags);
        }
    }
}

