/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.packed;

import java.util.Map;
import java.util.Optional;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.AtlasMetaData;
import org.openstreetmap.atlas.geography.atlas.builder.RelationBean;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlas;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlasBuilder;

public class PackedAtlasCloner {
    private String shardName = null;
    private Optional<Map<String, String>> additionalMetaDataTags = Optional.empty();

    public PackedAtlasCloner() {
    }

    public PackedAtlasCloner(String shardName) {
        this.shardName = shardName;
    }

    public PackedAtlas cloneFrom(Atlas atlas) {
        PackedAtlasBuilder builder = new PackedAtlasBuilder();
        builder.setSizeEstimates(atlas.metaData().getSize());
        AtlasMetaData metaData = atlas.metaData();
        if (this.shardName != null) {
            metaData.copyWithNewShardName(this.shardName);
        }
        if (this.additionalMetaDataTags.isPresent()) {
            Map<String, String> atlasTags = metaData.getTags();
            atlasTags.putAll(this.additionalMetaDataTags.get());
            metaData = new AtlasMetaData(metaData.getSize(), metaData.isOriginal(), metaData.getCodeVersion().orElse(null), metaData.getDataVersion().orElse(null), metaData.getCountry().orElse(null), metaData.getShardName().orElse(null), atlasTags);
        }
        builder.setMetaData(metaData);
        atlas.nodes().forEach(node -> builder.addNode(node.getIdentifier(), node.getLocation(), node.getTags()));
        atlas.edges().forEach(edge -> builder.addEdge(edge.getIdentifier(), edge.asPolyLine(), edge.getTags()));
        atlas.areas().forEach(area -> builder.addArea(area.getIdentifier(), area.asPolygon(), area.getTags()));
        atlas.lines().forEach(line -> builder.addLine(line.getIdentifier(), line.asPolyLine(), line.getTags()));
        atlas.points().forEach(point -> builder.addPoint(point.getIdentifier(), point.getLocation(), point.getTags()));
        atlas.relationsLowerOrderFirst().forEach(relation -> this.addRelation(builder, (Relation)relation));
        return (PackedAtlas)builder.get();
    }

    public PackedAtlasCloner withAdditionalMetaDataTags(Map<String, String> additionalMetaDataTags) {
        this.additionalMetaDataTags = Optional.ofNullable(additionalMetaDataTags);
        return this;
    }

    private void addRelation(PackedAtlasBuilder builder, Relation relation) {
        RelationBean bean = new RelationBean();
        relation.members().forEach(member -> bean.addItem(member.getEntity().getIdentifier(), member.getRole(), member.getEntity().getType()));
        builder.addRelation(relation.getIdentifier(), relation.osmRelationIdentifier(), bean, relation.getTags());
    }
}

