/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.packed;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Longitude;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.AbstractAtlas;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.AtlasMetaData;
import org.openstreetmap.atlas.geography.atlas.builder.AtlasSize;
import org.openstreetmap.atlas.geography.atlas.exception.AtlasIntegrityException;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.geography.atlas.items.RelationMemberList;
import org.openstreetmap.atlas.geography.atlas.packed.PackedArea;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlasCloner;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlasSerializer;
import org.openstreetmap.atlas.geography.atlas.packed.PackedEdge;
import org.openstreetmap.atlas.geography.atlas.packed.PackedLine;
import org.openstreetmap.atlas.geography.atlas.packed.PackedNode;
import org.openstreetmap.atlas.geography.atlas.packed.PackedPoint;
import org.openstreetmap.atlas.geography.atlas.packed.PackedRelation;
import org.openstreetmap.atlas.geography.atlas.packed.PackedTagStore;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.utilities.arrays.ByteArrayOfArrays;
import org.openstreetmap.atlas.utilities.arrays.IntegerArrayOfArrays;
import org.openstreetmap.atlas.utilities.arrays.LongArray;
import org.openstreetmap.atlas.utilities.arrays.LongArrayOfArrays;
import org.openstreetmap.atlas.utilities.arrays.PolyLineArray;
import org.openstreetmap.atlas.utilities.arrays.PolygonArray;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.MultiIterable;
import org.openstreetmap.atlas.utilities.compression.IntegerDictionary;
import org.openstreetmap.atlas.utilities.maps.LongToLongMap;
import org.openstreetmap.atlas.utilities.maps.LongToLongMultiMap;
import org.openstreetmap.atlas.utilities.scalars.Distance;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PackedAtlas
extends AbstractAtlas {
    private static final long serialVersionUID = -7582554057580336684L;
    private static final Logger logger = LoggerFactory.getLogger(PackedAtlas.class);
    protected static final String FIELD_PREFIX = "FIELD_";
    protected static final String FIELD_BOUNDS = "bounds";
    protected static final String FIELD_LOGGER = "logger";
    protected static final String FIELD_SERIAL_VERSION_UID = "serialVersionUID";
    protected static final String FIELD_SERIALIZER = "serializer";
    protected static final String FIELD_SAVE_SERIALIZATION_FORMAT = "saveSerializationFormat";
    protected static final String FIELD_LOAD_SERIALIZATION_FORMAT = "loadSerializationFormat";
    protected static final String FIELD_META_DATA = "metaData";
    protected static final String FIELD_DICTIONARY = "dictionary";
    protected static final String FIELD_EDGE_IDENTIFIERS = "edgeIdentifiers";
    protected static final String FIELD_NODE_IDENTIFIERS = "nodeIdentifiers";
    protected static final String FIELD_AREA_IDENTIFIERS = "areaIdentifiers";
    protected static final String FIELD_LINE_IDENTIFIERS = "lineIdentifiers";
    protected static final String FIELD_POINT_IDENTIFIERS = "pointIdentifiers";
    protected static final String FIELD_RELATION_IDENTIFIERS = "relationIdentifiers";
    protected static final String FIELD_EDGE_IDENTIFIER_TO_EDGE_ARRAY_INDEX = "edgeIdentifierToEdgeArrayIndex";
    protected static final String FIELD_NODE_IDENTIFIER_TO_NODE_ARRAY_INDEX = "nodeIdentifierToNodeArrayIndex";
    protected static final String FIELD_AREA_IDENTIFIER_TO_AREA_ARRAY_INDEX = "areaIdentifierToAreaArrayIndex";
    protected static final String FIELD_LINE_IDENTIFIER_TO_LINE_ARRAY_INDEX = "lineIdentifierToLineArrayIndex";
    protected static final String FIELD_POINT_IDENTIFIER_TO_POINT_ARRAY_INDEX = "pointIdentifierToPointArrayIndex";
    protected static final String FIELD_RELATION_IDENTIFIER_TO_RELATION_ARRAY_INDEX = "relationIdentifierToRelationArrayIndex";
    protected static final String FIELD_NODE_LOCATIONS = "nodeLocations";
    protected static final String FIELD_NODE_IN_EDGES_INDICES = "nodeInEdgesIndices";
    protected static final String FIELD_NODE_OUT_EDGES_INDICES = "nodeOutEdgesIndices";
    protected static final String FIELD_NODE_TAGS = "nodeTags";
    protected static final String FIELD_NODE_INDEX_TO_RELATION_INDICES = "nodeIndexToRelationIndices";
    protected static final String FIELD_EDGE_START_NODE_INDEX = "edgeStartNodeIndex";
    protected static final String FIELD_EDGE_END_NODE_INDEX = "edgeEndNodeIndex";
    protected static final String FIELD_EDGE_POLY_LINES = "edgePolyLines";
    protected static final String FIELD_EDGE_TAGS = "edgeTags";
    protected static final String FIELD_EDGE_INDEX_TO_RELATION_INDICES = "edgeIndexToRelationIndices";
    protected static final String FIELD_AREA_POLYGONS = "areaPolygons";
    protected static final String FIELD_AREA_TAGS = "areaTags";
    protected static final String FIELD_AREA_INDEX_TO_RELATION_INDICES = "areaIndexToRelationIndices";
    protected static final String FIELD_LINE_POLYLINES = "linePolyLines";
    protected static final String FIELD_LINE_TAGS = "lineTags";
    protected static final String FIELD_LINE_INDEX_TO_RELATION_INDICES = "lineIndexToRelationIndices";
    protected static final String FIELD_POINT_LOCATIONS = "pointLocations";
    protected static final String FIELD_POINT_TAGS = "pointTags";
    protected static final String FIELD_POINT_INDEX_TO_RELATION_INDICES = "pointIndexToRelationIndices";
    protected static final String FIELD_RELATION_MEMBERS_INDICES = "relationMemberIndices";
    protected static final String FIELD_RELATION_MEMBER_TYPES = "relationMemberTypes";
    protected static final String FIELD_RELATION_MEMBER_ROLES = "relationMemberRoles";
    protected static final String FIELD_RELATION_TAGS = "relationTags";
    protected static final String FIELD_RELATION_INDEX_TO_RELATION_INDICES = "relationIndexToRelationIndices";
    protected static final String FIELD_RELATION_OSM_IDENTIFIER_TO_RELATION_IDENTIFIERS = "relationOsmIdentifierToRelationIdentifiers";
    protected static final String FIELD_RELATION_OSM_IDENTIFIERS = "relationOsmIdentifiers";
    private transient PackedAtlasSerializer serializer;
    private AtlasSerializationFormat saveSerializationFormat = AtlasSerializationFormat.JAVA;
    private AtlasSerializationFormat loadSerializationFormat = AtlasSerializationFormat.JAVA;
    private AtlasMetaData metaData = new AtlasMetaData();
    private final IntegerDictionary<String> dictionary;
    private final LongArray edgeIdentifiers;
    private final LongArray nodeIdentifiers;
    private final LongArray areaIdentifiers;
    private final LongArray lineIdentifiers;
    private final LongArray pointIdentifiers;
    private final LongArray relationIdentifiers;
    private final LongToLongMap edgeIdentifierToEdgeArrayIndex;
    private final LongToLongMap nodeIdentifierToNodeArrayIndex;
    private final LongToLongMap areaIdentifierToAreaArrayIndex;
    private final LongToLongMap lineIdentifierToLineArrayIndex;
    private final LongToLongMap pointIdentifierToPointArrayIndex;
    private final LongToLongMap relationIdentifierToRelationArrayIndex;
    private final LongArray nodeLocations;
    private final LongArrayOfArrays nodeInEdgesIndices;
    private final LongArrayOfArrays nodeOutEdgesIndices;
    private final PackedTagStore nodeTags;
    private final LongToLongMultiMap nodeIndexToRelationIndices;
    private final LongArray edgeStartNodeIndex;
    private final LongArray edgeEndNodeIndex;
    private final PolyLineArray edgePolyLines;
    private final PackedTagStore edgeTags;
    private final LongToLongMultiMap edgeIndexToRelationIndices;
    private final PolygonArray areaPolygons;
    private final PackedTagStore areaTags;
    private final LongToLongMultiMap areaIndexToRelationIndices;
    private final PolyLineArray linePolyLines;
    private final PackedTagStore lineTags;
    private final LongToLongMultiMap lineIndexToRelationIndices;
    private final LongArray pointLocations;
    private final PackedTagStore pointTags;
    private final LongToLongMultiMap pointIndexToRelationIndices;
    private final LongArrayOfArrays relationMemberIndices;
    private final ByteArrayOfArrays relationMemberTypes;
    private final IntegerArrayOfArrays relationMemberRoles;
    private final PackedTagStore relationTags;
    private final LongToLongMultiMap relationIndexToRelationIndices;
    private final LongToLongMultiMap relationOsmIdentifierToRelationIdentifiers;
    private final LongArray relationOsmIdentifiers;
    private Rectangle bounds;

    public static PackedAtlas cloneFrom(Atlas other) {
        return new PackedAtlasCloner().cloneFrom(other);
    }

    public static PackedAtlas load(Resource resource) {
        PackedAtlas result = PackedAtlasSerializer.load(resource);
        result.setName(resource.getName());
        return result;
    }

    protected PackedAtlas() {
        this.metaData = null;
        this.dictionary = null;
        this.edgeIdentifiers = null;
        this.nodeIdentifiers = null;
        this.areaIdentifiers = null;
        this.lineIdentifiers = null;
        this.pointIdentifiers = null;
        this.relationIdentifiers = null;
        this.edgeIdentifierToEdgeArrayIndex = null;
        this.nodeIdentifierToNodeArrayIndex = null;
        this.areaIdentifierToAreaArrayIndex = null;
        this.lineIdentifierToLineArrayIndex = null;
        this.pointIdentifierToPointArrayIndex = null;
        this.relationIdentifierToRelationArrayIndex = null;
        this.nodeLocations = null;
        this.nodeInEdgesIndices = null;
        this.nodeOutEdgesIndices = null;
        this.nodeTags = null;
        this.nodeIndexToRelationIndices = null;
        this.edgeStartNodeIndex = null;
        this.edgeEndNodeIndex = null;
        this.edgePolyLines = null;
        this.edgeTags = null;
        this.edgeIndexToRelationIndices = null;
        this.areaPolygons = null;
        this.areaTags = null;
        this.areaIndexToRelationIndices = null;
        this.linePolyLines = null;
        this.lineTags = null;
        this.lineIndexToRelationIndices = null;
        this.pointLocations = null;
        this.pointTags = null;
        this.pointIndexToRelationIndices = null;
        this.relationMemberIndices = null;
        this.relationMemberTypes = null;
        this.relationMemberRoles = null;
        this.relationTags = null;
        this.relationIndexToRelationIndices = null;
        this.relationOsmIdentifierToRelationIdentifiers = null;
        this.relationOsmIdentifiers = null;
    }

    protected PackedAtlas(AtlasSize estimates) {
        long edgeNumberEstimate = estimates.getEdgeNumber();
        long nodeNumberEstimate = estimates.getNodeNumber();
        long areaNumberEstimate = estimates.getAreaNumber();
        long lineNumberEstimate = estimates.getLineNumber();
        long pointNumberEstimate = estimates.getPointNumber();
        long relationNumberEstimate = estimates.getRelationNumber();
        int subArraySize = Integer.MAX_VALUE;
        long maximumSize = Long.MAX_VALUE;
        int edgeMemoryBlockSize = (int)Math.max(1024L, edgeNumberEstimate % Integer.MAX_VALUE);
        int nodeMemoryBlockSize = (int)Math.max(1024L, nodeNumberEstimate % Integer.MAX_VALUE);
        int areaMemoryBlockSize = (int)Math.max(1024L, areaNumberEstimate % Integer.MAX_VALUE);
        int lineMemoryBlockSize = (int)Math.max(1024L, lineNumberEstimate % Integer.MAX_VALUE);
        int pointMemoryBlockSize = (int)Math.max(1024L, pointNumberEstimate % Integer.MAX_VALUE);
        int relationMemoryBlockSize = (int)Math.max(1024L, relationNumberEstimate % Integer.MAX_VALUE);
        int edgeHashSize = (int)Math.max(Math.min(edgeNumberEstimate / 10L, Integer.MAX_VALUE), 1L);
        int nodeHashSize = (int)Math.max(Math.min(nodeNumberEstimate / 10L, Integer.MAX_VALUE), 1L);
        int areaHashSize = (int)Math.max(Math.min(areaNumberEstimate / 10L, Integer.MAX_VALUE), 1L);
        int lineHashSize = (int)Math.max(Math.min(lineNumberEstimate / 10L, Integer.MAX_VALUE), 1L);
        int pointHashSize = (int)Math.max(Math.min(pointNumberEstimate / 10L, Integer.MAX_VALUE), 1L);
        int relationHashSize = (int)Math.max(Math.min(relationNumberEstimate / 10L, Integer.MAX_VALUE), 1L);
        this.dictionary = new IntegerDictionary();
        this.edgeIdentifiers = new LongArray(Long.MAX_VALUE, edgeMemoryBlockSize, Integer.MAX_VALUE);
        this.nodeIdentifiers = new LongArray(Long.MAX_VALUE, nodeMemoryBlockSize, Integer.MAX_VALUE);
        this.areaIdentifiers = new LongArray(Long.MAX_VALUE, areaMemoryBlockSize, Integer.MAX_VALUE);
        this.lineIdentifiers = new LongArray(Long.MAX_VALUE, lineMemoryBlockSize, Integer.MAX_VALUE);
        this.pointIdentifiers = new LongArray(Long.MAX_VALUE, pointMemoryBlockSize, Integer.MAX_VALUE);
        this.relationIdentifiers = new LongArray(Long.MAX_VALUE, relationMemoryBlockSize, Integer.MAX_VALUE);
        this.edgeIdentifierToEdgeArrayIndex = new LongToLongMap("PackedAtlas - edgeIdentifierToEdgeArrayIndex", Long.MAX_VALUE, edgeHashSize, edgeMemoryBlockSize, Integer.MAX_VALUE, edgeMemoryBlockSize, Integer.MAX_VALUE);
        this.nodeIdentifierToNodeArrayIndex = new LongToLongMap("PackedAtlas - nodeIdentifierToNodeArrayIndex", Long.MAX_VALUE, nodeHashSize, nodeMemoryBlockSize, Integer.MAX_VALUE, nodeMemoryBlockSize, Integer.MAX_VALUE);
        this.areaIdentifierToAreaArrayIndex = new LongToLongMap("PackedAtlas - areaIdentifierToAreaArrayIndex", Long.MAX_VALUE, areaHashSize, areaMemoryBlockSize, Integer.MAX_VALUE, areaMemoryBlockSize, Integer.MAX_VALUE);
        this.lineIdentifierToLineArrayIndex = new LongToLongMap("PackedAtlas - lineIdentifierToLineArrayIndex", Long.MAX_VALUE, lineHashSize, lineMemoryBlockSize, Integer.MAX_VALUE, lineMemoryBlockSize, Integer.MAX_VALUE);
        this.pointIdentifierToPointArrayIndex = new LongToLongMap("PackedAtlas - pointIdentifierToPointArrayIndex", Long.MAX_VALUE, pointHashSize, pointMemoryBlockSize, Integer.MAX_VALUE, pointMemoryBlockSize, Integer.MAX_VALUE);
        this.relationIdentifierToRelationArrayIndex = new LongToLongMap("PackedAtlas - relationIdentifierToRelationArrayIndex", Long.MAX_VALUE, relationHashSize, relationMemoryBlockSize, Integer.MAX_VALUE, relationMemoryBlockSize, Integer.MAX_VALUE);
        this.nodeInEdgesIndices = new LongArrayOfArrays(Integer.MAX_VALUE, nodeMemoryBlockSize, Integer.MAX_VALUE);
        this.nodeOutEdgesIndices = new LongArrayOfArrays(Integer.MAX_VALUE, nodeMemoryBlockSize, Integer.MAX_VALUE);
        this.nodeLocations = new LongArray(Long.MAX_VALUE, nodeMemoryBlockSize, Integer.MAX_VALUE);
        this.nodeTags = new PackedTagStore(Long.MAX_VALUE, nodeMemoryBlockSize, Integer.MAX_VALUE, this.dictionary());
        this.nodeIndexToRelationIndices = new LongToLongMultiMap("PackedAtlas - nodeIndexToRelationIndices", Long.MAX_VALUE, nodeHashSize, nodeMemoryBlockSize, Integer.MAX_VALUE, nodeMemoryBlockSize, nodeHashSize);
        this.edgeStartNodeIndex = new LongArray(Long.MAX_VALUE, edgeMemoryBlockSize, Integer.MAX_VALUE);
        this.edgeEndNodeIndex = new LongArray(Long.MAX_VALUE, edgeMemoryBlockSize, Integer.MAX_VALUE);
        this.edgePolyLines = new PolyLineArray(Long.MAX_VALUE, edgeMemoryBlockSize, Integer.MAX_VALUE);
        this.edgeTags = new PackedTagStore(Long.MAX_VALUE, edgeMemoryBlockSize, Integer.MAX_VALUE, this.dictionary());
        this.edgeIndexToRelationIndices = new LongToLongMultiMap("PackedAtlas - edgeIndexToRelationIndices", Long.MAX_VALUE, edgeHashSize, edgeMemoryBlockSize, Integer.MAX_VALUE, edgeMemoryBlockSize, edgeHashSize);
        this.areaPolygons = new PolygonArray(Long.MAX_VALUE, areaMemoryBlockSize, Integer.MAX_VALUE);
        this.areaTags = new PackedTagStore(Long.MAX_VALUE, areaMemoryBlockSize, Integer.MAX_VALUE, this.dictionary());
        this.areaIndexToRelationIndices = new LongToLongMultiMap("PackedAtlas - areaIndexToRelationIndices", Long.MAX_VALUE, areaHashSize, areaMemoryBlockSize, Integer.MAX_VALUE, areaMemoryBlockSize, areaHashSize);
        this.linePolyLines = new PolyLineArray(Long.MAX_VALUE, lineMemoryBlockSize, Integer.MAX_VALUE);
        this.lineTags = new PackedTagStore(Long.MAX_VALUE, lineMemoryBlockSize, Integer.MAX_VALUE, this.dictionary());
        this.lineIndexToRelationIndices = new LongToLongMultiMap("PackedAtlas - lineIndexToRelationIndices", Long.MAX_VALUE, lineHashSize, lineMemoryBlockSize, Integer.MAX_VALUE, lineMemoryBlockSize, lineHashSize);
        this.pointLocations = new LongArray(Long.MAX_VALUE, pointMemoryBlockSize, Integer.MAX_VALUE);
        this.pointTags = new PackedTagStore(Long.MAX_VALUE, pointMemoryBlockSize, Integer.MAX_VALUE, this.dictionary());
        this.pointIndexToRelationIndices = new LongToLongMultiMap("PackedAtlas - pointIndexToRelationIndices", Long.MAX_VALUE, pointHashSize, pointMemoryBlockSize, Integer.MAX_VALUE, pointMemoryBlockSize, pointHashSize);
        this.relationMemberIndices = new LongArrayOfArrays(Long.MAX_VALUE, relationMemoryBlockSize, Integer.MAX_VALUE);
        this.relationMemberTypes = new ByteArrayOfArrays(Long.MAX_VALUE, relationMemoryBlockSize, Integer.MAX_VALUE);
        this.relationMemberRoles = new IntegerArrayOfArrays(Long.MAX_VALUE, relationMemoryBlockSize, Integer.MAX_VALUE);
        this.relationTags = new PackedTagStore(Long.MAX_VALUE, relationMemoryBlockSize, Integer.MAX_VALUE, this.dictionary());
        this.relationIndexToRelationIndices = new LongToLongMultiMap("PackedAtlas - relationIndexToRelationIndices", Long.MAX_VALUE, relationHashSize, relationMemoryBlockSize, Integer.MAX_VALUE, relationMemoryBlockSize, relationHashSize);
        this.relationOsmIdentifierToRelationIdentifiers = new LongToLongMultiMap("PackedAtlas - relationOsmIdentifierToRelationIdentifier", Long.MAX_VALUE, relationHashSize, relationMemoryBlockSize, Integer.MAX_VALUE, relationMemoryBlockSize, Integer.MAX_VALUE);
        this.relationOsmIdentifiers = new LongArray(Long.MAX_VALUE, relationMemoryBlockSize, Integer.MAX_VALUE);
        this.edgeIdentifiers.setName("PackedAtlas - edgeIdentifiers");
        this.edgeStartNodeIndex.setName("PackedAtlas - edgeStartNodeIndex");
        this.edgeEndNodeIndex.setName("PackedAtlas - edgeEndNodeIndex");
        this.edgePolyLines.setName("PackedAtlas - edgePolyLines");
        this.nodeIdentifiers.setName("PackedAtlas - nodeIdentifiers");
        this.nodeInEdgesIndices.setName("PackedAtlas - nodeInEdgesIndices");
        this.nodeOutEdgesIndices.setName("PackedAtlas - nodeOutEdgesIndices");
        this.nodeLocations.setName("PackedAtlas - nodeLocations");
        this.areaIdentifiers.setName("PackedAtlas - areaIdentifiers");
        this.areaPolygons.setName("PackedAtlas - areaPolygons");
        this.lineIdentifiers.setName("PackedAtlas - lineIdentifiers");
        this.linePolyLines.setName("PackedAtlas - linePolyLines");
        this.pointIdentifiers.setName("PackedAtlas - pointIdentifiers");
        this.pointLocations.setName("PackedAtlas - pointLocations");
        this.relationIdentifiers.setName("PackedAtlas - relationIdentifiers");
        this.relationMemberIndices.setName("PackedAtlas - relationMemberIndices");
        this.relationMemberTypes.setName("PackedAtlas - relationMemberTypes");
        this.relationMemberRoles.setName("PackedAtlas - relationMemberRoles");
        this.relationOsmIdentifiers.setName("PackedAtlas - relationOsmIdentifiers");
    }

    @Override
    public Area area(long identifier) {
        if (this.areaIdentifierToAreaArrayIndex().containsKey(identifier)) {
            return new PackedArea(this, (Long)this.areaIdentifierToAreaArrayIndex().get(identifier));
        }
        return null;
    }

    @Override
    public Iterable<Area> areas() {
        return () -> new Iterator<Area>(){
            private long index = 0L;

            @Override
            public boolean hasNext() {
                return this.index < PackedAtlas.this.areaIdentifiers().size();
            }

            @Override
            public Area next() {
                return new PackedArea(PackedAtlas.this, this.index++);
            }
        };
    }

    @Override
    public Rectangle bounds() {
        if (this.bounds == null) {
            Iterable<AtlasEntity> boundedEntities = Iterables.filter(this, entity -> entity.bounds() != null);
            this.bounds = Rectangle.forLocated(boundedEntities);
        }
        return this.bounds;
    }

    @Override
    public Edge edge(long identifier) {
        if (this.edgeIdentifierToEdgeArrayIndex().containsKey(identifier)) {
            return new PackedEdge(this, (Long)this.edgeIdentifierToEdgeArrayIndex().get(identifier));
        }
        return null;
    }

    @Override
    public Iterable<Edge> edges() {
        return () -> new Iterator<Edge>(){
            private long index = 0L;

            @Override
            public boolean hasNext() {
                return this.index < PackedAtlas.this.edgeIdentifiers().size();
            }

            @Override
            public Edge next() {
                return new PackedEdge(PackedAtlas.this, this.index++);
            }
        };
    }

    public AtlasSerializationFormat getSaveSerializationFormat() {
        return this.saveSerializationFormat;
    }

    @Override
    public Line line(long identifier) {
        if (this.lineIdentifierToLineArrayIndex().containsKey(identifier)) {
            return new PackedLine(this, (Long)this.lineIdentifierToLineArrayIndex().get(identifier));
        }
        return null;
    }

    @Override
    public Iterable<Line> lines() {
        return () -> new Iterator<Line>(){
            private long index = 0L;

            @Override
            public boolean hasNext() {
                return this.index < PackedAtlas.this.lineIdentifiers().size();
            }

            @Override
            public Line next() {
                return new PackedLine(PackedAtlas.this, this.index++);
            }
        };
    }

    @Override
    public AtlasMetaData metaData() {
        if (this.metaData == null) {
            this.serializer.deserializeIfNeeded(FIELD_META_DATA);
        }
        return this.metaData;
    }

    @Override
    public Node node(long identifier) {
        if (this.nodeIdentifierToNodeArrayIndex().containsKey(identifier)) {
            return new PackedNode(this, (Long)this.nodeIdentifierToNodeArrayIndex().get(identifier));
        }
        return null;
    }

    @Override
    public Iterable<Node> nodes() {
        return () -> new Iterator<Node>(){
            private long index = 0L;

            @Override
            public boolean hasNext() {
                return this.index < PackedAtlas.this.nodeIdentifiers().size();
            }

            @Override
            public Node next() {
                return new PackedNode(PackedAtlas.this, this.index++);
            }
        };
    }

    @Override
    public long numberOfAreas() {
        return this.areaIdentifiers().size();
    }

    @Override
    public long numberOfEdges() {
        return this.edgeIdentifiers().size();
    }

    @Override
    public long numberOfLines() {
        return this.lineIdentifiers().size();
    }

    @Override
    public long numberOfNodes() {
        return this.nodeIdentifiers().size();
    }

    @Override
    public long numberOfPoints() {
        return this.pointIdentifiers().size();
    }

    @Override
    public long numberOfRelations() {
        return this.relationIdentifiers().size();
    }

    @Override
    public Point point(long identifier) {
        if (this.pointIdentifierToPointArrayIndex().containsKey(identifier)) {
            return new PackedPoint(this, (Long)this.pointIdentifierToPointArrayIndex().get(identifier));
        }
        return null;
    }

    @Override
    public Iterable<Point> points() {
        return () -> new Iterator<Point>(){
            private long index = 0L;

            @Override
            public boolean hasNext() {
                return this.index < PackedAtlas.this.pointIdentifiers().size();
            }

            @Override
            public Point next() {
                return new PackedPoint(PackedAtlas.this, this.index++);
            }
        };
    }

    @Override
    public Relation relation(long identifier) {
        if (this.relationIdentifierToRelationArrayIndex().containsKey(identifier)) {
            return new PackedRelation(this, (Long)this.relationIdentifierToRelationArrayIndex().get(identifier));
        }
        return null;
    }

    @Override
    public Iterable<Relation> relations() {
        return () -> new Iterator<Relation>(){
            private long index = 0L;

            @Override
            public boolean hasNext() {
                return this.index < PackedAtlas.this.relationIdentifiers().size();
            }

            @Override
            public Relation next() {
                return new PackedRelation(PackedAtlas.this, this.index++);
            }
        };
    }

    @Override
    public void save(WritableResource writableResource) {
        new PackedAtlasSerializer(this, writableResource).save();
    }

    public void setSaveSerializationFormat(AtlasSerializationFormat format) {
        this.saveSerializationFormat = format;
    }

    public void trim() {
        logger.info("Trimming Atlas {} to save on space.", (Object)this.getName());
        Time start = Time.now();
        this.edgeIdentifiers.trim();
        this.nodeIdentifiers.trim();
        this.areaIdentifiers.trim();
        this.lineIdentifiers.trim();
        this.pointIdentifiers.trim();
        this.relationIdentifiers.trim();
        this.edgeIdentifierToEdgeArrayIndex.trim();
        this.nodeIdentifierToNodeArrayIndex.trim();
        this.areaIdentifierToAreaArrayIndex.trim();
        this.lineIdentifierToLineArrayIndex.trim();
        this.pointIdentifierToPointArrayIndex.trim();
        this.relationIdentifierToRelationArrayIndex.trim();
        this.nodeLocations.trim();
        this.nodeInEdgesIndices.trim();
        this.nodeOutEdgesIndices.trim();
        this.nodeTags.trim();
        this.nodeIndexToRelationIndices.trim();
        this.edgeStartNodeIndex.trim();
        this.edgeEndNodeIndex.trim();
        this.edgePolyLines.trim();
        this.edgeTags.trim();
        this.edgeIndexToRelationIndices.trim();
        this.areaPolygons.trim();
        this.areaTags.trim();
        this.areaIndexToRelationIndices.trim();
        this.linePolyLines.trim();
        this.lineTags.trim();
        this.lineIndexToRelationIndices.trim();
        this.pointLocations.trim();
        this.pointTags.trim();
        this.pointIndexToRelationIndices.trim();
        this.relationMemberIndices.trim();
        this.relationMemberTypes.trim();
        this.relationMemberRoles.trim();
        this.relationTags.trim();
        this.relationIndexToRelationIndices.trim();
        this.relationOsmIdentifierToRelationIdentifiers.trim();
        this.relationOsmIdentifiers.trim();
        logger.info("Trimmed Atlas {} in {}.", (Object)this.getName(), (Object)start.elapsedSince());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addArea(long areaIdentifier, Polygon polygon, Map<String, String> tags) {
        LongArray longArray = this.areaIdentifiers;
        synchronized (longArray) {
            if (this.areaIdentifierToAreaArrayIndex.containsKey(areaIdentifier)) {
                throw new AtlasIntegrityException("Area with identifier " + areaIdentifier + " already exists.");
            }
            long index = this.areaIdentifiers.size();
            this.areaIdentifiers.add(areaIdentifier);
            this.areaIdentifierToAreaArrayIndex.put(areaIdentifier, index);
            this.areaPolygons.add(polygon);
            this.getAsNewAreaSpatialIndex().add(new PackedArea(this, index));
            for (String key : tags.keySet()) {
                String value = tags.get(key);
                this.areaTags.add(index, key, value);
            }
            if (tags.keySet().isEmpty()) {
                this.areaTags.add(index, null, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addEdge(long edgeIdentifier, long startNodeIdentifier, long endNodeIdentifier, PolyLine polyline, Map<String, String> tags) {
        LongArray longArray = this.edgeIdentifiers;
        synchronized (longArray) {
            if (this.edgeIdentifierToEdgeArrayIndex.containsKey(edgeIdentifier)) {
                throw new AtlasIntegrityException("Edge with identifier " + edgeIdentifier + " already exists.");
            }
            long index = this.edgeIdentifiers.size();
            this.edgeIdentifiers.add(edgeIdentifier);
            this.edgeIdentifierToEdgeArrayIndex.put(edgeIdentifier, index);
            this.edgePolyLines.add(polyline);
            long startNodeIndex = (Long)this.nodeIdentifierToNodeArrayIndex.get(startNodeIdentifier);
            this.edgeStartNodeIndex.add(startNodeIndex);
            long endNodeIndex = (Long)this.nodeIdentifierToNodeArrayIndex.get(endNodeIdentifier);
            this.edgeEndNodeIndex.add(endNodeIndex);
            this.updateNodeEdgesReference(endNodeIndex, this.nodeInEdgesIndices, index);
            this.updateNodeEdgesReference(startNodeIndex, this.nodeOutEdgesIndices, index);
            this.getAsNewEdgeSpatialIndex().add(new PackedEdge(this, index));
            for (String key : tags.keySet()) {
                String value = tags.get(key);
                this.edgeTags.add(index, key, value);
            }
            if (tags.keySet().isEmpty()) {
                this.edgeTags.add(index, null, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addLine(long lineIdentifier, PolyLine polyline, Map<String, String> tags) {
        LongArray longArray = this.lineIdentifiers;
        synchronized (longArray) {
            if (this.lineIdentifierToLineArrayIndex.containsKey(lineIdentifier)) {
                throw new AtlasIntegrityException("Line with identifier " + lineIdentifier + " already exists.");
            }
            long index = this.lineIdentifiers.size();
            this.lineIdentifiers.add(lineIdentifier);
            this.lineIdentifierToLineArrayIndex.put(lineIdentifier, index);
            this.linePolyLines.add(polyline);
            this.getAsNewLineSpatialIndex().add(new PackedLine(this, index));
            for (String key : tags.keySet()) {
                String value = tags.get(key);
                this.lineTags.add(index, key, value);
            }
            if (tags.keySet().isEmpty()) {
                this.lineTags.add(index, null, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNode(long nodeIdentifier, Location location, Map<String, String> tags) {
        LongArray longArray = this.nodeIdentifiers;
        synchronized (longArray) {
            if (this.nodeIdentifierToNodeArrayIndex.containsKey(nodeIdentifier)) {
                throw new AtlasIntegrityException("Node with identifier " + nodeIdentifier + " already exists.");
            }
            long index = this.nodeIdentifiers.size();
            this.nodeIdentifiers.add(nodeIdentifier);
            this.nodeIdentifierToNodeArrayIndex.put(nodeIdentifier, index);
            this.nodeLocations.add(location.asConcatenation());
            this.nodeInEdgesIndices.add(new long[0]);
            this.nodeOutEdgesIndices.add(new long[0]);
            this.getAsNewNodeSpatialIndex().add(new PackedNode(this, index));
            for (String key : tags.keySet()) {
                String value = tags.get(key);
                this.nodeTags.add(index, key, value);
            }
            if (tags.keySet().isEmpty()) {
                this.nodeTags.add(index, null, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPoint(long pointIdentifier, Location location, Map<String, String> tags) {
        LongArray longArray = this.pointIdentifiers;
        synchronized (longArray) {
            if (this.pointIdentifierToPointArrayIndex.containsKey(pointIdentifier)) {
                throw new AtlasIntegrityException("Point with identifier " + pointIdentifier + " already exists.");
            }
            long index = this.pointIdentifiers.size();
            this.pointIdentifiers.add(pointIdentifier);
            this.pointIdentifierToPointArrayIndex.put(pointIdentifier, index);
            this.pointLocations.add(location.asConcatenation());
            this.getAsNewPointSpatialIndex().add(new PackedPoint(this, index));
            for (String key : tags.keySet()) {
                String value = tags.get(key);
                this.pointTags.add(index, key, value);
            }
            if (tags.keySet().isEmpty()) {
                this.pointTags.add(index, null, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRelation(long relationIdentifier, long relationOsmIdentifier, List<Long> identifiers, List<ItemType> types, List<String> roles, Map<String, String> tags) {
        if (identifiers.size() != types.size() || types.size() != roles.size()) {
            throw new AtlasIntegrityException("Different sizes for relation identifiers and types and roles.");
        }
        if (identifiers.isEmpty()) {
            throw new AtlasIntegrityException("Cannot add the relation {} with no members", relationIdentifier);
        }
        if (identifiers.stream().anyMatch(Objects::isNull)) {
            throw new AtlasIntegrityException("Cannot have a relation with null members.");
        }
        LongArray longArray = this.relationIdentifiers;
        synchronized (longArray) {
            if (this.relationIdentifierToRelationArrayIndex.containsKey(relationIdentifier)) {
                throw new AtlasIntegrityException("Relation with identifier " + relationIdentifier + " already exists.");
            }
            long index = this.relationIdentifiers.size();
            this.relationIdentifiers.add(relationIdentifier);
            this.relationIdentifierToRelationArrayIndex.put(relationIdentifier, index);
            this.relationOsmIdentifierToRelationIdentifiers.add(relationOsmIdentifier, relationIdentifier);
            this.relationOsmIdentifiers.add(relationOsmIdentifier);
            long[] memberIndices = new long[identifiers.size()];
            byte[] typeValues = new byte[types.size()];
            int[] roleValues = new int[roles.size()];
            block11: for (int i = 0; i < identifiers.size(); ++i) {
                ItemType type = types.get(i);
                typeValues[i] = (byte)type.getValue();
                roleValues[i] = this.dictionary.add(roles.get(i));
                Long memberIdentifier = identifiers.get(i);
                switch (type) {
                    case NODE: {
                        this.addRelationMember("Node", index, memberIdentifier, i, memberIndices, this.nodeIdentifierToNodeArrayIndex, this.nodeIndexToRelationIndices);
                        continue block11;
                    }
                    case EDGE: {
                        this.addRelationMember("Edge", index, memberIdentifier, i, memberIndices, this.edgeIdentifierToEdgeArrayIndex, this.edgeIndexToRelationIndices);
                        continue block11;
                    }
                    case AREA: {
                        this.addRelationMember("Area", index, memberIdentifier, i, memberIndices, this.areaIdentifierToAreaArrayIndex, this.areaIndexToRelationIndices);
                        continue block11;
                    }
                    case LINE: {
                        this.addRelationMember("Line", index, memberIdentifier, i, memberIndices, this.lineIdentifierToLineArrayIndex, this.lineIndexToRelationIndices);
                        continue block11;
                    }
                    case POINT: {
                        this.addRelationMember("Point", index, memberIdentifier, i, memberIndices, this.pointIdentifierToPointArrayIndex, this.pointIndexToRelationIndices);
                        continue block11;
                    }
                    case RELATION: {
                        this.addRelationMember("Relation", index, memberIdentifier, i, memberIndices, this.relationIdentifierToRelationArrayIndex, this.relationIndexToRelationIndices);
                        continue block11;
                    }
                    default: {
                        throw new CoreException("Cannot recognize ItemType {}", new Object[]{type});
                    }
                }
            }
            this.relationMemberTypes.add(typeValues);
            this.relationMemberIndices.add(memberIndices);
            this.relationMemberRoles.add(roleValues);
            for (String key : tags.keySet()) {
                String value = tags.get(key);
                this.relationTags.add(index, key, value);
            }
            if (tags.keySet().isEmpty()) {
                this.relationTags.add(index, null, null);
            }
        }
    }

    protected long areaIdentifier(long index) {
        return (Long)this.areaIdentifiers().get(index);
    }

    protected Polygon areaPolygon(long index) {
        return (Polygon)this.areaPolygons().get(index);
    }

    protected Set<Relation> areaRelations(long index) {
        return this.itemRelations((long[])this.areaIndexToRelationIndices().get(index));
    }

    protected Map<String, String> areaTags(long index) {
        return this.areaTags().keyValuePairs(index);
    }

    protected Node edgeEndNode(long index) {
        return new PackedNode(this, (Long)this.edgeEndNodeIndex().get(index));
    }

    protected long edgeIdentifier(long index) {
        return (Long)this.edgeIdentifiers().get(index);
    }

    protected PolyLine edgePolyLine(long index) {
        return (PolyLine)this.edgePolyLines().get(index);
    }

    protected Set<Relation> edgeRelations(long index) {
        return this.itemRelations((long[])this.edgeIndexToRelationIndices().get(index));
    }

    protected Node edgeStartNode(long index) {
        return new PackedNode(this, (Long)this.edgeStartNodeIndex().get(index));
    }

    protected Map<String, String> edgeTags(long index) {
        return this.edgeTags().keyValuePairs(index);
    }

    protected AtlasSerializationFormat getLoadSerializationFormat() {
        return this.loadSerializationFormat;
    }

    protected Optional<PackedAtlasSerializer> getSerializer() {
        return Optional.ofNullable(this.serializer);
    }

    protected boolean isEmpty() {
        return this.nodeIdentifiers().isEmpty() && this.edgeIdentifiers().isEmpty() && this.areaIdentifiers().isEmpty() && this.lineIdentifiers().isEmpty() && this.pointIdentifiers().isEmpty() && this.relationIdentifiers().isEmpty();
    }

    protected long lineIdentifier(long index) {
        return (Long)this.lineIdentifiers().get(index);
    }

    protected PolyLine linePolyLine(long index) {
        return (PolyLine)this.linePolyLines().get(index);
    }

    protected Set<Relation> lineRelations(long index) {
        return this.itemRelations((long[])this.lineIndexToRelationIndices().get(index));
    }

    protected Map<String, String> lineTags(long index) {
        return this.lineTags().keyValuePairs(index);
    }

    protected long nodeIdentifier(long index) {
        return (Long)this.nodeIdentifiers().get(index);
    }

    protected Long nodeIdentifierForEnlargedLocation(Location location, Distance searchDistance, Distance toleranceDistance) {
        Rectangle bounds = location.bounds().expand(searchDistance);
        this.buildNodeSpatialIndexIfNecessary();
        TreeSet nodes = new TreeSet((node1, node2) -> {
            Distance distance1 = location.distanceTo(node1.getLocation());
            Distance distance2 = location.distanceTo(node2.getLocation());
            double difference = distance2.asMillimeters() - distance1.asMillimeters();
            if (difference > 0.0) {
                return 1;
            }
            if (difference < 0.0) {
                return -1;
            }
            return 0;
        });
        this.getNodeSpatialIndex().get(bounds).forEach(nodes::add);
        for (Node candidate : nodes) {
            Distance distance = location.distanceTo(candidate.getLocation());
            if (!distance.isLessThanOrEqualTo(toleranceDistance)) continue;
            return candidate.getIdentifier();
        }
        return null;
    }

    protected Long nodeIdentifierForLocation(Location location) {
        Iterator<Node> nodes;
        this.buildNodeSpatialIndexIfNecessary();
        Rectangle bounds = location.bounds();
        if (location.getLongitude().equals(Longitude.ANTIMERIDIAN_EAST) || location.getLongitude().equals(Longitude.ANTIMERIDIAN_WEST)) {
            Location locationAcrossAntiMeridian = new Location(location.getLatitude(), Longitude.dm7(-location.getLongitude().asDm7()));
            Rectangle boundsAcrossAntiMeridian = locationAcrossAntiMeridian.bounds();
            nodes = new MultiIterable(this.getNodeSpatialIndex().get(bounds), this.getNodeSpatialIndex().get(boundsAcrossAntiMeridian)).iterator();
        } else {
            nodes = this.getNodeSpatialIndex().get(bounds).iterator();
        }
        if (nodes.hasNext()) {
            return nodes.next().getIdentifier();
        }
        return null;
    }

    protected SortedSet<Edge> nodeInEdges(long index) {
        TreeSet<Edge> result = new TreeSet<Edge>();
        for (long edgeIndex : (long[])this.nodeInEdgesIndices().get(index)) {
            result.add(new PackedEdge(this, edgeIndex));
        }
        return result;
    }

    protected Location nodeLocation(long index) {
        return new Location((Long)this.nodeLocations().get(index));
    }

    protected SortedSet<Edge> nodeOutEdges(long index) {
        TreeSet<Edge> result = new TreeSet<Edge>();
        for (long edgeIndex : (long[])this.nodeOutEdgesIndices().get(index)) {
            result.add(new PackedEdge(this, edgeIndex));
        }
        return result;
    }

    protected Set<Relation> nodeRelations(long index) {
        return this.itemRelations((long[])this.nodeIndexToRelationIndices().get(index));
    }

    protected Map<String, String> nodeTags(long index) {
        return this.nodeTags().keyValuePairs(index);
    }

    protected long pointIdentifier(long index) {
        return (Long)this.pointIdentifiers().get(index);
    }

    protected Location pointLocation(long index) {
        return new Location((Long)this.pointLocations().get(index));
    }

    protected Set<Relation> pointRelations(long index) {
        return this.itemRelations((long[])this.pointIndexToRelationIndices().get(index));
    }

    protected Map<String, String> pointTags(long index) {
        return this.pointTags().keyValuePairs(index);
    }

    protected RelationMemberList relationAllKnownOsmMembers(long index) {
        ArrayList<RelationMember> result = new ArrayList<RelationMember>();
        for (long candidateIdentifier : (long[])this.relationOsmIdentifierToRelationIdentifiers().get(this.relationOsmIdentifier(index))) {
            long candidateIndex = (Long)this.relationIdentifierToRelationArrayIndex().get(candidateIdentifier);
            this.relationMembers(candidateIndex).forEach(relationMember -> result.add((RelationMember)relationMember));
        }
        return new RelationMemberList(result);
    }

    protected List<Relation> relationAllRelationsWithSameOsmIdentifier(long index) {
        ArrayList<Relation> result = new ArrayList<Relation>();
        for (long candidateIdentifier : (long[])this.relationOsmIdentifierToRelationIdentifiers().get(this.relationOsmIdentifier(index))) {
            long candidateIndex = (Long)this.relationIdentifierToRelationArrayIndex().get(candidateIdentifier);
            result.add(new PackedRelation(this, candidateIndex));
        }
        return result;
    }

    protected long relationIdentifier(long index) {
        return (Long)this.relationIdentifiers().get(index);
    }

    protected RelationMemberList relationMembers(long index) {
        TreeSet<RelationMember> result = new TreeSet<RelationMember>();
        int arrayIndex = 0;
        for (byte typeValue : (byte[])this.relationMemberTypes().get(index)) {
            AtlasEntity entity;
            ItemType type = ItemType.forValue(typeValue);
            long memberIndex = ((long[])this.relationMemberIndices().get(index))[arrayIndex];
            String role = this.dictionary().word(((int[])this.relationMemberRoles().get(index))[arrayIndex]);
            switch (type) {
                case NODE: {
                    entity = new PackedNode(this, memberIndex);
                    break;
                }
                case EDGE: {
                    entity = new PackedEdge(this, memberIndex);
                    break;
                }
                case AREA: {
                    entity = new PackedArea(this, memberIndex);
                    break;
                }
                case LINE: {
                    entity = new PackedLine(this, memberIndex);
                    break;
                }
                case POINT: {
                    entity = new PackedPoint(this, memberIndex);
                    break;
                }
                case RELATION: {
                    entity = new PackedRelation(this, memberIndex);
                    break;
                }
                default: {
                    throw new CoreException("Invalid member type {}", new Object[]{type});
                }
            }
            result.add(new RelationMember(role, entity, this.relationIdentifier(index)));
            ++arrayIndex;
        }
        return new RelationMemberList(result);
    }

    protected long relationOsmIdentifier(long index) {
        return (Long)this.relationOsmIdentifiers().get(index);
    }

    protected Set<Relation> relationRelations(long index) {
        return this.itemRelations((long[])this.relationIndexToRelationIndices().get(index));
    }

    protected Map<String, String> relationTags(long index) {
        return this.relationTags().keyValuePairs(index);
    }

    protected void setLoadSerializationFormat(AtlasSerializationFormat loadFormat) {
        this.loadSerializationFormat = loadFormat;
    }

    protected void setMetaData(AtlasMetaData metaData) {
        this.metaData = metaData;
    }

    @Override
    protected void setName(String name) {
        super.setName(name);
    }

    private void addRelationMember(String type, long relationIndex, Long memberIdentifier, int relationMemberListIndex, long[] relationMemberIndexArray, LongToLongMap memberIdentifierToArrayIndex, LongToLongMultiMap memberIndicesToRelationIndices) {
        if (!memberIdentifierToArrayIndex.containsKey(memberIdentifier)) {
            throw new AtlasIntegrityException("The {} {} does not exist for relation {}.", type, memberIdentifier, this.relationIdentifiers.get(relationIndex));
        }
        relationMemberIndexArray[relationMemberListIndex] = (Long)memberIdentifierToArrayIndex.get(memberIdentifier);
        memberIndicesToRelationIndices.add(relationMemberIndexArray[relationMemberListIndex], relationIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LongArray areaIdentifiers() {
        if (this.areaIdentifiers != null) return this.areaIdentifiers;
        String string = FIELD_AREA_IDENTIFIERS;
        synchronized (FIELD_AREA_IDENTIFIERS) {
            if (this.areaIdentifiers != null) return this.areaIdentifiers;
            this.serializer.deserializeIfNeeded(FIELD_AREA_IDENTIFIERS);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.areaIdentifiers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LongToLongMap areaIdentifierToAreaArrayIndex() {
        if (this.areaIdentifierToAreaArrayIndex != null) return this.areaIdentifierToAreaArrayIndex;
        String string = FIELD_AREA_IDENTIFIER_TO_AREA_ARRAY_INDEX;
        synchronized (FIELD_AREA_IDENTIFIER_TO_AREA_ARRAY_INDEX) {
            if (this.areaIdentifierToAreaArrayIndex != null) return this.areaIdentifierToAreaArrayIndex;
            this.serializer.deserializeIfNeeded(FIELD_AREA_IDENTIFIER_TO_AREA_ARRAY_INDEX);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.areaIdentifierToAreaArrayIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LongToLongMultiMap areaIndexToRelationIndices() {
        if (this.areaIndexToRelationIndices != null) return this.areaIndexToRelationIndices;
        String string = FIELD_AREA_INDEX_TO_RELATION_INDICES;
        synchronized (FIELD_AREA_INDEX_TO_RELATION_INDICES) {
            if (this.areaIndexToRelationIndices != null) return this.areaIndexToRelationIndices;
            this.serializer.deserializeIfNeeded(FIELD_AREA_INDEX_TO_RELATION_INDICES);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.areaIndexToRelationIndices;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PolygonArray areaPolygons() {
        if (this.areaPolygons != null) return this.areaPolygons;
        String string = FIELD_AREA_POLYGONS;
        synchronized (FIELD_AREA_POLYGONS) {
            if (this.areaPolygons != null) return this.areaPolygons;
            this.serializer.deserializeIfNeeded(FIELD_AREA_POLYGONS);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.areaPolygons;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private PackedTagStore areaTags() {
        if (this.areaTags == null) {
            String string = FIELD_AREA_TAGS;
            // MONITORENTER : "areaTags"
            if (this.areaTags == null) {
                this.serializer.deserializeIfNeeded(FIELD_AREA_TAGS);
            }
            // MONITOREXIT : string
        }
        this.areaTags.setDictionary(this.dictionary());
        return this.areaTags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IntegerDictionary<String> dictionary() {
        if (this.dictionary != null) return this.dictionary;
        String string = FIELD_DICTIONARY;
        synchronized (FIELD_DICTIONARY) {
            if (this.dictionary != null) return this.dictionary;
            this.serializer.deserializeIfNeeded(FIELD_DICTIONARY);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.dictionary;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LongArray edgeEndNodeIndex() {
        if (this.edgeEndNodeIndex != null) return this.edgeEndNodeIndex;
        String string = FIELD_EDGE_END_NODE_INDEX;
        synchronized (FIELD_EDGE_END_NODE_INDEX) {
            if (this.edgeEndNodeIndex != null) return this.edgeEndNodeIndex;
            this.serializer.deserializeIfNeeded(FIELD_EDGE_END_NODE_INDEX);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.edgeEndNodeIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LongArray edgeIdentifiers() {
        if (this.edgeIdentifiers != null) return this.edgeIdentifiers;
        String string = FIELD_EDGE_IDENTIFIERS;
        synchronized (FIELD_EDGE_IDENTIFIERS) {
            if (this.edgeIdentifiers != null) return this.edgeIdentifiers;
            this.serializer.deserializeIfNeeded(FIELD_EDGE_IDENTIFIERS);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.edgeIdentifiers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LongToLongMap edgeIdentifierToEdgeArrayIndex() {
        if (this.edgeIdentifierToEdgeArrayIndex != null) return this.edgeIdentifierToEdgeArrayIndex;
        String string = FIELD_EDGE_IDENTIFIER_TO_EDGE_ARRAY_INDEX;
        synchronized (FIELD_EDGE_IDENTIFIER_TO_EDGE_ARRAY_INDEX) {
            if (this.edgeIdentifierToEdgeArrayIndex != null) return this.edgeIdentifierToEdgeArrayIndex;
            this.serializer.deserializeIfNeeded(FIELD_EDGE_IDENTIFIER_TO_EDGE_ARRAY_INDEX);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.edgeIdentifierToEdgeArrayIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LongToLongMultiMap edgeIndexToRelationIndices() {
        if (this.edgeIndexToRelationIndices != null) return this.edgeIndexToRelationIndices;
        String string = FIELD_EDGE_INDEX_TO_RELATION_INDICES;
        synchronized (FIELD_EDGE_INDEX_TO_RELATION_INDICES) {
            if (this.edgeIndexToRelationIndices != null) return this.edgeIndexToRelationIndices;
            this.serializer.deserializeIfNeeded(FIELD_EDGE_INDEX_TO_RELATION_INDICES);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.edgeIndexToRelationIndices;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PolyLineArray edgePolyLines() {
        if (this.edgePolyLines != null) return this.edgePolyLines;
        String string = FIELD_EDGE_POLY_LINES;
        synchronized (FIELD_EDGE_POLY_LINES) {
            if (this.edgePolyLines != null) return this.edgePolyLines;
            this.serializer.deserializeIfNeeded(FIELD_EDGE_POLY_LINES);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.edgePolyLines;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LongArray edgeStartNodeIndex() {
        if (this.edgeStartNodeIndex != null) return this.edgeStartNodeIndex;
        String string = FIELD_EDGE_START_NODE_INDEX;
        synchronized (FIELD_EDGE_START_NODE_INDEX) {
            if (this.edgeStartNodeIndex != null) return this.edgeStartNodeIndex;
            this.serializer.deserializeIfNeeded(FIELD_EDGE_START_NODE_INDEX);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.edgeStartNodeIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private PackedTagStore edgeTags() {
        if (this.edgeTags == null) {
            String string = FIELD_EDGE_TAGS;
            // MONITORENTER : "edgeTags"
            if (this.edgeTags == null) {
                this.serializer.deserializeIfNeeded(FIELD_EDGE_TAGS);
            }
            // MONITOREXIT : string
        }
        this.edgeTags.setDictionary(this.dictionary());
        return this.edgeTags;
    }

    private Set<Relation> itemRelations(long[] relationIndices) {
        HashSet<Relation> result = new HashSet<Relation>();
        if (relationIndices == null) {
            return result;
        }
        for (long relationIndex : relationIndices) {
            result.add(new PackedRelation(this, relationIndex));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LongArray lineIdentifiers() {
        if (this.lineIdentifiers != null) return this.lineIdentifiers;
        String string = FIELD_LINE_IDENTIFIERS;
        synchronized (FIELD_LINE_IDENTIFIERS) {
            if (this.lineIdentifiers != null) return this.lineIdentifiers;
            this.serializer.deserializeIfNeeded(FIELD_LINE_IDENTIFIERS);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.lineIdentifiers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LongToLongMap lineIdentifierToLineArrayIndex() {
        if (this.lineIdentifierToLineArrayIndex != null) return this.lineIdentifierToLineArrayIndex;
        String string = FIELD_LINE_IDENTIFIER_TO_LINE_ARRAY_INDEX;
        synchronized (FIELD_LINE_IDENTIFIER_TO_LINE_ARRAY_INDEX) {
            if (this.lineIdentifierToLineArrayIndex != null) return this.lineIdentifierToLineArrayIndex;
            this.serializer.deserializeIfNeeded(FIELD_LINE_IDENTIFIER_TO_LINE_ARRAY_INDEX);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.lineIdentifierToLineArrayIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LongToLongMultiMap lineIndexToRelationIndices() {
        if (this.lineIndexToRelationIndices != null) return this.lineIndexToRelationIndices;
        String string = FIELD_LINE_INDEX_TO_RELATION_INDICES;
        synchronized (FIELD_LINE_INDEX_TO_RELATION_INDICES) {
            if (this.lineIndexToRelationIndices != null) return this.lineIndexToRelationIndices;
            this.serializer.deserializeIfNeeded(FIELD_LINE_INDEX_TO_RELATION_INDICES);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.lineIndexToRelationIndices;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PolyLineArray linePolyLines() {
        if (this.linePolyLines != null) return this.linePolyLines;
        String string = FIELD_LINE_POLYLINES;
        synchronized (FIELD_LINE_POLYLINES) {
            if (this.linePolyLines != null) return this.linePolyLines;
            this.serializer.deserializeIfNeeded(FIELD_LINE_POLYLINES);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.linePolyLines;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private PackedTagStore lineTags() {
        if (this.lineTags == null) {
            String string = FIELD_LINE_TAGS;
            // MONITORENTER : "lineTags"
            if (this.lineTags == null) {
                this.serializer.deserializeIfNeeded(FIELD_LINE_TAGS);
            }
            // MONITOREXIT : string
        }
        this.lineTags.setDictionary(this.dictionary());
        return this.lineTags;
    }

    private PackedTagStore newPackedTagStore(long maximumSize, int memoryBlockSize, int subArraySize) {
        return new PackedTagStore(maximumSize, memoryBlockSize, subArraySize, this.dictionary()){
            private static final long serialVersionUID = 5959934069025112665L;

            @Override
            public IntegerDictionary<String> keysDictionary() {
                return super.keysDictionary();
            }

            @Override
            public IntegerDictionary<String> valuesDictionary() {
                return super.valuesDictionary();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LongArray nodeIdentifiers() {
        if (this.nodeIdentifiers != null) return this.nodeIdentifiers;
        String string = FIELD_NODE_IDENTIFIERS;
        synchronized (FIELD_NODE_IDENTIFIERS) {
            if (this.nodeIdentifiers != null) return this.nodeIdentifiers;
            this.serializer.deserializeIfNeeded(FIELD_NODE_IDENTIFIERS);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.nodeIdentifiers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LongToLongMap nodeIdentifierToNodeArrayIndex() {
        if (this.nodeIdentifierToNodeArrayIndex != null) return this.nodeIdentifierToNodeArrayIndex;
        String string = FIELD_NODE_IDENTIFIER_TO_NODE_ARRAY_INDEX;
        synchronized (FIELD_NODE_IDENTIFIER_TO_NODE_ARRAY_INDEX) {
            if (this.nodeIdentifierToNodeArrayIndex != null) return this.nodeIdentifierToNodeArrayIndex;
            this.serializer.deserializeIfNeeded(FIELD_NODE_IDENTIFIER_TO_NODE_ARRAY_INDEX);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.nodeIdentifierToNodeArrayIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LongToLongMultiMap nodeIndexToRelationIndices() {
        if (this.nodeIndexToRelationIndices != null) return this.nodeIndexToRelationIndices;
        String string = FIELD_NODE_INDEX_TO_RELATION_INDICES;
        synchronized (FIELD_NODE_INDEX_TO_RELATION_INDICES) {
            if (this.nodeIndexToRelationIndices != null) return this.nodeIndexToRelationIndices;
            this.serializer.deserializeIfNeeded(FIELD_NODE_INDEX_TO_RELATION_INDICES);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.nodeIndexToRelationIndices;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LongArrayOfArrays nodeInEdgesIndices() {
        if (this.nodeInEdgesIndices != null) return this.nodeInEdgesIndices;
        String string = FIELD_NODE_IN_EDGES_INDICES;
        synchronized (FIELD_NODE_IN_EDGES_INDICES) {
            if (this.nodeInEdgesIndices != null) return this.nodeInEdgesIndices;
            this.serializer.deserializeIfNeeded(FIELD_NODE_IN_EDGES_INDICES);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.nodeInEdgesIndices;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LongArray nodeLocations() {
        if (this.nodeLocations != null) return this.nodeLocations;
        String string = FIELD_NODE_LOCATIONS;
        synchronized (FIELD_NODE_LOCATIONS) {
            if (this.nodeLocations != null) return this.nodeLocations;
            this.serializer.deserializeIfNeeded(FIELD_NODE_LOCATIONS);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.nodeLocations;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LongArrayOfArrays nodeOutEdgesIndices() {
        if (this.nodeOutEdgesIndices != null) return this.nodeOutEdgesIndices;
        String string = FIELD_NODE_OUT_EDGES_INDICES;
        synchronized (FIELD_NODE_OUT_EDGES_INDICES) {
            if (this.nodeOutEdgesIndices != null) return this.nodeOutEdgesIndices;
            this.serializer.deserializeIfNeeded(FIELD_NODE_OUT_EDGES_INDICES);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.nodeOutEdgesIndices;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private PackedTagStore nodeTags() {
        if (this.nodeTags == null) {
            String string = FIELD_NODE_TAGS;
            // MONITORENTER : "nodeTags"
            if (this.nodeTags == null) {
                this.serializer.deserializeIfNeeded(FIELD_NODE_TAGS);
            }
            // MONITOREXIT : string
        }
        this.nodeTags.setDictionary(this.dictionary());
        return this.nodeTags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LongArray pointIdentifiers() {
        if (this.pointIdentifiers != null) return this.pointIdentifiers;
        String string = FIELD_POINT_IDENTIFIERS;
        synchronized (FIELD_POINT_IDENTIFIERS) {
            if (this.pointIdentifiers != null) return this.pointIdentifiers;
            this.serializer.deserializeIfNeeded(FIELD_POINT_IDENTIFIERS);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.pointIdentifiers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LongToLongMap pointIdentifierToPointArrayIndex() {
        if (this.pointIdentifierToPointArrayIndex != null) return this.pointIdentifierToPointArrayIndex;
        String string = FIELD_POINT_IDENTIFIER_TO_POINT_ARRAY_INDEX;
        synchronized (FIELD_POINT_IDENTIFIER_TO_POINT_ARRAY_INDEX) {
            if (this.pointIdentifierToPointArrayIndex != null) return this.pointIdentifierToPointArrayIndex;
            this.serializer.deserializeIfNeeded(FIELD_POINT_IDENTIFIER_TO_POINT_ARRAY_INDEX);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.pointIdentifierToPointArrayIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LongToLongMultiMap pointIndexToRelationIndices() {
        if (this.pointIndexToRelationIndices != null) return this.pointIndexToRelationIndices;
        String string = FIELD_POINT_INDEX_TO_RELATION_INDICES;
        synchronized (FIELD_POINT_INDEX_TO_RELATION_INDICES) {
            if (this.pointIndexToRelationIndices != null) return this.pointIndexToRelationIndices;
            this.serializer.deserializeIfNeeded(FIELD_POINT_INDEX_TO_RELATION_INDICES);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.pointIndexToRelationIndices;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LongArray pointLocations() {
        if (this.pointLocations != null) return this.pointLocations;
        String string = FIELD_POINT_LOCATIONS;
        synchronized (FIELD_POINT_LOCATIONS) {
            if (this.pointLocations != null) return this.pointLocations;
            this.serializer.deserializeIfNeeded(FIELD_POINT_LOCATIONS);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.pointLocations;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private PackedTagStore pointTags() {
        if (this.pointTags == null) {
            String string = FIELD_POINT_TAGS;
            // MONITORENTER : "pointTags"
            if (this.pointTags == null) {
                this.serializer.deserializeIfNeeded(FIELD_POINT_TAGS);
            }
            // MONITOREXIT : string
        }
        this.pointTags.setDictionary(this.dictionary());
        return this.pointTags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LongArray relationIdentifiers() {
        if (this.relationIdentifiers != null) return this.relationIdentifiers;
        String string = FIELD_RELATION_IDENTIFIERS;
        synchronized (FIELD_RELATION_IDENTIFIERS) {
            if (this.relationIdentifiers != null) return this.relationIdentifiers;
            this.serializer.deserializeIfNeeded(FIELD_RELATION_IDENTIFIERS);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.relationIdentifiers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LongToLongMap relationIdentifierToRelationArrayIndex() {
        if (this.relationIdentifierToRelationArrayIndex != null) return this.relationIdentifierToRelationArrayIndex;
        String string = FIELD_RELATION_IDENTIFIER_TO_RELATION_ARRAY_INDEX;
        synchronized (FIELD_RELATION_IDENTIFIER_TO_RELATION_ARRAY_INDEX) {
            if (this.relationIdentifierToRelationArrayIndex != null) return this.relationIdentifierToRelationArrayIndex;
            this.serializer.deserializeIfNeeded(FIELD_RELATION_IDENTIFIER_TO_RELATION_ARRAY_INDEX);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.relationIdentifierToRelationArrayIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LongToLongMultiMap relationIndexToRelationIndices() {
        if (this.relationIndexToRelationIndices != null) return this.relationIndexToRelationIndices;
        String string = FIELD_RELATION_INDEX_TO_RELATION_INDICES;
        synchronized (FIELD_RELATION_INDEX_TO_RELATION_INDICES) {
            if (this.relationIndexToRelationIndices != null) return this.relationIndexToRelationIndices;
            this.serializer.deserializeIfNeeded(FIELD_RELATION_INDEX_TO_RELATION_INDICES);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.relationIndexToRelationIndices;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LongArrayOfArrays relationMemberIndices() {
        if (this.relationMemberIndices != null) return this.relationMemberIndices;
        String string = FIELD_RELATION_MEMBERS_INDICES;
        synchronized (FIELD_RELATION_MEMBERS_INDICES) {
            if (this.relationMemberIndices != null) return this.relationMemberIndices;
            this.serializer.deserializeIfNeeded(FIELD_RELATION_MEMBERS_INDICES);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.relationMemberIndices;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IntegerArrayOfArrays relationMemberRoles() {
        if (this.relationMemberRoles != null) return this.relationMemberRoles;
        String string = FIELD_RELATION_MEMBER_ROLES;
        synchronized (FIELD_RELATION_MEMBER_ROLES) {
            if (this.relationMemberRoles != null) return this.relationMemberRoles;
            this.serializer.deserializeIfNeeded(FIELD_RELATION_MEMBER_ROLES);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.relationMemberRoles;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ByteArrayOfArrays relationMemberTypes() {
        if (this.relationMemberTypes != null) return this.relationMemberTypes;
        String string = FIELD_RELATION_MEMBER_TYPES;
        synchronized (FIELD_RELATION_MEMBER_TYPES) {
            if (this.relationMemberTypes != null) return this.relationMemberTypes;
            this.serializer.deserializeIfNeeded(FIELD_RELATION_MEMBER_TYPES);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.relationMemberTypes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LongArray relationOsmIdentifiers() {
        if (this.relationOsmIdentifiers != null) return this.relationOsmIdentifiers;
        String string = FIELD_RELATION_OSM_IDENTIFIERS;
        synchronized (FIELD_RELATION_OSM_IDENTIFIERS) {
            if (this.relationOsmIdentifiers != null) return this.relationOsmIdentifiers;
            this.serializer.deserializeIfNeeded(FIELD_RELATION_OSM_IDENTIFIERS);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.relationOsmIdentifiers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LongToLongMultiMap relationOsmIdentifierToRelationIdentifiers() {
        if (this.relationOsmIdentifierToRelationIdentifiers != null) return this.relationOsmIdentifierToRelationIdentifiers;
        String string = FIELD_RELATION_OSM_IDENTIFIER_TO_RELATION_IDENTIFIERS;
        synchronized (FIELD_RELATION_OSM_IDENTIFIER_TO_RELATION_IDENTIFIERS) {
            if (this.relationOsmIdentifierToRelationIdentifiers != null) return this.relationOsmIdentifierToRelationIdentifiers;
            this.serializer.deserializeIfNeeded(FIELD_RELATION_OSM_IDENTIFIER_TO_RELATION_IDENTIFIERS);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.relationOsmIdentifierToRelationIdentifiers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private PackedTagStore relationTags() {
        if (this.relationTags == null) {
            String string = FIELD_RELATION_TAGS;
            // MONITORENTER : "relationTags"
            if (this.relationTags == null) {
                this.serializer.deserializeIfNeeded(FIELD_RELATION_TAGS);
            }
            // MONITOREXIT : string
        }
        this.relationTags.setDictionary(this.dictionary());
        return this.relationTags;
    }

    private void updateNodeEdgesReference(long nodeIndex, LongArrayOfArrays nodeEdgesIndices, long edgeIndex) {
        long[] nodeEdges = (long[])nodeEdgesIndices.get(nodeIndex);
        long[] newNodeEdges = new long[nodeEdges.length + 1];
        for (int i = 0; i < nodeEdges.length; ++i) {
            newNodeEdges[i] = nodeEdges[i];
        }
        newNodeEdges[newNodeEdges.length - 1] = edgeIndex;
        nodeEdgesIndices.set(nodeIndex, newNodeEdges);
    }

    public static enum AtlasSerializationFormat {
        JAVA,
        PROTOBUF;

    }
}

