/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.multi;

import com.google.common.collect.Sets;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.geography.atlas.items.RelationMemberList;
import org.openstreetmap.atlas.geography.atlas.multi.MultiAtlas;
import org.openstreetmap.atlas.geography.atlas.multi.SubRelationList;
import org.openstreetmap.atlas.utilities.maps.MultiMapWithSet;

public class MultiRelation
extends Relation {
    private static final long serialVersionUID = 2377231271257992525L;
    private final long identifier;
    private SubRelationList subRelations;

    protected MultiRelation(MultiAtlas atlas, long identifier) {
        super(atlas);
        this.identifier = identifier;
    }

    @Override
    public RelationMemberList allKnownOsmMembers() {
        ArrayList<RelationMember> members = new ArrayList<RelationMember>();
        for (Relation candidate : this.multiAtlas().relationAllRelationsWithSameOsmIdentifier(this.identifier)) {
            candidate.members().forEach(relationMember -> members.add((RelationMember)relationMember));
        }
        return new RelationMemberList(members);
    }

    @Override
    public List<Relation> allRelationsWithSameOsmIdentifier() {
        return this.multiAtlas().relationAllRelationsWithSameOsmIdentifier(this.identifier);
    }

    @Override
    public long getIdentifier() {
        return this.identifier;
    }

    @Override
    public Map<String, String> getTags() {
        return this.getSingleSubRelation().getTags();
    }

    @Override
    public RelationMemberList members() {
        TreeSet<RelationMember> members = new TreeSet<RelationMember>();
        SubRelationList subRelations = this.getSubRelations();
        boolean hasFixEdges = subRelations.hasFixRelation();
        MultiMapWithSet<Long, Long> relationIdentifiersToRemovedEdgeMembers = this.multiAtlas().getRelationIdentifiersToRemovedEdgeMembers();
        for (Relation subRelation : subRelations.getSubRelations()) {
            RelationMemberList subMembers = subRelation.members();
            for (RelationMember subMember : subMembers) {
                AtlasEntity nonMulti = subMember.getEntity();
                long identifier = nonMulti.getIdentifier();
                AtlasEntity multiEntity = null;
                if (nonMulti instanceof Node) {
                    multiEntity = this.multiAtlas().node(identifier);
                } else if (nonMulti instanceof Edge) {
                    if (!hasFixEdges || relationIdentifiersToRemovedEdgeMembers.get(this.getIdentifier()) == null || !relationIdentifiersToRemovedEdgeMembers.get(this.getIdentifier()).contains(nonMulti.getIdentifier())) {
                        multiEntity = this.multiAtlas().edge(identifier);
                    }
                } else if (nonMulti instanceof Area) {
                    multiEntity = this.multiAtlas().area(identifier);
                } else if (nonMulti instanceof Line) {
                    multiEntity = this.multiAtlas().line(identifier);
                } else if (nonMulti instanceof Point) {
                    multiEntity = this.multiAtlas().point(identifier);
                } else if (nonMulti instanceof Relation) {
                    multiEntity = this.multiAtlas().relation(identifier);
                } else {
                    throw new CoreException("Could not find the proper type for {}", nonMulti);
                }
                if (multiEntity == null) continue;
                members.add(new RelationMember(subMember.getRole(), multiEntity, subMember.getRelationIdentifier()));
            }
        }
        if (hasFixEdges) {
            Relation fixRelation = subRelations.getFixRelation();
            RelationMemberList subMembers = fixRelation.members();
            for (RelationMember subMember : subMembers) {
                AtlasEntity nonMulti = subMember.getEntity();
                long identifier = nonMulti.getIdentifier();
                Edge multiEntity = null;
                if (nonMulti instanceof Edge) {
                    multiEntity = this.multiAtlas().edge(identifier);
                }
                members.add(new RelationMember(subMember.getRole(), multiEntity, subMember.getRelationIdentifier()));
            }
        }
        if (members.isEmpty()) {
            throw new CoreException("This should not happen: MultiRelation {} has no members. Its sub relations are {}.", this.getIdentifier(), subRelations);
        }
        return new RelationMemberList(members);
    }

    @Override
    public long osmRelationIdentifier() {
        return this.getSingleSubRelation().osmRelationIdentifier();
    }

    @Override
    public Set<Relation> relations() {
        AbstractSet unionOfAllParentRelations = new HashSet<Relation>();
        for (Relation subRelations : this.getSubRelations().getSubRelations()) {
            Set<Relation> currentSubRelationParentRelations = this.multiAtlas().multifyRelations(subRelations);
            unionOfAllParentRelations = Sets.union(unionOfAllParentRelations, currentSubRelationParentRelations);
        }
        return unionOfAllParentRelations;
    }

    private Relation getSingleSubRelation() {
        return this.getSubRelations().getSubRelations().get(0);
    }

    private SubRelationList getSubRelations() {
        if (this.subRelations == null) {
            this.subRelations = this.multiAtlas().subRelations(this.identifier);
        }
        return this.subRelations;
    }

    private MultiAtlas multiAtlas() {
        return (MultiAtlas)this.getAtlas();
    }
}

