/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.multi;

import com.google.common.collect.Sets;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.multi.MultiAtlas;
import org.openstreetmap.atlas.geography.atlas.multi.SubNodeList;
import org.openstreetmap.atlas.utilities.maps.MultiMapWithSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiNode
extends Node {
    private static final long serialVersionUID = 4280290265432052817L;
    private static final Logger logger = LoggerFactory.getLogger(MultiNode.class);
    private final long identifier;
    private SubNodeList subNodes;

    protected MultiNode(MultiAtlas atlas, long identifier) {
        super(atlas);
        this.identifier = identifier;
    }

    @Override
    public long getIdentifier() {
        return this.identifier;
    }

    @Override
    public Location getLocation() {
        return this.getRepresentativeSubNode().getLocation();
    }

    public SubNodeList getSubNodes() {
        if (this.subNodes == null) {
            this.subNodes = this.multiAtlas().subNodes(this.identifier);
        }
        return this.subNodes;
    }

    @Override
    public Map<String, String> getTags() {
        return this.getRepresentativeSubNode().getTags();
    }

    @Override
    public SortedSet<Edge> inEdges() {
        return this.attachedEdgesFromOverlappingNodes(node -> node.inEdges(), this.multiAtlas().getNodeIdentifiersToRemovedInEdges());
    }

    @Override
    public SortedSet<Edge> outEdges() {
        return this.attachedEdgesFromOverlappingNodes(node -> node.outEdges(), this.multiAtlas().getNodeIdentifiersToRemovedOutEdges());
    }

    @Override
    public Set<Relation> relations() {
        AbstractSet unionOfAllParentRelations = new HashSet<Relation>();
        for (Node subNode : this.getSubNodes().getSubNodes()) {
            Set<Relation> currentSubNodeParentRelations = this.multiAtlas().multifyRelations(subNode);
            unionOfAllParentRelations = Sets.union(unionOfAllParentRelations, currentSubNodeParentRelations);
        }
        return unionOfAllParentRelations;
    }

    protected SortedSet<Edge> attachedEdges(Function<Node, Set<Edge>> getConnectedEdges, MultiMapWithSet<Long, Long> removedEdges) {
        HashSet<Long> subResult = new HashSet<Long>();
        if (this.getSubNodes().size() == 1) {
            getConnectedEdges.apply(this.getRepresentativeSubNode()).forEach(edge -> subResult.add(edge.getIdentifier()));
        } else {
            SubNodeList subNodes = this.getSubNodes();
            boolean isFixedNode = subNodes.hasFixNode();
            Object removedEdgesForNode = removedEdges.get(this.getIdentifier());
            boolean hasRemovedEdges = removedEdgesForNode != null;
            for (Node node : subNodes.getSubNodes()) {
                for (Edge connectedEdge : getConnectedEdges.apply(node)) {
                    if (isFixedNode && hasRemovedEdges && removedEdgesForNode.contains(connectedEdge.getIdentifier())) continue;
                    subResult.add(connectedEdge.getIdentifier());
                }
            }
            if (isFixedNode) {
                Node fixNode = subNodes.getFixNode();
                for (Edge connectedEdge : getConnectedEdges.apply(fixNode)) {
                    subResult.add(connectedEdge.getIdentifier());
                }
            }
        }
        TreeSet<Edge> result = new TreeSet<Edge>();
        for (Long subEdgeIdentifier : subResult) {
            Edge multiEdge = this.multiAtlas().edge(subEdgeIdentifier);
            if (multiEdge == null) {
                ArrayList<String> missingEdgeAtlasNames = new ArrayList<String>();
                List<Atlas> list = ((MultiAtlas)this.getAtlas()).getAtlases();
                for (int index = 0; index < list.size(); ++index) {
                    Atlas subAtlas = list.get(index);
                    Edge subEdge = subAtlas.edge(subEdgeIdentifier);
                    if (subEdge == null) continue;
                    missingEdgeAtlasNames.add(subAtlas.getName());
                }
                logger.warn("Some edge got lost in translation, and is not in the MultiAtlas. The node below probably has another node at the exact same location!\n\tNode: {}\n\tEdge connected: {}\n\tFrom SubAtlas: {}", new Object[]{this.identifier, subEdgeIdentifier, missingEdgeAtlasNames});
                continue;
            }
            result.add(multiEdge);
        }
        return result;
    }

    protected SortedSet<Edge> attachedEdgesFromOverlappingNodes(Function<Node, Set<Edge>> getConnectedEdges, MultiMapWithSet<Long, Long> removedEdges) {
        Set<Long> slaveNodes = this.multiAtlas().overlappingNodes(this.getIdentifier());
        Optional<Long> masterNode = this.multiAtlas().masterNode(this.identifier);
        if (!slaveNodes.isEmpty()) {
            SortedSet<Edge> result = this.attachedEdges(getConnectedEdges, removedEdges);
            slaveNodes.forEach(slaveIdentifier -> result.addAll(((MultiNode)this.multiAtlas().node((long)slaveIdentifier)).attachedEdges(getConnectedEdges, removedEdges)));
            return result;
        }
        if (masterNode.isPresent()) {
            return new TreeSet<Edge>();
        }
        return this.attachedEdges(getConnectedEdges, removedEdges);
    }

    private Node getRepresentativeSubNode() {
        SubNodeList subNodes = this.getSubNodes();
        if (subNodes.hasFixNode()) {
            return subNodes.getFixNode();
        }
        return this.getSubNodes().getSubNodes().get(0);
    }

    private MultiAtlas multiAtlas() {
        return (MultiAtlas)this.getAtlas();
    }
}

