/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.multi;

import com.google.common.collect.Sets;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.multi.MultiAtlas;
import org.openstreetmap.atlas.geography.atlas.multi.SubLineList;

public class MultiLine
extends Line {
    private static final long serialVersionUID = 4833193008195471987L;
    private final long identifier;
    private SubLineList subLineList;

    protected MultiLine(MultiAtlas atlas, long identifier) {
        super(atlas);
        this.identifier = identifier;
    }

    @Override
    public PolyLine asPolyLine() {
        return this.getRepresentativeSubLine().asPolyLine();
    }

    @Override
    public long getIdentifier() {
        return this.identifier;
    }

    public SubLineList getSubLines() {
        if (this.subLineList == null) {
            this.subLineList = this.multiAtlas().subLines(this.identifier);
        }
        return this.subLineList;
    }

    @Override
    public Map<String, String> getTags() {
        return this.getRepresentativeSubLine().getTags();
    }

    @Override
    public Set<Relation> relations() {
        AbstractSet unionOfAllParentRelations = new HashSet<Relation>();
        for (Line subLine : this.getSubLines().getSubLines()) {
            Set<Relation> currentSubLineParentRelations = this.multiAtlas().multifyRelations(subLine);
            unionOfAllParentRelations = Sets.union(unionOfAllParentRelations, currentSubLineParentRelations);
        }
        return unionOfAllParentRelations;
    }

    private Line getRepresentativeSubLine() {
        return this.getSubLines().getSubLines().get(0);
    }

    private MultiAtlas multiAtlas() {
        return (MultiAtlas)this.getAtlas();
    }
}

