/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.multi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Longitude;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.exception.AtlasIntegrityException;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.multi.MultiAtlas;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.maps.MultiMapWithSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiAtlasOverlappingNodesFixer
implements Serializable {
    private static final long serialVersionUID = -8926124646524609913L;
    private static final Logger logger = LoggerFactory.getLogger(MultiAtlasOverlappingNodesFixer.class);
    private final MultiAtlas parent;
    private final Map<Long, Long> overlappingNodeIdentifierToMasterNodeIdentifier = new HashMap<Long, Long>();
    private final MultiMapWithSet<Long, Long> masterNodeIdentifierToOverlappingNodeIdentifier = new MultiMapWithSet();

    protected MultiAtlasOverlappingNodesFixer(MultiAtlas parent) {
        this.parent = parent;
    }

    protected void aggregateSameLocationNodes() {
        this.parent.getNodeIdentifierToAtlasIndices().forEach(identifier -> {
            Node master = this.parent.node((long)identifier);
            Set<Node> slaves = this.nodesOverlapping(master);
            slaves.remove(master);
            if (!slaves.isEmpty() && !this.overlappingNodeIdentifierToMasterNodeIdentifier.containsKey(identifier)) {
                slaves.forEach(node -> {
                    long slaveIdentifier = node.getIdentifier();
                    this.overlappingNodeIdentifierToMasterNodeIdentifier.put(slaveIdentifier, (Long)identifier);
                    this.masterNodeIdentifierToOverlappingNodeIdentifier.add((Long)identifier, slaveIdentifier);
                });
                this.warnIfNodesHaveDifferentTags(master, slaves);
            }
        });
    }

    protected Optional<Long> masterNode(Long identifier) {
        return Optional.ofNullable(this.overlappingNodeIdentifierToMasterNodeIdentifier.get(identifier));
    }

    protected Set<Long> overlappingNodes(Long identifier) {
        if (this.masterNodeIdentifierToOverlappingNodeIdentifier.containsKey(identifier)) {
            return this.masterNodeIdentifierToOverlappingNodeIdentifier.get(identifier);
        }
        return new HashSet<Long>();
    }

    private Set<Node> nodesOverlapping(Node master) {
        ArrayList<Rectangle> bounds = new ArrayList<Rectangle>();
        Location masterLocation = master.getLocation();
        if (Longitude.ANTIMERIDIAN_WEST.equals(masterLocation.getLongitude())) {
            Location antimeridianMinimum = new Location(masterLocation.getLatitude(), Longitude.ANTIMERIDIAN_WEST);
            Location antimeridianMaximum = new Location(masterLocation.getLatitude(), Longitude.ANTIMERIDIAN_EAST);
            bounds.add(Rectangle.forCorners(antimeridianMinimum, antimeridianMinimum));
            bounds.add(Rectangle.forCorners(antimeridianMaximum, antimeridianMaximum));
        } else {
            bounds.add(master.bounds());
        }
        HashSet<Node> others = new HashSet<Node>();
        for (Rectangle bound : bounds) {
            others.addAll(Iterables.asSet(this.parent.nodesWithin(bound)));
        }
        if (others.isEmpty()) {
            throw new AtlasIntegrityException("A node has to overlap itself at least! {}", master);
        }
        return others;
    }

    private void warnIfNodesHaveDifferentTags(Node master, Set<Node> slaves) {
        Node origin = master;
        Map<String, String> tags = master.getTags();
        for (Node node : slaves) {
            if (tags.equals(node.getTags())) continue;
            logger.warn("Nodes overlap but have different tags: {} and {}", (Object)origin.getIdentifier(), (Object)node.getIdentifier());
        }
    }
}

