/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.multi;

import com.google.common.collect.ImmutableList;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.AbstractAtlas;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.AtlasMetaData;
import org.openstreetmap.atlas.geography.atlas.builder.AtlasSize;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.multi.MultiArea;
import org.openstreetmap.atlas.geography.atlas.multi.MultiAtlasBorderFixer;
import org.openstreetmap.atlas.geography.atlas.multi.MultiAtlasOverlappingNodesFixer;
import org.openstreetmap.atlas.geography.atlas.multi.MultiEdge;
import org.openstreetmap.atlas.geography.atlas.multi.MultiLine;
import org.openstreetmap.atlas.geography.atlas.multi.MultiNode;
import org.openstreetmap.atlas.geography.atlas.multi.MultiPoint;
import org.openstreetmap.atlas.geography.atlas.multi.MultiRelation;
import org.openstreetmap.atlas.geography.atlas.multi.SubAreaList;
import org.openstreetmap.atlas.geography.atlas.multi.SubLineList;
import org.openstreetmap.atlas.geography.atlas.multi.SubNodeList;
import org.openstreetmap.atlas.geography.atlas.multi.SubPointList;
import org.openstreetmap.atlas.geography.atlas.multi.SubRelationList;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlas;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlasCloner;
import org.openstreetmap.atlas.geography.index.RTree;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.Maps;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.maps.LongToIntegerMap;
import org.openstreetmap.atlas.utilities.maps.LongToIntegerMultiMap;
import org.openstreetmap.atlas.utilities.maps.LongToLongMap;
import org.openstreetmap.atlas.utilities.maps.LongToLongMultiMap;
import org.openstreetmap.atlas.utilities.maps.MultiMapWithSet;
import org.openstreetmap.atlas.utilities.scalars.Ratio;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiAtlas
extends AbstractAtlas {
    private static final long serialVersionUID = -5917117808042670700L;
    private static final Logger logger = LoggerFactory.getLogger(MultiAtlas.class);
    private static final double ARRAY_SIZE_MULTIPLIER = 1.1;
    private final List<Atlas> atlases;
    private final AtlasMetaData metaData;
    private final long numberOfEdges;
    private final long numberOfNodes;
    private final long numberOfAreas;
    private final long numberOfLines;
    private final long numberOfPoints;
    private final long numberOfRelations;
    private final RTree<Integer> atlasSpatialIndex;
    private LongToIntegerMap edgeIdentifierToAtlasIndex;
    private final LongToIntegerMultiMap nodeIdentifierToAtlasIndices;
    private final LongToIntegerMultiMap areaIdentifierToAtlasIndices;
    private final LongToIntegerMultiMap lineIdentifierToAtlasIndices;
    private final LongToIntegerMultiMap pointIdentifierToAtlasIndices;
    private final LongToIntegerMultiMap relationIdentifierToAtlasIndices;
    private final LongToLongMultiMap relationOsmIdentifierToRelationIdentifiers;
    private final LongToLongMap relationIdentifierToRelationOsmIdentifier;
    private final int subArraySize;
    private final long maximumSize;
    private final int nodeMemoryBlockSize;
    private final int edgeMemoryBlockSize;
    private final int areaMemoryBlockSize;
    private final int lineMemoryBlockSize;
    private final int pointMemoryBlockSize;
    private final int relationMemoryBlockSize;
    private final int nodeHashSize;
    private final int edgeHashSize;
    private final int areaHashSize;
    private final int lineHashSize;
    private final int pointHashSize;
    private final int relationHashSize;
    private final MultiAtlasBorderFixer borderFixer;
    private final MultiAtlasOverlappingNodesFixer nodesFixer;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MultiAtlas load(Resource resource) {
        try (ObjectInputStream input = new ObjectInputStream(resource.read());){
            MultiAtlas result;
            MultiAtlas multiAtlas = result = (MultiAtlas)input.readObject();
            return multiAtlas;
        }
        catch (Exception e) {
            throw new CoreException("Could not load Atlas from {}", (Throwable)e, resource);
        }
    }

    public static MultiAtlas loadFromPackedAtlas(Iterable<? extends Resource> resources) {
        return MultiAtlas.loadFromPackedAtlas(resources, false);
    }

    public static MultiAtlas loadFromPackedAtlas(Iterable<? extends Resource> resources, boolean lotsOfOverlap) {
        if (Iterables.size(resources) == 0L) {
            throw new CoreException("Can't create an atlas from zero resources");
        }
        return new MultiAtlas(Iterables.translate(resources, resource -> PackedAtlas.load(resource)), lotsOfOverlap);
    }

    public static MultiAtlas loadFromPackedAtlas(Iterable<? extends Resource> resources, boolean lotsOfOverlap, Predicate<AtlasEntity> filter) {
        if (Iterables.size(resources) == 0L) {
            throw new CoreException("Can't create an atlas from zero resources");
        }
        return new MultiAtlas(Iterables.translate(resources, resource -> PackedAtlas.load(resource).subAtlas(filter).get()), lotsOfOverlap);
    }

    public static MultiAtlas loadFromPackedAtlas(Iterable<? extends Resource> resources, Predicate<AtlasEntity> filter) {
        return MultiAtlas.loadFromPackedAtlas(resources, false, filter);
    }

    public static MultiAtlas loadFromPackedAtlas(Resource ... resources) {
        return MultiAtlas.loadFromPackedAtlas(Iterables.iterable(resources), false);
    }

    public MultiAtlas(Atlas ... atlases) {
        this(Iterables.iterable(atlases), false);
    }

    public MultiAtlas(Iterable<Atlas> atlases) {
        this(atlases, false);
    }

    public MultiAtlas(Iterable<Atlas> atlases, boolean lotsOfOverlap) {
        this(Iterables.asList(atlases), lotsOfOverlap);
    }

    public MultiAtlas(List<Atlas> atlases) {
        this(atlases, false);
    }

    public MultiAtlas(List<Atlas> atlases, boolean lotsOfOverlap) {
        long numberOfRelations;
        long numberOfPoints;
        long numberOfLines;
        long numberOfAreas;
        long numberOfNodes;
        long numberOfEdges;
        if (atlases.isEmpty()) {
            throw new CoreException("An Atlas is Located, and therefore cannot be empty.");
        }
        this.atlases = atlases;
        this.atlasSpatialIndex = this.newPackedAtlasSpatialIndex();
        if (lotsOfOverlap) {
            numberOfEdges = 1024L;
            numberOfNodes = 1024L;
            numberOfAreas = 1024L;
            numberOfLines = 1024L;
            numberOfPoints = 1024L;
            numberOfRelations = 1024L;
        } else {
            numberOfNodes = Iterables.count(this.atlases, atlas -> atlas.numberOfNodes());
            numberOfEdges = Iterables.count(this.atlases, atlas -> atlas.numberOfEdges());
            numberOfAreas = Iterables.count(this.atlases, atlas -> atlas.numberOfAreas());
            numberOfLines = Iterables.count(this.atlases, atlas -> atlas.numberOfLines());
            numberOfPoints = Iterables.count(this.atlases, atlas -> atlas.numberOfPoints());
            numberOfRelations = Iterables.count(this.atlases, atlas -> atlas.numberOfRelations());
        }
        if (atlases.size() > 1) {
            numberOfNodes = Math.round((double)numberOfNodes * 1.1);
            numberOfEdges = Math.round((double)numberOfEdges * 1.1);
            numberOfAreas = Math.round((double)numberOfAreas * 1.1);
            numberOfLines = Math.round((double)numberOfLines * 1.1);
            numberOfPoints = Math.round((double)numberOfPoints * 1.1);
            numberOfRelations = Math.round((double)numberOfRelations * 1.1);
        }
        int index = 0;
        for (Atlas atlas2 : this.atlases) {
            this.atlasSpatialIndex.add(atlas2.bounds(), index);
            ++index;
        }
        this.subArraySize = Integer.MAX_VALUE;
        this.maximumSize = Long.MAX_VALUE;
        this.nodeMemoryBlockSize = (int)Math.max(1024L, numberOfNodes % Integer.MAX_VALUE);
        this.edgeMemoryBlockSize = (int)Math.max(1024L, numberOfEdges % Integer.MAX_VALUE);
        this.areaMemoryBlockSize = (int)Math.max(1024L, numberOfAreas % Integer.MAX_VALUE);
        this.lineMemoryBlockSize = (int)Math.max(1024L, numberOfLines % Integer.MAX_VALUE);
        this.pointMemoryBlockSize = (int)Math.max(1024L, numberOfPoints % Integer.MAX_VALUE);
        this.relationMemoryBlockSize = (int)Math.max(1024L, numberOfRelations % Integer.MAX_VALUE);
        this.nodeHashSize = (int)Math.max(Math.min(numberOfNodes / 10L, Integer.MAX_VALUE), 1L);
        this.edgeHashSize = (int)Math.max(Math.min(numberOfEdges / 10L, Integer.MAX_VALUE), 1L);
        this.areaHashSize = (int)Math.max(Math.min(numberOfAreas / 10L, Integer.MAX_VALUE), 1L);
        this.lineHashSize = (int)Math.max(Math.min(numberOfLines / 10L, Integer.MAX_VALUE), 1L);
        this.pointHashSize = (int)Math.max(Math.min(numberOfPoints / 10L, Integer.MAX_VALUE), 1L);
        this.relationHashSize = (int)Math.max(Math.min(numberOfRelations / 10L, Integer.MAX_VALUE), 1L);
        this.nodeIdentifierToAtlasIndices = new LongToIntegerMultiMap("MultiAtlas - nodeIdentifierToAtlasIndices", this.maximumSize, this.nodeHashSize, this.nodeMemoryBlockSize, this.subArraySize, this.nodeMemoryBlockSize, this.subArraySize);
        this.edgeIdentifierToAtlasIndex = new LongToIntegerMap("MultiAtlas - edgeIdentifierToAtlasIndex", this.maximumSize, this.edgeHashSize, this.edgeMemoryBlockSize, this.subArraySize, this.edgeMemoryBlockSize, this.subArraySize);
        this.areaIdentifierToAtlasIndices = new LongToIntegerMultiMap("MultiAtlas - areaIdentifierToAtlasIndex", this.maximumSize, this.areaHashSize, this.areaMemoryBlockSize, this.subArraySize, this.areaMemoryBlockSize, this.subArraySize);
        this.lineIdentifierToAtlasIndices = new LongToIntegerMultiMap("MultiAtlas - lineIdentifierToAtlasIndex", this.maximumSize, this.lineHashSize, this.lineMemoryBlockSize, this.subArraySize, this.lineMemoryBlockSize, this.subArraySize);
        this.pointIdentifierToAtlasIndices = new LongToIntegerMultiMap("MultiAtlas - pointIdentifierToAtlasIndex", this.maximumSize, this.pointHashSize, this.pointMemoryBlockSize, this.subArraySize, this.pointMemoryBlockSize, this.subArraySize);
        this.relationIdentifierToAtlasIndices = new LongToIntegerMultiMap("MultiAtlas - relationIdentifierToAtlasIndices", this.maximumSize, this.relationHashSize, this.relationMemoryBlockSize, this.subArraySize, this.relationMemoryBlockSize, this.subArraySize);
        this.relationOsmIdentifierToRelationIdentifiers = new LongToLongMultiMap("MultiAtlas - relationOsmIdentifierToRelationIdentifier", this.maximumSize, this.relationHashSize, this.relationMemoryBlockSize, this.subArraySize, this.relationMemoryBlockSize, this.subArraySize);
        this.relationIdentifierToRelationOsmIdentifier = new LongToLongMap("MultiAtlas - relationIdentifierToRelationOsmIdentifier", this.maximumSize, this.relationHashSize, this.relationMemoryBlockSize, this.subArraySize, this.relationMemoryBlockSize, this.subArraySize);
        int atlasIndex = 0;
        for (Atlas atlas3 : this.atlases) {
            this.populateReferences(atlas3, atlasIndex);
            ++atlasIndex;
        }
        this.borderFixer = new MultiAtlasBorderFixer(this.atlases, this.edgeIdentifierToAtlasIndex);
        this.borderFixer.fixBorderIssues();
        if (this.borderFixer.hasFixes()) {
            LongToIntegerMap longToIntegerMap = new LongToIntegerMap("MultiAtlas - edgeIdentifierToAtlasIndexCandidate", this.getMaximumSize(), this.getEdgeHashSize(), this.getEdgeMemoryBlockSize(), this.getSubArraySize(), this.getEdgeMemoryBlockSize(), this.getSubArraySize());
            this.getEdgeIdentifierToAtlasIndex().forEach(identifier -> {
                if (!this.borderFixer.isFixEdgeIdentifier((long)identifier)) {
                    edgeIdentifierToAtlasIndexCandidate.put(identifier, this.getEdgeIdentifierToAtlasIndex().get(identifier));
                }
            });
            this.setEdgeIdentifierToAtlasIndex(longToIntegerMap);
            this.populateReferences(this.borderFixer.getFixAtlas(), -1);
        }
        this.getAsNewNodeSpatialIndex();
        this.getAsNewEdgeSpatialIndex();
        this.getAsNewAreaSpatialIndex();
        this.getAsNewLineSpatialIndex();
        this.getAsNewPointSpatialIndex();
        this.getAsNewRelationSpatialIndex();
        this.nodeIdentifierToAtlasIndices.forEach(identifier -> this.getNodeSpatialIndex().add(this.node((long)identifier)));
        this.edgeIdentifierToAtlasIndex.forEach(identifier -> this.getEdgeSpatialIndex().add(this.edge((long)identifier)));
        this.areaIdentifierToAtlasIndices.forEach(identifier -> this.getAreaSpatialIndex().add(this.area((long)identifier)));
        this.lineIdentifierToAtlasIndices.forEach(identifier -> this.getLineSpatialIndex().add(this.line((long)identifier)));
        this.pointIdentifierToAtlasIndices.forEach(identifier -> this.getPointSpatialIndex().add(this.point((long)identifier)));
        this.relationIdentifierToAtlasIndices.forEach(identifier -> {
            Relation relation = this.relation((long)identifier);
            if (relation.members().size() > 0 && relation.bounds() != null) {
                this.getRelationSpatialIndex().add(relation);
            }
            long osmIdentifier = relation.osmRelationIdentifier();
            this.relationOsmIdentifierToRelationIdentifiers.add(osmIdentifier, (long)identifier);
            this.relationIdentifierToRelationOsmIdentifier.put(identifier, osmIdentifier);
        });
        this.nodesFixer = new MultiAtlasOverlappingNodesFixer(this);
        this.nodesFixer.aggregateSameLocationNodes();
        this.numberOfEdges = this.edgeIdentifierToAtlasIndex.size();
        this.numberOfNodes = this.nodeIdentifierToAtlasIndices.size();
        this.numberOfAreas = this.areaIdentifierToAtlasIndices.size();
        this.numberOfLines = this.lineIdentifierToAtlasIndices.size();
        this.numberOfPoints = this.pointIdentifierToAtlasIndices.size();
        this.numberOfRelations = this.relationIdentifierToAtlasIndices.size();
        if (!lotsOfOverlap) {
            Ratio ratio = Ratio.HALF;
            this.nodeIdentifierToAtlasIndices.trimIfLessFilledThan(ratio);
            this.edgeIdentifierToAtlasIndex.trimIfLessFilledThan(ratio);
            this.areaIdentifierToAtlasIndices.trimIfLessFilledThan(ratio);
            this.lineIdentifierToAtlasIndices.trimIfLessFilledThan(ratio);
            this.pointIdentifierToAtlasIndices.trimIfLessFilledThan(ratio);
            this.relationIdentifierToAtlasIndices.trimIfLessFilledThan(ratio);
            this.relationOsmIdentifierToRelationIdentifiers.trimIfLessFilledThan(ratio);
            this.relationIdentifierToRelationOsmIdentifier.trimIfLessFilledThan(ratio);
        }
        this.metaData = this.mergeMetaData();
    }

    @Override
    public Area area(long identifier) {
        if (this.areaIdentifierToAtlasIndices.containsKey(identifier)) {
            return new MultiArea(this, identifier);
        }
        return null;
    }

    @Override
    public Iterable<Area> areas() {
        return Iterables.translate(this.areaIdentifierToAtlasIndices, this::area);
    }

    public Set<Atlas> atlasIntersecting(Polygon bounds) {
        if (!(bounds instanceof Rectangle)) {
            throw new UnsupportedOperationException("Non-Rectangle Polygons not supported yet.");
        }
        return Iterables.asSet(Iterables.translate(this.atlasSpatialIndex.get(bounds.bounds()), atlasIndex -> this.atlases.get((int)atlasIndex)));
    }

    @Override
    public Rectangle bounds() {
        return Rectangle.forLocated(this.atlases);
    }

    @Override
    public Edge edge(long identifier) {
        if (this.edgeIdentifierToAtlasIndex.containsKey(identifier)) {
            return new MultiEdge(this, identifier);
        }
        return null;
    }

    @Override
    public Iterable<Edge> edges() {
        return Iterables.translate(this.edgeIdentifierToAtlasIndex, identifier -> this.edge((long)identifier));
    }

    @Override
    public Line line(long identifier) {
        if (this.lineIdentifierToAtlasIndices.containsKey(identifier)) {
            return new MultiLine(this, identifier);
        }
        return null;
    }

    @Override
    public Iterable<Line> lines() {
        return Iterables.translate(this.lineIdentifierToAtlasIndices, this::line);
    }

    @Override
    public AtlasMetaData metaData() {
        return this.metaData;
    }

    @Override
    public Node node(long identifier) {
        if (this.nodeIdentifierToAtlasIndices.containsKey(identifier)) {
            return new MultiNode(this, identifier);
        }
        return null;
    }

    @Override
    public Iterable<Node> nodes() {
        return Iterables.translate(this.nodeIdentifierToAtlasIndices, identifier -> this.node((long)identifier));
    }

    @Override
    public long numberOfAreas() {
        return this.numberOfAreas;
    }

    @Override
    public long numberOfEdges() {
        return this.numberOfEdges;
    }

    @Override
    public long numberOfLines() {
        return this.numberOfLines;
    }

    @Override
    public long numberOfNodes() {
        return this.numberOfNodes;
    }

    @Override
    public long numberOfPoints() {
        return this.numberOfPoints;
    }

    @Override
    public long numberOfRelations() {
        return this.numberOfRelations;
    }

    public int numberOfSubAtlas() {
        return this.atlases.size();
    }

    @Override
    public Point point(long identifier) {
        if (this.pointIdentifierToAtlasIndices.containsKey(identifier)) {
            return new MultiPoint(this, identifier);
        }
        return null;
    }

    @Override
    public Iterable<Point> points() {
        return Iterables.translate(this.pointIdentifierToAtlasIndices, identifier -> this.point((long)identifier));
    }

    @Override
    public Relation relation(long identifier) {
        if (this.relationIdentifierToAtlasIndices.containsKey(identifier)) {
            return new MultiRelation(this, identifier);
        }
        return null;
    }

    @Override
    public Iterable<Relation> relations() {
        return Iterables.translate(this.relationIdentifierToAtlasIndices, identifier -> this.relation((long)identifier));
    }

    @Override
    public void save(WritableResource writableResource) {
        throw new CoreException("A MultiAtlas has to be cloned to a {} before it can be saved. Consider using {}", PackedAtlas.class.getName(), PackedAtlasCloner.class.getName());
    }

    public List<Atlas> subAtlases() {
        return ImmutableList.copyOf(this.atlases);
    }

    protected List<Atlas> getAtlases() {
        return this.atlases;
    }

    protected int getEdgeHashSize() {
        return this.edgeHashSize;
    }

    protected LongToIntegerMap getEdgeIdentifierToAtlasIndex() {
        return this.edgeIdentifierToAtlasIndex;
    }

    protected int getEdgeMemoryBlockSize() {
        return this.edgeMemoryBlockSize;
    }

    protected long getMaximumSize() {
        return this.maximumSize;
    }

    protected MultiMapWithSet<Long, Long> getNodeIdentifiersToRemovedInEdges() {
        return this.borderFixer.getNodeIdentifiersToRemovedInEdges();
    }

    protected MultiMapWithSet<Long, Long> getNodeIdentifiersToRemovedOutEdges() {
        return this.borderFixer.getNodeIdentifiersToRemovedOutEdges();
    }

    protected LongToIntegerMultiMap getNodeIdentifierToAtlasIndices() {
        return this.nodeIdentifierToAtlasIndices;
    }

    protected MultiMapWithSet<Long, Long> getRelationIdentifiersToRemovedEdgeMembers() {
        return this.borderFixer.getRelationIdentifiersToRemovedEdgeMembers();
    }

    protected int getSubArraySize() {
        return this.subArraySize;
    }

    protected Optional<Long> masterNode(Long identifier) {
        return this.nodesFixer.masterNode(identifier);
    }

    protected Set<Relation> multifyRelations(AtlasEntity entity) {
        Set<Relation> subRelations = entity.relations();
        HashSet<Relation> result = new HashSet<Relation>();
        for (Relation relation : subRelations) {
            result.add(this.relation(relation.getIdentifier()));
        }
        return result;
    }

    protected Set<Long> overlappingNodes(Long identifier) {
        return this.nodesFixer.overlappingNodes(identifier);
    }

    protected void populateReferences(Atlas atlas, int atlasIndex) {
        for (Node node : atlas.nodes()) {
            this.nodeIdentifierToAtlasIndices.add(node.getIdentifier(), atlasIndex);
        }
        for (Edge edge : atlas.edges()) {
            this.edgeIdentifierToAtlasIndex.put(edge.getIdentifier(), atlasIndex);
        }
        for (Area area : atlas.areas()) {
            this.areaIdentifierToAtlasIndices.add(area.getIdentifier(), atlasIndex);
        }
        for (Line line : atlas.lines()) {
            this.lineIdentifierToAtlasIndices.add(line.getIdentifier(), atlasIndex);
        }
        for (Point point : atlas.points()) {
            this.pointIdentifierToAtlasIndices.add(point.getIdentifier(), atlasIndex);
        }
        for (Relation relation : atlas.relations()) {
            this.relationIdentifierToAtlasIndices.add(relation.getIdentifier(), atlasIndex);
        }
    }

    protected List<Relation> relationAllRelationsWithSameOsmIdentifier(long identifier) {
        ArrayList<Relation> result = new ArrayList<Relation>();
        long osmIdentifier = (Long)this.relationIdentifierToRelationOsmIdentifier.get(identifier);
        for (long candidateIdentifier : (long[])this.relationOsmIdentifierToRelationIdentifiers.get(osmIdentifier)) {
            result.add(this.relation(candidateIdentifier));
        }
        return result;
    }

    protected void setEdgeIdentifierToAtlasIndex(LongToIntegerMap edgeIdentifierToAtlasIndex) {
        this.edgeIdentifierToAtlasIndex = edgeIdentifierToAtlasIndex;
    }

    protected SubAreaList subAreas(long identifier) {
        ArrayList<Area> subAreas = new ArrayList<Area>();
        for (int index : (int[])this.areaIdentifierToAtlasIndices.get(identifier)) {
            if (index == -1) continue;
            subAreas.add(this.atlases.get(index).area(identifier));
        }
        return new SubAreaList(subAreas);
    }

    protected Edge subEdge(long identifier) {
        Edge subEdge;
        if (this.borderFixer.hasFixes() && (subEdge = this.borderFixer.fixEdge(identifier)) != null) {
            return subEdge;
        }
        return this.atlases.get((Integer)this.edgeIdentifierToAtlasIndex.get(identifier)).edge(identifier);
    }

    protected SubLineList subLines(long identifier) {
        ArrayList<Line> subLines = new ArrayList<Line>();
        for (int index : (int[])this.lineIdentifierToAtlasIndices.get(identifier)) {
            if (index == -1) continue;
            subLines.add(this.atlases.get(index).line(identifier));
        }
        return new SubLineList(subLines);
    }

    protected SubNodeList subNodes(long identifier) {
        ArrayList<Node> subNodes = new ArrayList<Node>();
        for (int index : (int[])this.nodeIdentifierToAtlasIndices.get(identifier)) {
            if (index == -1) continue;
            subNodes.add(this.atlases.get(index).node(identifier));
        }
        Node fixNode = null;
        if (this.borderFixer.hasFixes() && this.borderFixer.nodeIsFixed(identifier)) {
            fixNode = this.borderFixer.fixNode(identifier);
        }
        return new SubNodeList(subNodes, fixNode);
    }

    protected SubPointList subPoints(long identifier) {
        ArrayList<Point> subPoints = new ArrayList<Point>();
        for (int index : (int[])this.pointIdentifierToAtlasIndices.get(identifier)) {
            if (index == -1) continue;
            subPoints.add(this.atlases.get(index).point(identifier));
        }
        return new SubPointList(subPoints);
    }

    protected SubRelationList subRelations(long identifier) {
        ArrayList<Relation> subRelations = new ArrayList<Relation>();
        for (int index : (int[])this.relationIdentifierToAtlasIndices.get(identifier)) {
            if (index == -1) continue;
            subRelations.add(this.atlases.get(index).relation(identifier));
        }
        Relation fixRelation = null;
        if (this.borderFixer.hasFixes() && this.borderFixer.relationIsFixed(identifier)) {
            fixRelation = this.borderFixer.fixRelation(identifier);
        }
        return new SubRelationList(subRelations, fixRelation);
    }

    private AtlasMetaData mergeMetaData() {
        List shardNames;
        List dataVersions;
        AtlasSize size = new AtlasSize(this.numberOfEdges, this.numberOfNodes, this.numberOfAreas, this.numberOfLines, this.numberOfPoints, this.numberOfRelations);
        String codeVersion = null;
        String dataVersion = null;
        String shardName = null;
        Map<String, String> tags = Maps.hashMap(new String[0]);
        StringList countries = new StringList(this.atlases.stream().map(Atlas::metaData).map(AtlasMetaData::getCountry).filter(Optional::isPresent).map(Optional::get).flatMap(value -> StringList.split(value, ",").stream()).distinct().collect(Collectors.toList()));
        List codeVersions = this.atlases.stream().map(Atlas::metaData).map(AtlasMetaData::getCodeVersion).filter(Optional::isPresent).map(Optional::get).distinct().collect(Collectors.toList());
        if (codeVersions.size() > 1) {
            logger.warn("Two sub atlas files have different code versions: {}", codeVersions);
        }
        if (codeVersions.size() > 0) {
            codeVersion = (String)codeVersions.get(0);
        }
        if ((dataVersions = this.atlases.stream().map(Atlas::metaData).map(AtlasMetaData::getDataVersion).filter(Optional::isPresent).map(Optional::get).distinct().collect(Collectors.toList())).size() > 1) {
            logger.warn("Two sub atlas files have different data versions: {}", dataVersions);
        }
        if (dataVersions.size() > 0) {
            dataVersion = (String)dataVersions.get(0);
        }
        if ((shardNames = this.atlases.stream().map(Atlas::metaData).map(AtlasMetaData::getShardName).filter(Optional::isPresent).map(Optional::get).distinct().collect(Collectors.toList())).size() > 1) {
            logger.warn("Two sub atlas files have different shard names: {}", shardNames);
        }
        if (shardNames.size() > 0) {
            shardName = (String)shardNames.get(0);
        }
        this.atlases.stream().map(Atlas::metaData).map(AtlasMetaData::getTags).flatMap(map -> map.entrySet().stream()).forEach(entry -> {
            String overridenValue;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (tags.containsKey(key) && (overridenValue = (String)tags.get(key)) != null && !overridenValue.equals(value)) {
                logger.trace("AtlasMetaData has conflicting values for the same key: key = {}, and values = [{}, {}]. 2nd one is kept.", new Object[]{key, overridenValue, value});
            }
            tags.put(key, value);
        });
        return new AtlasMetaData(size, true, codeVersion, dataVersion, countries.isEmpty() ? null : countries.join(","), shardName, tags);
    }

    private RTree<Integer> newPackedAtlasSpatialIndex() {
        return new RTree<Integer>();
    }
}

