/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items.complex.waters.handler;

import java.util.Arrays;
import java.util.List;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.complex.waters.WaterType;
import org.openstreetmap.atlas.geography.atlas.items.complex.waters.handler.AbstractWaterHandler;
import org.openstreetmap.atlas.tags.NaturalTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.WetlandTag;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WetlandHandler
extends AbstractWaterHandler {
    private static final Logger logger = LoggerFactory.getLogger(WetlandHandler.class);

    public static boolean isWetland(AtlasEntity atlasEntity) {
        return Validators.isOfType((Taggable)atlasEntity, NaturalTag.class, (Enum[])new NaturalTag[]{NaturalTag.WETLAND}) && Validators.isOfType((Taggable)atlasEntity, WetlandTag.class, (Enum[])new WetlandTag[]{WetlandTag.SWAMP, WetlandTag.MARSH, WetlandTag.REEDBED});
    }

    @Override
    public boolean canHandle(AtlasEntity entity) {
        return WetlandHandler.isWetland(entity);
    }

    @Override
    public List<ItemType> getAllowedTypes() {
        return Arrays.asList(ItemType.AREA, ItemType.LINE);
    }

    @Override
    public Logger getLogger() {
        return logger;
    }

    @Override
    public WaterType getType() {
        return WaterType.WETLAND;
    }
}

