/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items.complex.waters.handler;

import java.util.Arrays;
import java.util.List;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.complex.waters.WaterType;
import org.openstreetmap.atlas.geography.atlas.items.complex.waters.handler.AbstractWaterHandler;
import org.openstreetmap.atlas.tags.LandUseTag;
import org.openstreetmap.atlas.tags.NaturalTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.WaterTag;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PondHandler
extends AbstractWaterHandler {
    private static final Logger logger = LoggerFactory.getLogger(PondHandler.class);

    public static boolean isPond(AtlasEntity atlasEntity) {
        if (Validators.isOfType((Taggable)atlasEntity, NaturalTag.class, (Enum[])new NaturalTag[]{NaturalTag.WATER}) && Validators.isOfType((Taggable)atlasEntity, WaterTag.class, (Enum[])new WaterTag[]{WaterTag.POND})) {
            return true;
        }
        return Validators.isOfType((Taggable)atlasEntity, LandUseTag.class, (Enum[])new LandUseTag[]{LandUseTag.POND});
    }

    @Override
    public boolean canHandle(AtlasEntity entity) {
        return PondHandler.isPond(entity);
    }

    @Override
    public List<ItemType> getAllowedTypes() {
        return Arrays.asList(ItemType.AREA);
    }

    @Override
    public Logger getLogger() {
        return logger;
    }

    @Override
    public WaterType getType() {
        return WaterType.POND;
    }
}

