/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items.complex.waters.handler;

import java.util.Arrays;
import java.util.List;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.complex.waters.WaterType;
import org.openstreetmap.atlas.geography.atlas.items.complex.waters.handler.AbstractWaterHandler;
import org.openstreetmap.atlas.geography.atlas.items.complex.waters.handler.HarbourHandler;
import org.openstreetmap.atlas.tags.NaturalTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.WaterTag;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LakeHandler
extends AbstractWaterHandler {
    private static final Logger logger = LoggerFactory.getLogger(LakeHandler.class);

    public static boolean isLake(AtlasEntity entity) {
        if (Validators.isOfType((Taggable)entity, NaturalTag.class, (Enum[])new NaturalTag[]{NaturalTag.WATER})) {
            if (Validators.isOfType((Taggable)entity, WaterTag.class, (Enum[])new WaterTag[]{WaterTag.LAKE, WaterTag.OXBOW})) {
                return true;
            }
            if (entity.getTag("waterway").isPresent() || entity.getTag("landuse").isPresent()) {
                return false;
            }
            if (HarbourHandler.isHarbour(entity)) {
                return false;
            }
            return !entity.getTag("water").isPresent();
        }
        return false;
    }

    @Override
    public boolean canHandle(AtlasEntity entity) {
        return LakeHandler.isLake(entity);
    }

    @Override
    public List<ItemType> getAllowedTypes() {
        return Arrays.asList(ItemType.AREA, ItemType.RELATION);
    }

    @Override
    public Logger getLogger() {
        return logger;
    }

    @Override
    public WaterType getType() {
        return WaterType.LAKE;
    }
}

