/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items.complex.waters.handler;

import java.util.Arrays;
import java.util.List;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.complex.waters.WaterType;
import org.openstreetmap.atlas.geography.atlas.items.complex.waters.handler.AbstractWaterHandler;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.WaterwayTag;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DitchHandler
extends AbstractWaterHandler {
    private static final Logger logger = LoggerFactory.getLogger(DitchHandler.class);

    public static boolean isDitch(AtlasEntity atlasEntity) {
        return Validators.isOfType((Taggable)atlasEntity, WaterwayTag.class, (Enum[])new WaterwayTag[]{WaterwayTag.DITCH, WaterwayTag.DRAIN});
    }

    @Override
    public boolean canHandle(AtlasEntity entity) {
        return DitchHandler.isDitch(entity);
    }

    @Override
    public List<ItemType> getAllowedTypes() {
        return Arrays.asList(ItemType.AREA, ItemType.LINE);
    }

    @Override
    public Logger getLogger() {
        return logger;
    }

    @Override
    public WaterType getType() {
        return WaterType.DITCH;
    }
}

