/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items.complex.waters.handler;

import java.util.Arrays;
import java.util.List;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.complex.waters.WaterType;
import org.openstreetmap.atlas.geography.atlas.items.complex.waters.handler.AbstractWaterHandler;
import org.openstreetmap.atlas.tags.NaturalTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.WaterTag;
import org.openstreetmap.atlas.tags.WaterwayTag;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CanalHandler
extends AbstractWaterHandler {
    private static final Logger logger = LoggerFactory.getLogger(CanalHandler.class);

    public static boolean isCanal(AtlasEntity entity) {
        if (Validators.isOfType((Taggable)entity, WaterwayTag.class, (Enum[])new WaterwayTag[]{WaterwayTag.CANAL})) {
            return true;
        }
        return Validators.isOfType((Taggable)entity, NaturalTag.class, (Enum[])new NaturalTag[]{NaturalTag.WATER}) && Validators.isOfType((Taggable)entity, WaterTag.class, (Enum[])new WaterTag[]{WaterTag.CANAL});
    }

    @Override
    public boolean canHandle(AtlasEntity entity) {
        return CanalHandler.isCanal(entity);
    }

    @Override
    public List<ItemType> getAllowedTypes() {
        return Arrays.asList(ItemType.AREA, ItemType.LINE, ItemType.RELATION);
    }

    @Override
    public Logger getLogger() {
        return logger;
    }

    @Override
    public WaterType getType() {
        return WaterType.CANAL;
    }
}

