/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items.complex.waters;

import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.complex.waters.ComplexWaterEntity;
import org.openstreetmap.atlas.geography.atlas.items.complex.waters.WaterType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComplexWaterway
extends ComplexWaterEntity {
    private static final long serialVersionUID = -5567739097914423531L;
    private static final Logger logger = LoggerFactory.getLogger(ComplexWaterway.class);
    private PolyLine geometry;

    public ComplexWaterway(AtlasEntity source, WaterType type) {
        super(source, type);
    }

    public PolyLine getGeometry() {
        return this.geometry;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected void populateGeometry() {
        AtlasEntity source = this.getSource();
        if (source instanceof Line) {
            Line line = (Line)source;
            this.geometry = line.asPolyLine();
            return;
        }
        throw new CoreException("Geometry is not set for {}", source);
    }
}

